/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.runtime.migration.internal.core;

import com.nxp.s32ds.cle.runtime.migration.action.MigrationActionDescriptor;
import com.nxp.s32ds.cle.runtime.migration.condition.MigrationConditionDescriptor;
import com.nxp.s32ds.cle.runtime.migration.diagnostic.MigrationDiagnostic;
import com.nxp.s32ds.cle.runtime.migration.diagnostic.MigrationDiagnosticElementType;
import com.nxp.s32ds.cle.runtime.migration.internal.core.sequence.MigrationSequenceDescriptorElement;
import com.nxp.s32ds.cle.runtime.migration.internal.core.sequence.MigrationSequenceImpl;
import com.nxp.s32ds.cle.runtime.migration.internal.core.sequence.model.BooleanVariable;
import com.nxp.s32ds.cle.runtime.migration.internal.core.sequence.model.Condition;
import com.nxp.s32ds.cle.runtime.migration.internal.core.sequence.model.RegularAction;
import com.nxp.s32ds.cle.runtime.migration.internal.core.sequence.model.SubsequenceAction;
import com.nxp.s32ds.cle.runtime.migration.property.MigrationProperties;
import com.nxp.s32ds.cle.runtime.migration.property.MigrationProperty;
import com.nxp.s32ds.cle.runtime.migration.sequence.MigrationSequenceDescriptor;
import java.util.function.Function;

public class EvaluationDiagnosticFactory {
    public static <R> R evaluate(MigrationDiagnostic diagnostic, Function<MigrationDiagnostic, R> function) {
        R result = function.apply(diagnostic);
        diagnostic.setValue(result);
        return result;
    }

    public static MigrationDiagnostic createConditionDiagnostic(MigrationDiagnostic parent, Condition condition) {
        MigrationConditionDescriptor descriptor = condition.getDescriptor();
        MigrationDiagnostic subDiagnostic = parent.subDiagnostic(MigrationDiagnosticElementType.CONDITION, descriptor.getId(), descriptor.getDocumentation().getName());
        EvaluationDiagnosticFactory.createPropertiesDiagnostic(subDiagnostic, condition.getProperties());
        return subDiagnostic;
    }

    public static MigrationDiagnostic createPropertiesDiagnostic(MigrationDiagnostic parent, MigrationProperties properties) {
        for (MigrationProperty property : properties.getProperties()) {
            EvaluationDiagnosticFactory.createPropertyDiagnostic(parent, property);
        }
        return parent;
    }

    public static MigrationDiagnostic createPropertyDiagnostic(MigrationDiagnostic parent, MigrationProperty property) {
        MigrationDiagnostic subDiagnostic = parent.subDiagnostic(MigrationDiagnosticElementType.PROPERTY, null, property.getName());
        subDiagnostic.setValue((Object)property.getValue());
        for (MigrationProperty subProperty : property.getProperties()) {
            EvaluationDiagnosticFactory.createPropertyDiagnostic(subDiagnostic, subProperty);
        }
        return subDiagnostic;
    }

    public static MigrationDiagnostic createSequenceDiagnostic(MigrationDiagnostic parent, MigrationSequenceImpl migrationSequenceImpl) {
        MigrationSequenceDescriptorElement descriptor = migrationSequenceImpl.getDescriptor();
        return parent.subDiagnostic(MigrationDiagnosticElementType.SEQUENCE, descriptor.getId(), descriptor.getName());
    }

    public static MigrationDiagnostic createRegularActionDiagnostic(MigrationDiagnostic parent, RegularAction action) {
        MigrationActionDescriptor descriptor = action.getDescriptor();
        MigrationDiagnostic subDiagnostic = parent.subDiagnostic(MigrationDiagnosticElementType.ACTION, descriptor.getId(), descriptor.getDocumentation().getName());
        EvaluationDiagnosticFactory.createPropertiesDiagnostic(subDiagnostic, action.getProperties());
        return subDiagnostic;
    }

    public static MigrationDiagnostic createSubsequenceActionDiagnostic(MigrationDiagnostic parent, SubsequenceAction action) {
        MigrationSequenceDescriptor descriptor = action.getDescriptor();
        return parent.subDiagnostic(MigrationDiagnosticElementType.SUB_SEQUENCE_ACTION, descriptor.getId(), descriptor.getName());
    }

    public static MigrationDiagnostic createBooleanVariableDiagnostic(MigrationDiagnostic parent, BooleanVariable variable) {
        return parent.subDiagnostic(MigrationDiagnosticElementType.BOOLEAN_VARIABLE, null, variable.getName());
    }

    public static MigrationDiagnostic createAndExpressionDiagnostic(MigrationDiagnostic parent) {
        return parent.subDiagnostic(MigrationDiagnosticElementType.AND_EXPRESSION, null, null);
    }

    public static MigrationDiagnostic createOrExpressionDiagnostic(MigrationDiagnostic parent) {
        return parent.subDiagnostic(MigrationDiagnosticElementType.OR_EXPRESSION, null, null);
    }

    public static MigrationDiagnostic createNotExpressionDiagnostic(MigrationDiagnostic parent) {
        return parent.subDiagnostic(MigrationDiagnosticElementType.NOT_EXPRESSION, null, null);
    }
}

