/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.runtime.migration.internal.core;

import com.nxp.s32ds.cle.runtime.migration.internal.core.Messages;
import com.nxp.s32ds.cle.runtime.migration.internal.core.MigrationConfigurationValidator;
import com.nxp.s32ds.cle.runtime.migration.internal.core.MigrationCoreActivator;
import java.util.Objects;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.osgi.util.NLS;

public abstract class MigrationConfigurationElement
implements MigrationConfigurationValidator {
    public static final String CLASS = "class";
    public static final String ID = "id";
    public static final String NAME = "name";
    public static final String DESCRIPTION = "description";
    protected final IConfigurationElement element;
    private final String id;

    public MigrationConfigurationElement(IConfigurationElement element, String ... requiredAttributes) {
        this.element = element;
        String[] stringArray = requiredAttributes;
        int n = requiredAttributes.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            String attribute = element.getAttribute(name);
            if (attribute == null) {
                MigrationCoreActivator.getInstance().log(element, NLS.bind((String)Messages.MigrationConfigurationElement_missed_required_0_attribute, (Object)name));
            }
            ++n2;
        }
        this.id = this.getIdAttribute();
    }

    public IConfigurationElement getElement() {
        return this.element;
    }

    public String getAttribute(String name) {
        return this.element.getAttribute(name);
    }

    public String getIdAttribute() {
        return this.getAttribute(ID);
    }

    public String getNameAttribute() {
        return this.getAttribute(NAME);
    }

    public String getDescriptionAttribute() {
        return this.getAttribute(DESCRIPTION);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " [id=" + this.getIdAttribute() + "]";
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MigrationConfigurationElement)) {
            return false;
        }
        MigrationConfigurationElement other = (MigrationConfigurationElement)obj;
        return Objects.equals(this.id, other.id);
    }
}

