/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.runtime.migration.internal.core.sequence.model;

import com.nxp.s32ds.cle.runtime.migration.action.MigrationActionDescriptor;
import com.nxp.s32ds.cle.runtime.migration.condition.MigrationConditionDescriptor;
import com.nxp.s32ds.cle.runtime.migration.core.MigrationRegistries;
import com.nxp.s32ds.cle.runtime.migration.core.MigrationsAssert;
import com.nxp.s32ds.cle.runtime.migration.internal.core.MigrationCoreActivator;
import com.nxp.s32ds.cle.runtime.migration.internal.core.sequence.model.BooleanVariable;
import com.nxp.s32ds.cle.runtime.migration.internal.core.sequence.model.Condition;
import com.nxp.s32ds.cle.runtime.migration.internal.core.sequence.model.PropertyVariable;
import com.nxp.s32ds.cle.runtime.migration.internal.core.sequence.model.RegularAction;
import com.nxp.s32ds.cle.runtime.migration.internal.core.sequence.model.Sequence;
import com.nxp.s32ds.cle.runtime.migration.internal.core.sequence.model.SequenceAction;
import com.nxp.s32ds.cle.runtime.migration.internal.core.sequence.model.SequenceBuilderException;
import com.nxp.s32ds.cle.runtime.migration.internal.core.sequence.model.SubsequenceAction;
import com.nxp.s32ds.cle.runtime.migration.internal.core.sequence.model.ast.BooleanExpression;
import com.nxp.s32ds.cle.runtime.migration.internal.core.sequence.model.ast.BooleanRecursiveDescentParser;
import com.nxp.s32ds.cle.runtime.migration.internal.core.sequence.model.reflection.MigrationReflectionSupport;
import com.nxp.s32ds.cle.runtime.migration.internal.core.sequence.xml.MigrationSource;
import com.nxp.s32ds.cle.runtime.migration.internal.core.sequence.xml.MigrationXmlParser;
import com.nxp.s32ds.cle.runtime.migration.internal.core.sequence.xml.MigrationXmlToStrings;
import com.nxp.s32ds.cle.runtime.migration.internal.core.sequence.xml.XmlAction;
import com.nxp.s32ds.cle.runtime.migration.internal.core.sequence.xml.XmlActions;
import com.nxp.s32ds.cle.runtime.migration.internal.core.sequence.xml.XmlAssert;
import com.nxp.s32ds.cle.runtime.migration.internal.core.sequence.xml.XmlCondition;
import com.nxp.s32ds.cle.runtime.migration.internal.core.sequence.xml.XmlConditionalExpression;
import com.nxp.s32ds.cle.runtime.migration.internal.core.sequence.xml.XmlProperties;
import com.nxp.s32ds.cle.runtime.migration.internal.core.sequence.xml.XmlProperty;
import com.nxp.s32ds.cle.runtime.migration.internal.core.sequence.xml.XmlSequence;
import com.nxp.s32ds.cle.runtime.migration.internal.core.sequence.xml.XmlSubsequence;
import com.nxp.s32ds.cle.runtime.migration.internal.core.sequence.xml.XmlVariables;
import com.nxp.s32ds.cle.runtime.migration.property.MigrationProperty;
import com.nxp.s32ds.cle.runtime.migration.sequence.MigrationSequenceDescriptor;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;

public class SequenceBuilder {
    private MigrationSource source;
    private Sequence sequence;
    private final ArrayDeque<Object> stack = new ArrayDeque();

    protected SequenceBuilder() {
    }

    public SequenceBuilder source(MigrationSource source) {
        this.source = source;
        return this;
    }

    public Sequence build() throws CoreException {
        XmlSequence xmlSequence = MigrationXmlParser.getInstance().parse(this.source);
        try {
            this.sequence = new Sequence(this.source);
            this.processVariables(xmlSequence.getVariables());
            this.sequence.setAssert(this.processAssert(xmlSequence.getAssert()));
            this.processActions(xmlSequence.getActions());
            return this.sequence;
        }
        catch (Exception e) {
            String message = e.getMessage();
            if (message == null) {
                message = e.toString();
            }
            throw new CoreException(MigrationCoreActivator.getInstance().createError(NLS.bind((String)"Cannot build model for sequence {0} caused by: {1}{2}", (Object[])new Object[]{this.source.getUID(), message, this.getTrace("")}), e));
        }
    }

    private void processActions(XmlActions actions) {
        this.wrap((Object)actions, () -> {
            List<Object> objects = actions.getActionOrSubsequence();
            for (Object object : objects) {
                if (object instanceof XmlAction) {
                    this.sequence.addAction(this.processAction((XmlAction)object));
                    continue;
                }
                if (object instanceof XmlSubsequence) {
                    this.sequence.addAction(this.processSubsequenceAction((XmlSubsequence)object));
                    continue;
                }
                throw new IllegalStateException("Unknown object type " + object.getClass().getName());
            }
        });
    }

    private RegularAction processAction(XmlAction xmlAction) {
        return this.wrap((Object)xmlAction, () -> {
            BooleanExpression assertExpression = null;
            XmlAssert xmlAssert = xmlAction.getAssert();
            if (xmlAssert != null) {
                assertExpression = this.processAssert(xmlAssert);
            }
            String sourceId = xmlAction.getSourceId();
            MigrationActionDescriptor descriptor = (MigrationActionDescriptor)MigrationRegistries.getActionDescriptorRegistry().getDescriptor(sourceId);
            if (descriptor == null) {
                throw new SequenceBuilderException(NLS.bind((String)"Invalid action declaration. Migration action with id ''{0}'' not found.", (Object)sourceId));
            }
            List<MigrationProperty> properties = this.processProperties(xmlAction.getProperties());
            try {
                MigrationReflectionSupport.initialize(descriptor.getActionClass(), descriptor.getDocumentation(), properties);
            }
            catch (MigrationReflectionSupport.MigrationReflectionException e) {
                throw new SequenceBuilderException(NLS.bind((String)"Invalid action declaration. {0}", (Object)e.getMessage()), e);
            }
            return new RegularAction(assertExpression, descriptor, properties);
        });
    }

    private SequenceAction processSubsequenceAction(XmlSubsequence xmlSubsequence) {
        return this.wrap((Object)xmlSubsequence, () -> {
            String sourceId = xmlSubsequence.getSourceId();
            MigrationSequenceDescriptor descriptor = (MigrationSequenceDescriptor)MigrationRegistries.getSequenceDescriptorRegistry().getDescriptor(sourceId);
            if (descriptor == null) {
                throw new SequenceBuilderException(NLS.bind((String)"Invalid subsequence declaration. Migration sequence with id ''{0}'' not found.", (Object)sourceId));
            }
            return new SubsequenceAction(descriptor);
        });
    }

    private BooleanExpression processAssert(XmlAssert xmlAssert) {
        return this.wrap((Object)xmlAssert, () -> {
            XmlCondition xmlCondition = xmlAssert.getCondition();
            if (xmlCondition != null) {
                return this.processCondition(xmlCondition, false);
            }
            XmlConditionalExpression xmlConditionalExpression = xmlAssert.getConditionalExpression();
            if (xmlConditionalExpression != null) {
                return this.processConditionalExpression(xmlConditionalExpression, false);
            }
            throw new SequenceBuilderException("Invalid assert declaration. Either condition,  or conditionalExpression are required.");
        });
    }

    private void processVariables(XmlVariables variables) {
        if (variables == null) {
            return;
        }
        this.wrap((Object)variables, () -> {
            HashSet<String> names = new HashSet<String>();
            List<Object> objects = variables.getPropertyOrConditionOrConditionalExpression();
            for (Object object : objects) {
                String name;
                if (object instanceof XmlProperty) {
                    name = this.createPropertyVariable((XmlProperty)object);
                } else if (object instanceof XmlCondition) {
                    name = this.createConditionVariable((XmlCondition)object);
                } else if (object instanceof XmlConditionalExpression) {
                    name = this.createConditionalExpressionVariable((XmlConditionalExpression)object);
                } else {
                    throw new IllegalStateException("Unknown object type " + object.getClass().getName());
                }
                if (names.contains(name)) {
                    throw new SequenceBuilderException(NLS.bind((String)"Duplicated variable name ''{0}''.", (Object)name));
                }
                names.add(name);
            }
        });
    }

    private String createConditionalExpressionVariable(XmlConditionalExpression xmlConditionalExpression) {
        String name = xmlConditionalExpression.getName();
        SequenceBuilder.assertVariableName(name);
        BooleanVariable variable = new BooleanVariable(name, this.processConditionalExpression(xmlConditionalExpression, true));
        this.sequence.getBooleanVariables().add(variable);
        return variable.getName();
    }

    private String createConditionVariable(XmlCondition xmlCondition) {
        String name = xmlCondition.getName();
        SequenceBuilder.assertVariableName(name);
        BooleanVariable variable = new BooleanVariable(name, this.processCondition(xmlCondition, true));
        this.sequence.getBooleanVariables().add(variable);
        return variable.getName();
    }

    private BooleanExpression processConditionalExpression(XmlConditionalExpression xmlConditionalExpression, boolean nameAllowed) {
        return this.wrap((Object)xmlConditionalExpression, () -> {
            if (!nameAllowed) {
                SequenceBuilder.assertConditionName(xmlConditionalExpression.getName());
            }
            BooleanRecursiveDescentParser parser = new BooleanRecursiveDescentParser(xmlConditionalExpression, o -> {
                if (o instanceof XmlCondition) {
                    return this.processCondition((XmlCondition)o, false);
                }
                return this.processConditionalExpression((XmlConditionalExpression)o, false);
            });
            return parser.build();
        });
    }

    private BooleanExpression processCondition(XmlCondition xmlCondition, boolean nameAllowed) {
        return this.wrap((Object)xmlCondition, () -> {
            if (!nameAllowed) {
                SequenceBuilder.assertConditionName(xmlCondition.getName());
            }
            String ref = xmlCondition.getRef();
            String sourceId = xmlCondition.getSourceId();
            if (!MigrationsAssert.isEmpty(ref) && !MigrationsAssert.isEmpty(sourceId)) {
                throw new SequenceBuilderException("Invalid condition declaration. Either source id, or reference are allowed.");
            }
            if (!MigrationsAssert.isEmpty(ref)) {
                return this.getReferencingExpression(xmlCondition);
            }
            if (MigrationsAssert.isEmpty(sourceId)) {
                throw new SequenceBuilderException("Invalid condition declaration. Either source id, or reference must be defined.");
            }
            MigrationConditionDescriptor descriptor = (MigrationConditionDescriptor)MigrationRegistries.getConditionDescriptorRegistry().getDescriptor(sourceId);
            if (descriptor == null) {
                throw new SequenceBuilderException(NLS.bind((String)"Invalid condition declaration. Migration condition with id ''{0}'' not found.", (Object)sourceId));
            }
            List<MigrationProperty> properties = this.processProperties(xmlCondition.getProperties());
            try {
                MigrationReflectionSupport.initialize(descriptor.getConditionClass(), descriptor.getDocumentation(), properties);
            }
            catch (MigrationReflectionSupport.MigrationReflectionException e) {
                throw new SequenceBuilderException(NLS.bind((String)"Invalid condition declaration. {0}", (Object)e.getMessage()), e);
            }
            Condition condition = new Condition(descriptor, properties);
            this.sequence.addCondition(condition);
            return condition;
        });
    }

    private BooleanExpression getReferencingExpression(XmlCondition xmlCondition) {
        if (!SequenceBuilder.isEmptyProperties(xmlCondition.getProperties())) {
            throw new SequenceBuilderException("Invalid referencing condition declaration. Properties not allowed.");
        }
        String ref = xmlCondition.getRef();
        BooleanVariable variable = this.sequence.getBooleanVariables().get(ref);
        if (variable == null) {
            throw new SequenceBuilderException(NLS.bind((String)"Invalid referencing condition declaration. Cannot find condition variable ''{0}''.", (Object)ref));
        }
        return variable;
    }

    private static boolean isEmptyProperties(XmlProperties properties) {
        return MigrationsAssert.isEmpty(Optional.ofNullable(properties).map(s -> s.getProperty()).orElse(Collections.emptyList()));
    }

    private static void assertConditionName(String name) {
        if (!MigrationsAssert.isEmpty(name)) {
            throw new SequenceBuilderException("Invalid condition or conditionalExpression declaration. Name not allowed.");
        }
    }

    private String createPropertyVariable(XmlProperty xmlProperty) {
        SequenceBuilder.assertVariableName(xmlProperty.getName());
        PropertyVariable variable = new PropertyVariable(this.processProperty(xmlProperty));
        this.sequence.getPropertyVariables().add(variable);
        return variable.getName();
    }

    private MigrationProperty processProperty(XmlProperty xmlProperty) {
        return this.wrap((Object)xmlProperty, () -> {
            SequenceBuilder.assertPropertyName(xmlProperty);
            String name = xmlProperty.getName();
            String value = xmlProperty.getValue();
            List<XmlProperty> xmlProperties = xmlProperty.getProperty();
            String ref = xmlProperty.getRef();
            if (MigrationsAssert.isEmpty(value) && MigrationsAssert.isEmpty(xmlProperties) && MigrationsAssert.isEmpty(ref)) {
                throw new SequenceBuilderException("Invalid property declaration. Either value, subproperties, or reference are required.");
            }
            if (!MigrationsAssert.isEmpty(ref)) {
                return this.createReferencingProperty(xmlProperty);
            }
            if (!MigrationsAssert.isEmpty(value) && !MigrationsAssert.isEmpty(xmlProperties)) {
                throw new SequenceBuilderException("Invalid property declaration. Either value, or subproperties are allowed.");
            }
            if (MigrationsAssert.isEmpty(xmlProperties)) {
                return new MigrationProperty(name, value);
            }
            return new MigrationProperty(name, this.createProperties(xmlProperties));
        });
    }

    private List<MigrationProperty> processProperties(XmlProperties xmlProperties) {
        if (xmlProperties == null) {
            return Collections.emptyList();
        }
        return this.wrap((Object)xmlProperties, () -> this.createProperties(xmlProperties.getProperty()));
    }

    private List<MigrationProperty> createProperties(List<XmlProperty> xmlProperties) {
        ArrayList<MigrationProperty> subProperties = new ArrayList<MigrationProperty>();
        for (XmlProperty subXmlProperty : xmlProperties) {
            subProperties.add(this.processProperty(subXmlProperty));
        }
        return subProperties;
    }

    private MigrationProperty createReferencingProperty(XmlProperty xmlProperty) {
        SequenceBuilder.assertPropertyName(xmlProperty);
        String name = xmlProperty.getName();
        String ref = xmlProperty.getRef();
        String value = xmlProperty.getValue();
        List<XmlProperty> properties = xmlProperty.getProperty();
        if (!MigrationsAssert.isEmpty(value)) {
            throw new SequenceBuilderException("Invalid referencing property declaration. Value is not allowed.");
        }
        if (!MigrationsAssert.isEmpty(properties)) {
            throw new SequenceBuilderException("Invalid referencing property declaration. Subproperties are not allowed.");
        }
        PropertyVariable variable = this.sequence.getPropertyVariables().get(ref);
        if (variable == null) {
            throw new SequenceBuilderException(NLS.bind((String)"Invalid referencing property declaration. Cannot find property variable ''{0}''.", (Object)ref));
        }
        MigrationProperty property = variable.getUnderlying();
        return new MigrationProperty(name, property.getValue(), property.getProperties());
    }

    private static void assertPropertyName(XmlProperty xmlProperty) {
        if (MigrationsAssert.isEmpty(xmlProperty.getName())) {
            throw new SequenceBuilderException("Invalid property declaration. Name is required.");
        }
    }

    private static void assertVariableName(String name) {
        if (MigrationsAssert.isEmpty(name)) {
            throw new SequenceBuilderException("Invalid variable declaration. Name is required.");
        }
    }

    private void wrap(Object o, Exec e) {
        this.stack.addLast(o);
        e.exec();
        this.stack.addLast(o);
    }

    private <T> T wrap(Object o, TExec<T> e) {
        this.stack.addLast(o);
        T r = e.exec();
        this.stack.removeLast();
        return r;
    }

    private String getTrace(String prefix) {
        int size = this.stack.size();
        if (size == 0) {
            return "";
        }
        Object object = this.stack.pop();
        return "\nat: " + prefix + MigrationXmlToStrings.getFromAnnotation(object) + this.getTrace(String.valueOf(prefix) + "    ");
    }

    @FunctionalInterface
    static interface Exec {
        public void exec();
    }

    @FunctionalInterface
    static interface TExec<T> {
        public T exec();
    }
}

