/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.runtime.migration.internal.core.sequence.model.reflection;

import com.nxp.s32ds.cle.runtime.migration.MigrationPostInitializationValidator;
import com.nxp.s32ds.cle.runtime.migration.annotation.MigrationEntityAnnotation;
import com.nxp.s32ds.cle.runtime.migration.annotation.MigrationPropertyAnnotation;
import com.nxp.s32ds.cle.runtime.migration.documentation.MigrationEntityDocumentation;
import com.nxp.s32ds.cle.runtime.migration.documentation.MigrationPropertyDocumentation;
import com.nxp.s32ds.cle.runtime.migration.internal.core.Messages;
import com.nxp.s32ds.cle.runtime.migration.internal.core.documentation.MigrationEntityDocumentationImpl;
import com.nxp.s32ds.cle.runtime.migration.internal.core.documentation.MigrationPropertyDocumentationImpl;
import com.nxp.s32ds.cle.runtime.migration.property.MigrationProperties;
import com.nxp.s32ds.cle.runtime.migration.property.MigrationProperty;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;

public class MigrationReflectionSupport {
    public static final Class<?>[] ALLOWED_PRIMITIVES = new Class[]{Integer.TYPE, Boolean.TYPE};
    public static final Class<?>[] ALLOWED_CLASSES = new Class[]{Integer.class, Boolean.class, String.class, MigrationProperty.class};
    public static final Class<?>[] ALLOWED_COLLECTIONS = new Class[]{List.class};

    public static <T> T initialize(Class<T> clazz, MigrationEntityDocumentation documentation, List<MigrationProperty> propertiesList) throws MigrationReflectionException {
        IStatus status;
        T object;
        try {
            Constructor<T> constructor;
            try {
                constructor = clazz.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException | SecurityException e) {
                throw new MigrationReflectionException(NLS.bind((String)Messages.MigrationReflectionSupport_cannot_get_public_default_constructor_for_class_0, (Object)clazz.getCanonicalName()), e);
            }
            object = constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            throw new MigrationReflectionException(NLS.bind((String)Messages.MigrationReflectionSupport_cannot_create_instance_of_class_0, (Object)clazz.getCanonicalName()), e);
        }
        List properties = documentation.getProperties();
        Set allowedNames = properties.stream().map(MigrationPropertyDocumentation::getName).collect(Collectors.toSet());
        propertiesList.stream().map(MigrationProperty::getName).filter(s -> !allowedNames.contains(s)).findFirst().ifPresent(s -> {
            throw new MigrationReflectionException(NLS.bind((String)Messages.MigrationReflectionSupport_unknown_property_0, (Object)s));
        });
        MigrationProperties migrationProperties = new MigrationProperties(propertiesList);
        for (MigrationPropertyDocumentation propertyDocumentation : properties) {
            MigrationReflectionSupport.initialize(object, propertyDocumentation, migrationProperties);
        }
        if (object instanceof MigrationPostInitializationValidator && !(status = ((MigrationPostInitializationValidator)object).validate()).isOK()) {
            throw new MigrationReflectionException(NLS.bind((String)Messages.MigrationReflectionSupport_initialization_error_0, (Object)status.getMessage()));
        }
        return object;
    }

    private static void initialize(Object instance, MigrationPropertyDocumentation propertyDocumentation, MigrationProperties migrationProperties) {
        int maxOccurs = propertyDocumentation.getMaxOccurs();
        int minOccurs = propertyDocumentation.getMinOccurs();
        String name = propertyDocumentation.getName();
        List definedProperties = migrationProperties.getProperties(name);
        if (definedProperties.size() < minOccurs) {
            throw new MigrationReflectionException(NLS.bind((String)Messages.MigrationReflectionSupport_the_property_0_must_be_declared_at_least_1_times, (Object)name, (Object)minOccurs));
        }
        if (maxOccurs != -1 && definedProperties.size() > maxOccurs) {
            throw new MigrationReflectionException(NLS.bind((String)Messages.MigrationReflectionSupport_the_property_0_must_be_declared_no_more_than_1_times, (Object)name, (Object)maxOccurs));
        }
        Object value = MigrationReflectionSupport.convert(propertyDocumentation, definedProperties);
        if (value == null) {
            return;
        }
        Field field = propertyDocumentation.getPropertyField();
        try {
            boolean accessible = field.canAccess(instance);
            try {
                if (!accessible) {
                    field.setAccessible(true);
                }
                field.set(instance, value);
            }
            finally {
                if (!accessible) {
                    field.setAccessible(false);
                }
            }
        }
        catch (Exception e) {
            throw new MigrationReflectionException(NLS.bind((String)Messages.MigrationReflectionSupport_cannot_initialize_0, (Object)field), e);
        }
    }

    private static Object convert(MigrationPropertyDocumentation propertyDocumentation, List<MigrationProperty> definedProperties) {
        if (definedProperties.size() == 0) {
            return null;
        }
        Class type = propertyDocumentation.getType();
        if (propertyDocumentation.getMaxOccurs() == 1) {
            return MigrationReflectionSupport.convert(propertyDocumentation.getName(), type, definedProperties.get(0));
        }
        Collection<Object> collection = MigrationReflectionSupport.createCollection(type);
        Class collectionType = propertyDocumentation.getCollectionType();
        for (MigrationProperty property : definedProperties) {
            collection.add(MigrationReflectionSupport.convert(propertyDocumentation.getName(), collectionType, property));
        }
        return collection;
    }

    private static Collection<Object> createCollection(Class<?> type) {
        if (List.class.equals(type)) {
            return new ArrayList<Object>();
        }
        throw new IllegalStateException("Unsupported collection type " + type.getCanonicalName());
    }

    private static Object convert(String name, Class<?> type, MigrationProperty property) {
        if (type.equals(MigrationProperty.class)) {
            return property;
        }
        String value = property.getValue();
        if (value == null) {
            throw new MigrationReflectionException(NLS.bind((String)"Value expected for the property ''{0}''.", (Object)name));
        }
        if (type.equals(String.class)) {
            return value;
        }
        if (type.equals(Integer.TYPE) || type.equals(Integer.class)) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                throw new MigrationReflectionException(NLS.bind((String)"Cannot parse integer value ''{0}'' for the property ''{1}''.", (Object)value, (Object)name));
            }
        }
        if (type.equals(Boolean.TYPE) || type.equals(Boolean.class)) {
            if (value.equalsIgnoreCase("true")) {
                return true;
            }
            if (value.equalsIgnoreCase("false")) {
                return false;
            }
            throw new MigrationReflectionException(NLS.bind((String)"Cannot parse boolean value ''{0}'' for the property ''{1}''.", (Object)value, (Object)name));
        }
        if (Enum.class.isAssignableFrom(type)) {
            try {
                return Enum.valueOf(type, value.toUpperCase());
            }
            catch (Exception e) {
                throw new MigrationReflectionException(NLS.bind((String)Messages.MigrationReflectionSupport_invalid_value_0_for_the_property_1_one_of_the_following_is_expected_2, (Object[])new Object[]{value, name, MigrationReflectionSupport.enumToString(type)}), e);
            }
        }
        throw new IllegalStateException("Unsupported property type " + type.getCanonicalName());
    }

    private static String enumToString(Class<Enum> type) {
        Stream stream = EnumSet.allOf(type).stream();
        return String.join((CharSequence)", ", stream.map(e -> String.valueOf(e).toLowerCase()).collect(Collectors.toList()));
    }

    public static MigrationEntityDocumentation getMigrationEntityDocumentation(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        MigrationEntityAnnotation annotation = clazz.getAnnotation(MigrationEntityAnnotation.class);
        if (annotation == null) {
            return null;
        }
        return new MigrationEntityDocumentationImpl(clazz, annotation);
    }

    public static List<MigrationPropertyDocumentation> getMigrationPropertyDocumentations(Class<?> clazz) {
        Field[] declaredFields;
        ArrayList<MigrationPropertyDocumentation> result = new ArrayList<MigrationPropertyDocumentation>();
        Field[] fieldArray = declaredFields = clazz.getDeclaredFields();
        int n = declaredFields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            MigrationPropertyAnnotation annotation = field.getAnnotation(MigrationPropertyAnnotation.class);
            if (annotation != null) {
                result.add(new MigrationPropertyDocumentationImpl(field, annotation));
            }
            ++n2;
        }
        Class<?> superclass = clazz.getSuperclass();
        if (superclass != null) {
            result.addAll(MigrationReflectionSupport.getMigrationPropertyDocumentations(superclass));
        }
        return result;
    }

    public static class MigrationReflectionException
    extends RuntimeException {
        public MigrationReflectionException(String message, Throwable cause) {
            super(message, cause);
        }

        public MigrationReflectionException(String message) {
            super(message);
        }
    }
}

