/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.runtime.migration.internal.core.sequence.xml;

import com.nxp.s32ds.cle.runtime.migration.internal.core.Messages;
import com.nxp.s32ds.cle.runtime.migration.internal.core.MigrationCoreActivator;
import com.nxp.s32ds.cle.runtime.migration.internal.core.sequence.xml.MigrationSource;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;

public class MigrationPathSource
implements MigrationSource {
    private final Path path;

    public MigrationPathSource(String path) throws CoreException {
        try {
            this.path = Paths.get(path, new String[0]);
        }
        catch (InvalidPathException e) {
            throw new CoreException(MigrationCoreActivator.getInstance().createError(NLS.bind((String)Messages.MigrationPathSource_invalid_path_0, (Object)path), e));
        }
    }

    public MigrationPathSource(Path path) {
        if (path == null) {
            throw new IllegalArgumentException();
        }
        this.path = path;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return Files.newInputStream(this.path, new OpenOption[0]);
    }

    @Override
    public String getUID() {
        return this.path.toString();
    }
}

