/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.asr.configurationClasses;

import com.nxp.swtools.asr.configurationClasses.ConfigTimeSupportXmlElement;
import com.nxp.swtools.asr.configurationClasses.DummyConfigTimeSupportXmlElement;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.expression.FormatOptions;
import com.nxp.swtools.common.utils.expression.IExpressionPrintable;
import com.nxp.swtools.common.utils.expression.IResolvable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.rational.BigRational;
import com.nxp.swtools.periphs.controller.Controller;
import com.nxp.swtools.resourcetables.model.config.ArrayConfig;
import com.nxp.swtools.resourcetables.model.config.IChild;
import com.nxp.swtools.resourcetables.model.config.IChildProvidable;
import com.nxp.swtools.resourcetables.model.config.IComponentInstanceConfig;
import com.nxp.swtools.resourcetables.model.config.IConfigSetConfig;
import com.nxp.swtools.resourcetables.model.config.StructConfig;
import com.nxp.swtools.resourcetables.model.data.ConfigurationComponentTypeId;
import com.nxp.swtools.resourcetables.settings.checker.ISettingsChecker;
import java.io.File;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConfigClassesChecker
implements ISettingsChecker {
    private static final Logger LOGGER = LogManager.getLogger(ConfigClassesChecker.class);
    private Map<IChild, List<String>> confClassErrors = new HashMap<IChild, List<String>>();
    private static final Map<String, String[]> ALLOWED_CONF_CLASSES = new HashMap<String, String[]>();
    private static ConfigTimeSupportXmlElement configClassesData = new DummyConfigTimeSupportXmlElement();

    static {
        ALLOWED_CONF_CLASSES.put("POST-BUILD", new String[]{"PRE-COMPILE", "LINK", "POST-BUILD"});
        ALLOWED_CONF_CLASSES.put("LINK", new String[]{"PRE-COMPILE", "LINK"});
        ALLOWED_CONF_CLASSES.put("PRE-COMPILE", new String[]{"PRE-COMPILE"});
    }

    public @Nullable List<String> getAdditionalSettingProblems(IChild setting) {
        List<String> result;
        if (ConfigClassesChecker.shouldPerformConfigClassCheck()) {
            this.confClassErrors.remove(setting);
            this.validateConfigClasses(setting);
        }
        return (result = this.confClassErrors.get(setting)) != null ? result : null;
    }

    private void validateConfigClasses(IChild childSetting) {
        IComponentInstanceConfig componentInstance;
        String dependentNodesOption = configClassesData.getDependentNodesOption();
        if (dependentNodesOption != null && (componentInstance = childSetting.getChildContext().getComponentInstanceConfig()) != null && !componentInstance.getComponent().isOptionAvailable(dependentNodesOption, childSetting.getExpressionContext())) {
            return;
        }
        Set<IChild> settingList = ConfigClassesChecker.collectDependentNodesOfChild(childSetting);
        if (settingList.isEmpty()) {
            return;
        }
        this.checkAndAddConfigClassesErrors(childSetting, settingList);
        if (ConfigClassesChecker.isArray(childSetting)) {
            for (IChild setting : ((ArrayConfig)childSetting).getChildren()) {
                this.validateConfigClasses(setting);
            }
        }
        if (ConfigClassesChecker.isStructure(childSetting)) {
            for (IChild setting : ((StructConfig)childSetting).getChildren()) {
                this.validateConfigClasses(setting);
            }
        }
    }

    private void addErrorForChild(IChild child, String message) {
        List<String> errorMessages = this.confClassErrors.get(child);
        if (errorMessages != null) {
            errorMessages.add(message);
        } else {
            errorMessages = new ArrayList<String>();
            errorMessages.add(message);
        }
        this.confClassErrors.put(child, errorMessages);
    }

    private static String getConfigClass(IChild setting) {
        String configClassOption = ConfigClassesChecker.getConfigClassOptionValue(setting);
        IConfigSetConfig settingConfigSet = setting.getChildContext().getConfigSetConfig();
        if (settingConfigSet != null) {
            String variantLocation = configClassesData.getVariantLocation();
            IChild selVar = null;
            if (variantLocation == null) {
                return "NOT_DEFINED";
            }
            selVar = settingConfigSet.getChildById(variantLocation);
            if (selVar != null) {
                Object selectedConfigVariant = selVar.getValue();
                String[] configClassOptionArray = configClassOption.split(";");
                int i = 0;
                while (i < configClassOptionArray.length) {
                    String[] variantClassArray = configClassOptionArray[i].split("=");
                    if (variantClassArray.length == 2 && selectedConfigVariant instanceof String && variantClassArray[1].equals(selectedConfigVariant)) {
                        return variantClassArray[0];
                    }
                    ++i;
                }
            }
        }
        return "NOT_DEFINED";
    }

    private static boolean isArray(IChild setting) {
        return "array".equals(setting.getTypeName());
    }

    private static boolean isStructure(IChild setting) {
        return "struct".equals(setting.getTypeName());
    }

    private static int getLowerMultiplicity(IChild array) {
        BigRational lowerMultiplicity;
        if (array instanceof ArrayConfig && (lowerMultiplicity = ((ArrayConfig)array).getModelData().getMinValue(array.getExpressionContext())) != null) {
            return lowerMultiplicity.intValue();
        }
        return Integer.MIN_VALUE;
    }

    private static boolean isUpperMultiplicityInfiniteSet(IChild array) {
        Object upperMultiplicityInfinite;
        if (array instanceof ArrayConfig && (upperMultiplicityInfinite = ((ArrayConfig)array).getOptionValue("upperMultiplicityInfinite")) instanceof Long) {
            return ((Long)upperMultiplicityInfinite).intValue() == 1;
        }
        return false;
    }

    private static int getUpperMultiplicity(IChild array) {
        BigRational upperMultiplicity;
        if (array instanceof ArrayConfig && (upperMultiplicity = ((ArrayConfig)array).getModelData().getMaxValue(array.getExpressionContext())) != null) {
            return upperMultiplicity.intValue();
        }
        return Integer.MAX_VALUE;
    }

    private static Set<IChild> collectDependentNodesOfChild(IChild child) {
        Object optionValue;
        HashSet<IChild> dependentNodes = new HashSet<IChild>();
        String dependentNodesOption = configClassesData.getDependentNodesOption();
        if (dependentNodesOption != null && (optionValue = child.getOptionValue(dependentNodesOption)) instanceof List) {
            List expressions = (List)optionValue;
            for (Object expression : expressions) {
                if (!(expression instanceof IResolvable)) continue;
                try {
                    Object result = ((IResolvable)expression).resolve(child.getExpressionContext()).getValue();
                    if (result instanceof List) {
                        List resultList = (List)result;
                        for (Object item : resultList) {
                            if (!(item instanceof IChild)) continue;
                            dependentNodes.add((IChild)item);
                        }
                        continue;
                    }
                    if (!(result instanceof IChild)) continue;
                    dependentNodes.add((IChild)result);
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, "[DATA] Error resolving Config Time Support expression: " + ((IResolvable)expression).formatOutput(FormatOptions.DEFAULT, (IExpressionPrintable)((IResolvable)expression)) + ", " + e.getMessage());
                }
            }
        }
        return dependentNodes;
    }

    private static boolean shouldPerformConfigClassCheck() {
        return !(configClassesData instanceof DummyConfigTimeSupportXmlElement);
    }

    public void loadAdditionalData() {
        ConfigurationComponentTypeId systemComponent = Controller.getInstance().getSystemComponent();
        if (systemComponent != null) {
            Path configClassesDir = systemComponent.getFileLocation();
            File configClassesFile = configClassesDir.resolve("configTimeSupport.xml").toFile();
            if (configClassesFile.exists()) {
                configClassesData = ConfigTimeSupportXmlElement.loadConfigClassesFromFile(configClassesFile);
            } else {
                LOGGER.log(Level.INFO, MessageFormat.format("The file {0} used for config class validation does not exist.", "configTimeSupport.xml"));
                configClassesData = new DummyConfigTimeSupportXmlElement();
            }
        }
    }

    private void checkAndAddConfigClassesErrors(IChild parentSetting, Set<IChild> settingList) {
        String[] settingAllowedClasses;
        String parentSettingConfigClass = ConfigClassesChecker.getConfigClass(parentSetting);
        if (!"NOT_DEFINED".equals(parentSettingConfigClass) && (settingAllowedClasses = ALLOWED_CONF_CLASSES.get(parentSettingConfigClass)) != null) {
            for (IChild setting : settingList) {
                String settingConfClass = ConfigClassesChecker.getConfigClass(setting);
                if ("NOT_DEFINED".equals(settingConfClass)) continue;
                this.validateConfigClasses(settingAllowedClasses, parentSetting, parentSettingConfigClass, settingConfClass, setting);
            }
        }
    }

    private void validateConfigClasses(String[] parentSettingAllowedClasses, IChild parentSetting, String parentSettingConfigClass, String settingConfClass, IChild setting) {
        boolean found = false;
        int j = 0;
        while (j < parentSettingAllowedClasses.length) {
            if (parentSettingAllowedClasses[j].equals(settingConfClass)) {
                found = true;
                break;
            }
            ++j;
        }
        if (!found) {
            String message = MessageFormat.format("{0} with config class {1} attempt to read value of node {2} with config class {3} which is not allowed in this context", parentSetting.getId(), parentSettingConfigClass, setting.getId(), settingConfClass);
            this.addErrorForChild(parentSetting, message);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getConfigClassOptionValue(IChild setting) {
        IChild nameChild;
        Object configClassOption = null;
        IChildProvidable parentSettingConfig = null;
        String arrayConfigurationClass = configClassesData.getConfigurationClassValueForSettingType("array");
        String otherSettingsConfigurationClass = configClassesData.getConfigurationClassValueForSettingType("other");
        if ("Name".equals(setting.getName())) {
            IChildProvidable firstParent = setting.getChildContext().getParent();
            if (firstParent != null) {
                parentSettingConfig = firstParent.getChildContext().getParent();
                if (parentSettingConfig == null || !ConfigClassesChecker.isArray((IChild)parentSettingConfig)) return "LINK";
                if (arrayConfigurationClass != null) {
                    configClassOption = parentSettingConfig.getOptionValue(arrayConfigurationClass);
                }
            }
        } else if (ConfigClassesChecker.isArray(setting)) {
            int lowerMultiplicity = ConfigClassesChecker.getLowerMultiplicity(setting);
            int upperMultiplicity = ConfigClassesChecker.getUpperMultiplicity(setting);
            if ((lowerMultiplicity != Integer.MIN_VALUE && upperMultiplicity != Integer.MAX_VALUE && lowerMultiplicity < upperMultiplicity || ConfigClassesChecker.isUpperMultiplicityInfiniteSet(setting)) && arrayConfigurationClass != null) {
                configClassOption = setting.getOptionValue(arrayConfigurationClass);
            }
        } else if (otherSettingsConfigurationClass != null && (configClassOption = setting.getOptionValue(otherSettingsConfigurationClass)) == null && (parentSettingConfig = setting.getChildContext().getParent()) != null) {
            configClassOption = parentSettingConfig.getOptionValue(otherSettingsConfigurationClass);
        }
        if (configClassOption == null && ConfigClassesChecker.isStructure(setting) && setting instanceof StructConfig && (nameChild = ((StructConfig)setting).getChildById("Name")) != null && (parentSettingConfig = setting.getChildContext().getParent()) != null && ConfigClassesChecker.isArray((IChild)parentSettingConfig) && arrayConfigurationClass != null) {
            configClassOption = parentSettingConfig.getOptionValue(arrayConfigurationClass);
        }
        if (configClassOption != null && !configClassOption.toString().isEmpty()) return configClassOption.toString();
        LOGGER.log(Level.SEVERE, MessageFormat.format("Could not deduce {0} or {1} for setting: {2}", otherSettingsConfigurationClass, arrayConfigurationClass, setting.getId()));
        return "NOT_DEFINED";
    }
}

