/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.asr.epc.model;

import com.nxp.swtools.asr.convertor.AsrImporterHelper;
import com.nxp.swtools.asr.epc.model.ArPackageNode;
import com.nxp.swtools.asr.epc.model.EcucContainerValue;
import com.nxp.swtools.asr.epc.model.EcucNumericalParamValue;
import com.nxp.swtools.asr.epc.model.EcucTextualParamValue;
import com.nxp.swtools.asr.epc.model.ModuleConfigNode;
import com.nxp.swtools.asr.epc.model.ParameterValues;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.files.UtilsDecryption;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Namespace;
import org.simpleframework.xml.NamespaceList;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.core.Commit;
import org.simpleframework.xml.core.Persister;

@Root(name="AUTOSAR", strict=true)
@NamespaceList(value={@Namespace(reference="http://autosar.org/schema/r4.0"), @Namespace(reference="http://www.w3.org/2001/XMLSchema-instance", prefix="xsi")})
public class EpcConfig {
    private static final Logger LOGGER = LogManager.getLogger(EpcConfig.class);
    private boolean hasVariants = false;
    @Attribute(name="schemaLocation", required=false)
    @Namespace(prefix="xsi", reference="http://www.w3.org/2001/XMLSchema-instance")
    private String schemaLocation;
    @ElementList(name="AR-PACKAGES", entry="AR-PACKAGE", required=true)
    private List<ArPackageNode> packages;

    protected EpcConfig() {
        this("http://autosar.org/schema/r4.0 AUTOSAR_00046.xsd", new ArrayList<ArPackageNode>());
    }

    public EpcConfig(String schemaLocation, List<ArPackageNode> packages) {
        this.schemaLocation = schemaLocation;
        this.packages = packages;
    }

    public List<ArPackageNode> getPackages() {
        return this.packages;
    }

    public void setPackages(List<ArPackageNode> packages) {
        this.packages = packages;
    }

    public String getSchemaLocation() {
        String[] locPair = this.schemaLocation.split(" ");
        if (locPair.length != 2) {
            if (SWToolsProperties.isVerificationOn()) {
                LOGGER.severe("Imported EPC file specifies an invalid schema location " + this.schemaLocation);
            }
            return "";
        }
        String loc = String.valueOf(locPair[0]) + UtilsText.ECLIPSE_PATH_SEPARATOR + locPair[1];
        return loc;
    }

    public static @Nullable EpcConfig loadEpcFile(File source) {
        block14: {
            try {
                Throwable throwable = null;
                Object var2_5 = null;
                try (InputStream is = UtilsDecryption.getFileInputStream((File)source);){
                    Persister persisterInst = new Persister();
                    EpcConfig epcContainer = (EpcConfig)persisterInst.read(EpcConfig.class, is);
                    return epcContainer;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause != null) {
                    LOGGER.log(Level.SEVERE, MessageFormat.format("Error loading EPC file {0} caused by exception: {1}", source.getAbsolutePath(), cause.getLocalizedMessage()));
                } else {
                    LOGGER.log(Level.SEVERE, "Error loading EPC file " + source.getAbsolutePath(), e);
                }
            }
            catch (Exception e) {
                boolean isFileBmwmdModule = AsrImporterHelper.getInstance().isFileBswmdModule(source.getAbsolutePath());
                if (isFileBmwmdModule) break block14;
                LOGGER.log(Level.SEVERE, "Error loading EPC file " + source.getAbsolutePath(), e);
            }
        }
        return null;
    }

    @Commit
    private void commit() {
        this.hasVariants = this.checkVariantsInArPackages(this.packages);
    }

    private boolean checkVariantsInArPackages(List<ArPackageNode> packageNodes) {
        for (ArPackageNode arPackage : packageNodes) {
            if (arPackage.getVariationPoint() != null || !arPackage.getElements().getPredefinedVariants().isEmpty()) {
                return true;
            }
            if (!arPackage.getArPackages().isEmpty()) {
                if (!this.checkVariantsInArPackages(arPackage.getArPackages())) continue;
                return true;
            }
            List<ModuleConfigNode> moduleNodes = arPackage.getElements().getModuleConfigs();
            for (ModuleConfigNode moduleConfigNode : moduleNodes) {
                for (EcucContainerValue containerVal : moduleConfigNode.getContainers()) {
                    if (containerVal.getVariationPoint() == null && !this.checkVariantsInEcucContainer(containerVal)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean checkVariantsInEcucContainer(EcucContainerValue ecucContainer) {
        ParameterValues paramVals = ecucContainer.getParameterValues();
        if (paramVals != null) {
            for (EcucTextualParamValue textualParam : paramVals.getEcucTextualParamVals()) {
                if (textualParam.getVariationPoint() == null) continue;
                return true;
            }
            for (EcucNumericalParamValue numericalParamValue : paramVals.getEcucNumericalParamVals()) {
                if (numericalParamValue.getVariationPoint() == null) continue;
                return true;
            }
        }
        for (EcucContainerValue containerChild : ecucContainer.getSubContainers()) {
            if (containerChild.getVariationPoint() == null && !this.checkVariantsInEcucContainer(containerChild)) continue;
            return true;
        }
        return false;
    }

    public boolean hasVariants() {
        return this.hasVariants;
    }

    public int hashCode() {
        return Objects.hash(this.hasVariants, this.packages, this.schemaLocation);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EpcConfig other = (EpcConfig)obj;
        return this.hasVariants == other.hasVariants && Objects.equals(this.packages, other.packages) && Objects.equals(this.schemaLocation, other.schemaLocation);
    }
}

