/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.dashboard.ui;

import com.nxp.swtools.common.ui.utils.command.CommandUtils;
import com.nxp.swtools.common.ui.utils.dialogs.ShellProvider;
import com.nxp.swtools.common.ui.utils.swt.SWTFactoryProxy;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.configuration.SwToolsProductConfiguration;
import com.nxp.swtools.dashboard.Messages;
import com.nxp.swtools.dashboard.internal.DashboardControlsProvider;
import com.nxp.swtools.dashboard.internal.DashboardUiUtils;
import com.nxp.swtools.provider.configuration.IConfigChangeContext;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.ISharedConfigurationListener;
import com.nxp.swtools.provider.configuration.SharedConfigurationAdapter;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import com.nxp.swtools.utils.command.handlers.UpdateCodeBlocker;
import com.nxp.swtools.utils.resources.ToolsImages;
import com.nxp.swtools.utils.tools.ITool;
import com.nxp.swtools.utils.tools.Tools;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class DashboardDialog
extends Dialog {
    private static final int EXTRA_DECORATOR_SPACE = 3;
    private static final int MINIMUM_WINDOW_WIDTH = 400;
    private static boolean shouldSelectPerspective;
    @Nullable
    private static DashboardDialog dialogOpened;
    @NonNull
    private DashboardControlsProvider contentProvider;
    @Nullable
    private ControlDecoration closeButtonDecorator;
    @Nullable
    private ControlDecoration udpateCodeButtonDecorator;

    public DashboardDialog(@NonNull Shell parent, @Nullable String header) {
        super(parent);
        this.contentProvider = new DashboardControlsProvider(() -> ((DashboardDialog)this).okPressed(), header, shouldSelectPerspective);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.get().Dashboard_DialogTitle);
        newShell.setMinimumSize(400, newShell.getMinimumSize().y);
        SWTFactoryProxy.INSTANCE.setTestId((Widget)newShell, "com.nxp.swtools.dashboard.DashboardDialog");
    }

    protected Control createDialogArea(Composite parent) {
        assert (parent != null);
        return this.contentProvider.createDashboardControls(parent);
    }

    private static void updateDecorator(@Nullable ControlDecoration decorator, @Nullable String blockingIssueMsg) {
        if (decorator == null || decorator.getControl() == null || decorator.getControl().isDisposed()) {
            return;
        }
        if (blockingIssueMsg == null) {
            decorator.hide();
        } else {
            decorator.setImage(ToolsImages.getStatusDecoratorImg((int)2));
            decorator.setDescriptionText(blockingIssueMsg);
            decorator.show();
        }
    }

    protected void updateCloseButtons() {
        String msg = DashboardUiUtils.getDisabledProductErrorMessage();
        DashboardDialog.updateDecorator(this.closeButtonDecorator, msg);
        ControlDecoration locUdpateCodeButtonDecorator = this.udpateCodeButtonDecorator;
        if (locUdpateCodeButtonDecorator != null) {
            UpdateCodeBlocker updBlocker = UpdateCodeBlocker.getReasonBlockingUpdateProjectCode((ISharedConfiguration)SharedConfigurationFactory.getSharedConfigurationSingleton());
            locUdpateCodeButtonDecorator.getControl().setEnabled(updBlocker == null);
            if (updBlocker != null) {
                msg = updBlocker.getDescription();
            }
            DashboardDialog.updateDecorator(locUdpateCodeButtonDecorator, msg);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected void createButtonsForButtonBar(Composite parent) {
        parent.setBackground(this.contentProvider.backgroundColor);
        Layout parLayout = parent.getLayout();
        if (parLayout instanceof GridLayout) {
            int decoratorWidth = 3 + ToolsImages.getStatusDecoratorImg((int)2).getBounds().width;
            ((GridLayout)parLayout).horizontalSpacing = Integer.max(((GridLayout)parLayout).horizontalSpacing, decoratorWidth);
            ((GridLayout)parLayout).makeColumnsEqualWidth = false;
            ((GridLayout)parLayout).numColumns = 3;
            Object gData = parent.getLayoutData();
            if (gData instanceof GridData) {
                ((GridData)gData).grabExcessHorizontalSpace = true;
                ((GridData)gData).horizontalAlignment = 4;
            }
        }
        Label unsupportedToolsLabel = new Label(parent, 0);
        unsupportedToolsLabel.setBackground(this.contentProvider.backgroundColor);
        unsupportedToolsLabel.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).align(16384, 0x1000000).create());
        @NonNull @NonNull List tools = Tools.getToolsSorted();
        tools.removeIf(t -> this.contentProvider.isToolDisplayed((ITool)t, null));
        if (!tools.isEmpty()) {
            String unsupportedProductsStr = CollectionsUtils.formatList((Collection)tools, (String)", ", t -> Objects.requireNonNull(SwToolsProductConfiguration.getRegisteredProduct((String)t.getToolId())).getProductName());
            unsupportedToolsLabel.setText(String.format(Messages.get().Dashboard_UnsupportedToolsLbl, unsupportedProductsStr));
        }
        Button updateCodeButton = this.createButton(parent, 0, Messages.get().Dashboard_ButtonCloseAndUpdateCode, false);
        assert (updateCodeButton != null);
        this.udpateCodeButtonDecorator = new ControlDecoration((Control)updateCodeButton, 16512);
        DashboardUiUtils.assignActionToWidget((Widget)updateCodeButton, this.contentProvider.endModalAndRun(() -> {
            boolean bl = CommandUtils.executeCommand((String)"com.nxp.swtools.framework.openProjectUpdateDialogCmd");
        }));
        Button closeButton = this.createButton(parent, 1, IDialogConstants.CLOSE_LABEL, false);
        this.closeButtonDecorator = new ControlDecoration((Control)closeButton, 16512);
        this.updateCloseButtons();
    }

    public static void createAndOpen(@Nullable Shell shell, @Nullable String header, boolean shouldSelPerspective) {
        if (dialogOpened != null) {
            return;
        }
        ISharedConfiguration sharedConfig = SharedConfigurationFactory.getSharedConfigurationSingleton();
        SharedConfigurationAdapter listener = null;
        try {
            DashboardDialog dlg;
            shouldSelectPerspective = shouldSelPerspective;
            dialogOpened = dlg = new DashboardDialog(shell != null ? shell : ShellProvider.getAnyShellParent(), header);
            listener = new SharedConfigurationAdapter(){

                public void configurationChanged(ISharedConfiguration sharedConfiguration, IConfigChangeContext changeContext) {
                    if (IConfigChangeContext.ConfigChangeType.TOOL_TOGGLE.equals((Object)changeContext.getChangeType())) {
                        dlg.updateCloseButtons();
                    }
                }
            };
            sharedConfig.addListener((ISharedConfigurationListener)listener);
            dlg.open();
        }
        catch (Throwable throwable) {
            dialogOpened = null;
            if (listener != null) {
                sharedConfig.removeListener(listener);
            }
            throw throwable;
        }
        dialogOpened = null;
        if (listener != null) {
            sharedConfig.removeListener((ISharedConfigurationListener)listener);
        }
    }

    public static @Nullable DashboardDialog getDashboardDialogForTest() {
        return dialogOpened;
    }

    protected boolean isResizable() {
        return true;
    }

    public boolean isUpdated() {
        return !this.contentProvider.getDelayedUiRefresher().isExecRequested();
    }
}

