/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cdt.svd.internal.ui.view.action;

import com.nxp.s32ds.cdt.svd.internal.ui.CdtSvdUiActivator;
import com.nxp.s32ds.cdt.svd.internal.ui.Messages;
import com.nxp.s32ds.cdt.svd.internal.ui.view.SvdTreeViewerBase;
import com.nxp.s32ds.cdt.svd.internal.ui.view.action.SvdActionBase;
import com.nxp.s32ds.cdt.svd.internal.ui.view.watch.SvdUiWatchModelCacheManager;
import com.nxp.s32ds.cdt.svd.model.SvdChildElement;
import com.nxp.s32ds.cdt.svd.model.SvdContainer;
import com.nxp.s32ds.cdt.svd.model.SvdRegister;
import com.nxp.s32ds.cdt.svd.model.watch.SvdWatchModel;
import com.nxp.s32ds.ext.cdt.dsf.DsfSessionInactiveException;
import java.util.Optional;
import java.util.Set;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.PlatformUI;

public class SvdWatchAction
extends SvdActionBase<SvdTreeViewerBase> {
    public SvdWatchAction(SvdTreeViewerBase viewer) {
        super(viewer);
        this.setText(Messages.SvdWatchAction_watch);
        this.setImageDescriptor(CdtSvdUiActivator.getInstance().getImageDescriptor("icon_watch"));
        this.setId(String.valueOf(CdtSvdUiActivator.getInstance().getBundleId()) + ".SvdWatchAction");
    }

    public void run() {
        this.update();
        if (!this.isEnabled()) {
            return;
        }
        Optional<DsfSession> opt = this.viewer.getDsfSession();
        if (!opt.isPresent()) {
            return;
        }
        DsfSession dsfSession = opt.get();
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        Set<SvdRegister> registers = SvdWatchAction.getRegisters(selection);
        if (registers.isEmpty()) {
            return;
        }
        SvdRegister register = registers.iterator().next();
        SvdUiWatchModelCacheManager.getInstance().addToWatch(PlatformUI.getWorkbench().getActiveWorkbenchWindow(), dsfSession, registers);
        try {
            SvdWatchModel memoryModel = SvdUiWatchModelCacheManager.getInstance().computeIfAbsent(dsfSession, (SvdContainer)register);
            SvdChildElement element = memoryModel.getByPath(register.getPath());
            this.viewer.expandAndSelect(element);
        }
        catch (DsfSessionInactiveException dsfSessionInactiveException) {}
    }

    @Override
    public void update() {
        super.update();
        if (!this.isEnabled()) {
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.isEmpty()) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
    }
}

