/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cdt.svd.internal.ui.view.provider;

import com.nxp.s32ds.cdt.svd.internal.ui.Messages;
import com.nxp.s32ds.cdt.svd.internal.ui.view.provider.SvdColumnLabelCompositeProvider;
import com.nxp.s32ds.cdt.svd.internal.ui.view.provider.SvdColumnLabelPeripheralsProviders;
import com.nxp.s32ds.cdt.svd.internal.ui.view.provider.SvdColumnLabelProviders;
import com.nxp.s32ds.cdt.svd.model.SvdRegister;
import com.nxp.s32ds.cdt.svd.utils.SvdRegisters;
import java.util.Optional;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.osgi.util.NLS;

public class SvdNameAddressDescriptionLabelProvider
extends SvdColumnLabelCompositeProvider {
    private static final String EMPTY = "";
    private static final ILabelProvider DESCRIPTION_LABEL_PROVIDER = new SvdColumnLabelProviders.DescriptionLabelProvider();
    private static final ILabelProvider ADDRESS_LABEL_PROVIDER = new SvdColumnLabelProviders.AddressLabelProvider();
    private final boolean showFullPath;

    public SvdNameAddressDescriptionLabelProvider(boolean showFullPath) {
        super(SvdColumnLabelPeripheralsProviders.getProviders());
        this.showFullPath = showFullPath;
    }

    @Override
    public void update(ViewerCell cell) {
        Object element = cell.getElement();
        cell.setText(this.getText(element));
        cell.setImage(this.getImage(element));
    }

    @Override
    public String getText(Object element) {
        String address;
        String description;
        if (element == null) {
            return EMPTY;
        }
        String name = super.getText(element);
        if (element instanceof SvdRegister && this.showFullPath) {
            name = SvdRegisters.getPathToPeripheral((SvdRegister)((SvdRegister)element));
        }
        if (!(description = Optional.ofNullable(DESCRIPTION_LABEL_PROVIDER.getText(element)).orElse(EMPTY)).isEmpty()) {
            description = NLS.bind((String)Messages.SvdNameAddressDescriptionLabelProvider_description, (Object)description);
        }
        if (!(address = Optional.ofNullable(ADDRESS_LABEL_PROVIDER.getText(element)).orElse(EMPTY)).isEmpty()) {
            address = NLS.bind((String)Messages.SvdNameAddressDescriptionLabelProvider_address, (Object)address);
        }
        return NLS.bind((String)Messages.SvdNameAddressDescriptionLabelProvider_name0addres1description2, (Object[])new Object[]{name, address, description});
    }
}

