/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cdt.svd.internal.ui.view.watch;

import com.nxp.s32ds.cdt.svd.internal.ui.CdtSvdUiActivator;
import com.nxp.s32ds.cdt.svd.internal.ui.view.memento.SvdWatchModelMemento;
import com.nxp.s32ds.cdt.svd.internal.ui.view.watch.SvdMementoWatchLoader;
import com.nxp.s32ds.cdt.svd.model.SvdRegister;
import com.nxp.s32ds.cdt.svd.model.watch.SvdWatchModel;
import com.nxp.s32ds.cdt.svd.model.watch.SvdWatchModelCacheManager;
import com.nxp.s32ds.cdt.svd.model.watch.SvdWatchModelChangeEvent;
import com.nxp.s32ds.cdt.svd.model.watch.SvdWatchModelChangeListener;
import com.nxp.s32ds.cdt.svd.model.watch.SvdWatchModelLoader;
import java.util.Collection;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;

public class SvdUiWatchModelCacheManager
extends SvdWatchModelCacheManager
implements SvdWatchModelChangeListener {
    private static final SvdUiWatchModelCacheManager INSTANCE = new SvdUiWatchModelCacheManager();

    private SvdUiWatchModelCacheManager() {
        super((SvdWatchModelLoader)SvdMementoWatchLoader.getInstance());
        this.addListener(this);
    }

    public static SvdUiWatchModelCacheManager getInstance() {
        return INSTANCE;
    }

    public void addToWatch(IWorkbenchWindow workbenchWindow, DsfSession session, Collection<SvdRegister> registers) {
        this.addToWatch(session, registers);
        SvdUiWatchModelCacheManager.showPeripheralRegistersValuesView(workbenchWindow);
    }

    private static void showPeripheralRegistersValuesView(IWorkbenchWindow workbenchWindow) {
        Display.getDefault().asyncExec(() -> {
            try {
                workbenchWindow.getActivePage().showView("com.nxp.s32ds.cdt.svd.ui.SvdPeripheralRegistersWatchView");
            }
            catch (PartInitException e) {
                CdtSvdUiActivator.getInstance().log(e.getStatus());
            }
        });
    }

    public void modelChanged(SvdWatchModelChangeEvent event) {
        SvdWatchModel model = event.getModel();
        new SvdWatchModelMemento(model.getUID()).saveToMemento(SvdUiWatchModelCacheManager.collectModelState((SvdWatchModel)model));
    }
}

