/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cdt.svd.internal.ui.view.watch.edit;

import com.nxp.s32ds.cdt.svd.internal.ui.view.SvdTreeViewer;
import com.nxp.s32ds.cdt.svd.internal.ui.view.SvdTreeViewerInputs;
import com.nxp.s32ds.cdt.svd.internal.ui.view.watch.edit.SvdHexComboBoxCellEditor;
import com.nxp.s32ds.cdt.svd.internal.ui.view.watch.edit.SvdHexEditingSupportBase;
import com.nxp.s32ds.cdt.svd.internal.ui.view.watch.edit.SvdHexTextCellEditor;
import com.nxp.s32ds.cdt.svd.internal.ui.view.watch.edit.SvdHexTextCellEditorValidator;
import com.nxp.s32ds.cdt.svd.model.SvdEnumeratedValue;
import com.nxp.s32ds.cdt.svd.model.SvdField;
import com.nxp.s32ds.cdt.svd.model.SvdRegister;
import com.nxp.s32ds.cdt.svd.parser.model.EnumeratedValueDataType;
import com.nxp.s32ds.cdt.svd.utils.SvdFields;
import com.nxp.s32ds.cdt.svd.utils.SvdNumberToStrings;
import java.math.BigInteger;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.widgets.Composite;

public class SvdHexColumnFieldEditingSupport
extends SvdHexEditingSupportBase<SvdField> {
    private final SvdHexComboBoxCellEditor comboCellEditor;

    public SvdHexColumnFieldEditingSupport(SvdTreeViewer viewer) {
        super(viewer);
        this.comboCellEditor = new SvdHexComboBoxCellEditor((Composite)viewer.getControl());
    }

    @Override
    protected Object getValue(SvdField field) {
        Optional<BigInteger> registerValue = Optional.ofNullable(SvdTreeViewerInputs.getValue(this.getViewer(), field));
        Optional<BigInteger> value = registerValue.map(v -> SvdFields.getFieldValue((SvdField)field, (BigInteger)v));
        List values = field.getEnumeratedValuesForWrite();
        if (values.size() > 0) {
            if (!value.isPresent()) {
                return null;
            }
            List matchedValues = SvdFields.matchEnumeratedValues((SvdField)field, (List)values, (BigInteger)value.get());
            if (matchedValues.size() == 1) {
                return matchedValues.get(0);
            }
            return "";
        }
        if (!value.isPresent()) {
            return "";
        }
        return SvdNumberToStrings.toHexString((BigInteger)value.get(), (int)field.getBitLength());
    }

    @Override
    protected void setValue(SvdField field, Object objValue) {
        if (objValue == null) {
            return;
        }
        if (objValue instanceof SvdEnumeratedValue) {
            this.setValue(field, (BigInteger bi) -> SvdFields.applyFieldEnumeratedValue((SvdField)field, (BigInteger)bi, (EnumeratedValueDataType)((SvdEnumeratedValue)objValue).getValue()));
            return;
        }
        BigInteger longValue = SvdHexColumnFieldEditingSupport.getHexStringValue(objValue, field.getBitLength());
        if (longValue != null) {
            this.setValue(field, (BigInteger bi) -> SvdFields.applyFieldValue((SvdField)field, (BigInteger)bi, (BigInteger)longValue));
        }
    }

    private void setValue(SvdField field, Function<BigInteger, BigInteger> applyFieldValueFunction) {
        SvdRegister register = field.getParent();
        BigInteger registerValueBI = Optional.ofNullable(SvdTreeViewerInputs.getValue(this.getViewer(), register)).orElse(BigInteger.ZERO);
        SvdTreeViewerInputs.setValue(this.getViewer(), register, applyFieldValueFunction.apply(registerValueBI));
    }

    @Override
    protected CellEditor getCellEditor(SvdField field) {
        if (field.getEnumeratedValuesForWrite().size() > 0) {
            this.comboCellEditor.setInput(field.getEnumeratedValuesForWrite());
            return this.comboCellEditor;
        }
        SvdHexTextCellEditorValidator validator = new SvdHexTextCellEditorValidator(field.getBitLength());
        return new SvdHexTextCellEditor((Composite)this.getViewer().getControl(), validator);
    }
}

