/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cdt.svd.internal.ui.view.wizard;

import com.nxp.s32ds.cdt.svd.interchange.registers.SvdRegistersInterchange;
import com.nxp.s32ds.cdt.svd.internal.ui.CdtSvdUiActivator;
import com.nxp.s32ds.cdt.svd.internal.ui.Messages;
import com.nxp.s32ds.cdt.svd.internal.ui.view.SvdTreeViewer;
import com.nxp.s32ds.cdt.svd.internal.ui.view.SvdTreeViewerInputs;
import com.nxp.s32ds.cdt.svd.internal.ui.view.wizard.SvdExportRegistersWizardPage;
import com.nxp.s32ds.cdt.svd.internal.ui.view.wizard.SvdImportExport;
import com.nxp.s32ds.cdt.svd.model.SvdRegister;
import com.nxp.s32ds.cdt.svd.utils.SvdNumberToStrings;
import com.nxp.s32ds.cdt.svd.utils.SvdRegisters;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;

public class SvdExportRegistersWizard
extends Wizard
implements IExportWizard {
    private static final String REGISTERS_EXTENSION = "." + SvdImportExport.EXTENSIONS[0];
    private SvdExportRegistersWizardPage page;
    private IStructuredSelection selection;
    private final SvdTreeViewer inputViewer;

    public SvdExportRegistersWizard(SvdTreeViewer viewer) {
        this.inputViewer = viewer;
        this.setDialogSettings(CdtSvdUiActivator.getInstance().getDialogSettingsSection(((Object)((Object)this)).getClass()));
        this.setWindowTitle(Messages.SvdExportRegistersWizard_export_registers);
    }

    public void addPages() {
        super.addPages();
        this.page = new SvdExportRegistersWizardPage(this.inputViewer, this.selection);
        this.addPage((IWizardPage)this.page);
    }

    public void dispose() {
        super.dispose();
        this.page = null;
    }

    public boolean performFinish() {
        this.page.appendToFilePath(REGISTERS_EXTENSION);
        if (!this.page.finish()) {
            return false;
        }
        try {
            this.export(this.page.getFilePath(), this.page.getCheckedElements());
        }
        catch (CoreException e) {
            IStatus status = e.getStatus();
            CdtSvdUiActivator.getInstance().log(status);
            ErrorDialog.openError((Shell)this.getShell(), null, null, (IStatus)status);
            return false;
        }
        return true;
    }

    private void export(Path path, Object[] elements) throws CoreException {
        List registers = Arrays.stream(elements).filter(e -> e instanceof SvdRegister).map(e -> (SvdRegister)e).collect(Collectors.toList());
        SvdRegisters.sortByPathToPeripheral(registers);
        List registersList = SvdRegistersInterchange.convert(registers, r -> this.getValue((SvdRegister)r));
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
                SvdRegistersInterchange.marshal((List)registersList, (Writer)writer);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e2) {
            throw new CoreException(CdtSvdUiActivator.getInstance().createError(NLS.bind((String)Messages.SvdRegistersValuesExportAction_error_during_export_registers_0, (Object)e2.toString()), e2));
        }
    }

    private String getValue(SvdRegister register) {
        BigInteger value = SvdTreeViewerInputs.getValue(this.inputViewer, register);
        if (value == null) {
            return null;
        }
        return SvdNumberToStrings.toHexString((BigInteger)value, (int)register.getBitLength());
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
        this.setWindowTitle(Messages.SvdExportRegistersWizard_export_registers);
        this.setNeedsProgressMonitor(false);
    }
}

