/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cdt.svd.internal.ui.view.wizard;

import com.nxp.s32ds.cdt.svd.dsf.SvdDsfSessionCacheListener;
import com.nxp.s32ds.cdt.svd.dsf.SvdDsfSessionCacheManager;
import com.nxp.s32ds.cdt.svd.internal.ui.Messages;
import com.nxp.s32ds.cdt.svd.internal.ui.view.SvdTreeViewer;
import com.nxp.s32ds.cdt.svd.internal.ui.view.SvdTreeViewerInput;
import com.nxp.s32ds.cdt.svd.internal.ui.view.SvdTreeViewerInputs;
import com.nxp.s32ds.cdt.svd.internal.ui.view.provider.SvdContentRegisterProvider;
import com.nxp.s32ds.cdt.svd.internal.ui.view.provider.SvdNameAddressDescriptionLabelProvider;
import com.nxp.s32ds.cdt.svd.internal.ui.view.wizard.SvdImportExport;
import com.nxp.s32ds.cdt.svd.internal.ui.view.wizard.SvdImportExportRegistersWizardPageBase;
import com.nxp.s32ds.cdt.svd.internal.ui.view.wizard.SvdSelectPathComposite;
import com.nxp.s32ds.cdt.svd.internal.ui.view.wizard.dialog.SvdImportExportRegistryTreeComposite;
import com.nxp.s32ds.cdt.svd.internal.ui.view.wizard.dialog.provider.SvdExportContentProvider;
import com.nxp.s32ds.cdt.svd.internal.ui.view.wizard.dialog.provider.SvdValueExportLabelProvider;
import com.nxp.s32ds.cdt.svd.model.SvdCompositeModel;
import com.nxp.s32ds.cdt.svd.model.SvdRegister;
import com.nxp.s32ds.ext.rcp.jface.viewers.ContainerFilteredCheckboxTreeViewer;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class SvdExportRegistersWizardPage
extends SvdImportExportRegistersWizardPageBase {
    private static final String WIZARD_PAGE_NAME = SvdExportRegistersWizardPage.class.getSimpleName();
    private static final String FILE_KEY = String.valueOf(WIZARD_PAGE_NAME) + ".file";
    private SvdImportExportRegistryTreeComposite filteredTreeComposite;
    private SvdSelectPathComposite selectPathComposite;
    private final IStructuredSelection selection;
    private final ITreeContentProvider contentProvider;
    private final SvdTreeViewerInput input;
    private final SvdDsfSessionCacheListener sessionCacheListener = e -> this.cacheChanged(e);
    private final SvdNameAddressDescriptionLabelProvider nameProvider;
    private final SvdValueExportLabelProvider valueProvider;

    public SvdExportRegistersWizardPage(SvdTreeViewer viewer, IStructuredSelection selection) {
        super(WIZARD_PAGE_NAME, Messages.SvdExportRegistersWizardPage_select_registers_and_output_file, null);
        this.selection = selection;
        this.input = viewer.getInput();
        this.nameProvider = new SvdNameAddressDescriptionLabelProvider(viewer.showFullPath());
        this.valueProvider = new SvdValueExportLabelProvider(viewer, true);
        this.contentProvider = new SvdExportContentProvider(new SvdContentRegisterProvider());
        this.setDefaultMessage(Messages.SvdExportRegistersWizardPage_export_registers_to_the_local_file_system);
        SvdDsfSessionCacheManager.getInstance().addCacheListener(this.sessionCacheListener);
        SvdExportRegistersWizardPage.readRegistersValues(viewer);
    }

    private static void readRegistersValues(SvdTreeViewer viewer) {
        SvdCompositeModel<?> model = viewer.getInput().model;
        model.flattened().filter(e -> e instanceof SvdRegister).map(e -> (SvdRegister)e).forEach(r -> SvdTreeViewerInputs.getValue(viewer, r));
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.filteredTreeComposite.setFocus();
        }
    }

    public void dispose() {
        SvdDsfSessionCacheManager.getInstance().removeCacheListener(this.sessionCacheListener);
        super.dispose();
    }

    private void cacheChanged(SvdDsfSessionCacheListener.CacheEvent e) {
        Optional<DsfSession> opt = Optional.ofNullable(this.input).map(i -> i.launch).map(l -> l.getSession());
        if (!opt.isPresent() || !opt.get().equals((Object)e.session)) {
            return;
        }
        switch (e.type) {
            case UPDATE_START: {
                Display.getDefault().asyncExec(() -> SvdExportRegistersWizardPage.joinToUpdate(SvdDsfSessionCacheManager.UPDATE_JOB_FAMILY));
                break;
            }
            case CACHE_CHANGED: {
                Display.getDefault().asyncExec(() -> {
                    ContainerFilteredCheckboxTreeViewer treeViewer = this.filteredTreeComposite.getTreeViewer();
                    if (treeViewer != null && !treeViewer.getTree().isDisposed()) {
                        treeViewer.refresh();
                    }
                });
                break;
            }
        }
    }

    private static void joinToUpdate(final Object jobFamily) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IProgressService progressService = workbench.getProgressService();
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                try {
                    Job.getJobManager().join(jobFamily, monitor);
                }
                catch (InterruptedException interruptedException) {}
            }
        };
        try {
            progressService.busyCursorWhile(runnable);
        }
        catch (InterruptedException | InvocationTargetException exception) {}
    }

    public Path getFilePath() {
        return this.selectPathComposite.getFilePath();
    }

    public void appendToFilePath(String value) {
        if (!this.selectPathComposite.getText().endsWith(value)) {
            this.selectPathComposite.setText(String.valueOf(this.selectPathComposite.getText()) + value);
        }
    }

    public Object[] getCheckedElements() {
        return this.filteredTreeComposite.getCheckedElements();
    }

    @Override
    public boolean finish() {
        if (!this.fileExist() || this.continueIfExist()) {
            return super.finish();
        }
        return false;
    }

    @Override
    protected void doCreateControl(Composite parent) {
        this.doCreateFilteredTreeComposite(parent);
        this.doCreateFileComposite(parent);
        this.filteredTreeComposite.setInput(this.input);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "com.nxp.s32ds.cdt.svd.ui.EXPORT_REGISTERS_WIZARD_context");
    }

    @Override
    protected void restoreWidgetState(IDialogSettings settings) {
        String string = settings.get(FILE_KEY);
        if (string != null) {
            this.selectPathComposite.setText(string);
        }
        if (this.selection != null && !this.selection.isEmpty()) {
            this.filteredTreeComposite.setCheckedElements(this.selection.toArray());
        }
        this.updatePageComplete();
    }

    @Override
    protected void saveWidgetState(IDialogSettings settings) {
        settings.put(FILE_KEY, this.selectPathComposite.getText());
    }

    protected void doCreateFileComposite(Composite parent) {
        this.selectPathComposite = new SvdSelectPathComposite(parent, 0);
        this.selectPathComposite.setLayoutData(new GridData(768));
        this.selectPathComposite.addModifyListener(e -> this.updatePageComplete());
        this.selectPathComposite.setFilterExtensions(SvdImportExport.EXTENSIONS);
        this.selectPathComposite.setFilterNames(SvdImportExport.NAMES);
    }

    protected void doCreateFilteredTreeComposite(Composite parent) {
        this.filteredTreeComposite = new SvdImportExportRegistryTreeComposite(parent, 0, Messages._registers, this.nameProvider, this.valueProvider, this.contentProvider);
        this.filteredTreeComposite.setLayoutData(new GridData(1808));
        this.filteredTreeComposite.setEmptyTreeMessage(Messages.SvdExportRegistersWizardPage_nothing_to_export);
        this.filteredTreeComposite.setNoElementsSelectedMessage(Messages._no_registers_selected);
        this.filteredTreeComposite.setInitiallyCheckAll(false);
        this.filteredTreeComposite.addCheckStateChangedListener(() -> this.updatePageComplete());
    }

    @Override
    protected IStatus validate() {
        IStatus status = this.filteredTreeComposite.validate();
        if (!status.isOK()) {
            return status;
        }
        return this.selectPathComposite.validate();
    }

    protected boolean fileExist() {
        Path path = this.selectPathComposite.getFilePath();
        return path != null && Files.exists(path, new LinkOption[0]);
    }

    private boolean continueIfExist() {
        return MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.SvdExportRegistersWizardPage_confirm, (String)NLS.bind((String)Messages.SvdExportRegistersWizardPage_file_0_already_exists_do_you_want_to_replace_it, (Object)this.selectPathComposite.getFilePath().getFileName()));
    }
}

