/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.ide.internal.sdk;

import com.nxp.s32ds.cle.ide.sdk.ProjectSdkDescriptor;
import com.nxp.s32ds.cle.ide.sdk.ProjectSdkRegistry;
import com.nxp.s32ds.ext.rcp.registry.BaseRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;

@Component
public class ProjectSdkRegistryImplementation
extends BaseRegistry
implements ProjectSdkRegistry {
    private final Map<String, Collection<ProjectSdkDescriptor>> project2projectSdkDescriptors = new HashMap<String, Collection<ProjectSdkDescriptor>>();
    private final Map<String, Collection<ProjectSdkDescriptor>> sdk2projectSdkDescriptors = new HashMap<String, Collection<ProjectSdkDescriptor>>();

    @Override
    public List<ProjectSdkDescriptor> getProjectSdkDescriptorsByProjectName(String projectName) {
        return this.getReferenceDescriptorsBySourceId(projectName, this.project2projectSdkDescriptors, ProjectSdkDescriptor.class);
    }

    @Override
    public List<ProjectSdkDescriptor> getProjectSdkDescriptorsBySdkId(String sdkId) {
        return this.getReferenceDescriptorsByTargetId(sdkId, this.sdk2projectSdkDescriptors, ProjectSdkDescriptor.class);
    }

    @Override
    public void addProjectSdkDescriptor(ProjectSdkDescriptor descriptor) {
        this.addReferenceDescriptor(descriptor, this.project2projectSdkDescriptors, this.sdk2projectSdkDescriptors, ProjectSdkDescriptor.class);
    }

    @Override
    public void removeProjectSdkDescriptor(ProjectSdkDescriptor descriptor) {
        this.removeReferenceDescriptor(descriptor, this.project2projectSdkDescriptors, this.sdk2projectSdkDescriptors, ProjectSdkDescriptor.class);
    }

    @Override
    public void removeProjectSdkDescriptorsBySdkId(String sdkId) {
        Collection<ProjectSdkDescriptor> collection = this.sdk2projectSdkDescriptors.get(sdkId);
        if (collection != null) {
            ArrayList<ProjectSdkDescriptor> descriptors = new ArrayList<ProjectSdkDescriptor>(collection);
            descriptors.forEach(this::removeProjectSdkDescriptor);
            descriptors.clear();
        }
    }

    @Override
    public List<ProjectSdkDescriptor> getProjectSdkDescriptors() {
        ArrayList<ProjectSdkDescriptor> result = new ArrayList<ProjectSdkDescriptor>();
        this.project2projectSdkDescriptors.values().stream().flatMap(v -> v.stream()).forEach(result::add);
        return result;
    }
}

