/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.pde.api.tools.internal.model.ApiBaseline;
import org.eclipse.pde.api.tools.internal.model.ApiModelCache;
import org.eclipse.pde.api.tools.internal.model.ApiModelFactory;
import org.eclipse.pde.api.tools.internal.model.StubApiComponent;
import org.eclipse.pde.api.tools.internal.model.WorkspaceBaseline;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.IApiBaselineManager;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiBaseline;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.ModelEntry;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.DependencyManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class ApiBaselineManager
implements IApiBaselineManager,
ISaveParticipant {
    private static final String DEFAULT_BASELINE = "default_api_profile";
    public static final String WORKSPACE_API_BASELINE_ID = "workspace";
    private static final String BASELINE_FILE_EXTENSION = ".profile";
    private HashMap<String, IApiBaseline> baselinecache = null;
    private HashMap<String, String> handlecache = null;
    private HashSet<String> hasinfos = null;
    private String defaultbaseline = null;
    private IApiBaseline workspacebaseline = null;
    private IPath savelocation = null;
    private boolean fNeedsSaving = false;
    private static ApiBaselineManager fInstance = null;

    private ApiBaselineManager(boolean framework) {
        if (framework) {
            ApiPlugin.getDefault().addSaveParticipant(this);
            this.savelocation = ApiPlugin.getDefault().getStateLocation().append(".api_profiles").addTrailingSeparator();
        }
    }

    public static synchronized ApiBaselineManager getManager() {
        if (fInstance == null) {
            fInstance = new ApiBaselineManager(ApiPlugin.isRunningInFramework());
        }
        return fInstance;
    }

    @Override
    public synchronized IApiBaseline getApiBaseline(String name) {
        this.initializeStateCache();
        return this.baselinecache.get(name);
    }

    @Override
    public synchronized IApiBaseline[] getApiBaselines() {
        this.initializeStateCache();
        return this.baselinecache.values().toArray(new IApiBaseline[this.baselinecache.size()]);
    }

    @Override
    public synchronized void addApiBaseline(IApiBaseline newbaseline) {
        if (newbaseline != null) {
            this.initializeStateCache();
            this.baselinecache.put(newbaseline.getName(), newbaseline);
            if (((ApiBaseline)newbaseline).peekInfos()) {
                this.hasinfos.add(newbaseline.getName());
            }
            this.fNeedsSaving = true;
        }
    }

    @Override
    public synchronized boolean removeApiBaseline(String name) {
        if (name != null) {
            this.initializeStateCache();
            IApiBaseline baseline = this.baselinecache.remove(name);
            if (baseline != null) {
                baseline.dispose();
                boolean success = true;
                if (this.savelocation == null) {
                    return success;
                }
                File file = this.savelocation.append(String.valueOf(name) + BASELINE_FILE_EXTENSION).toFile();
                if (file.exists()) {
                    success &= file.delete();
                }
                this.fNeedsSaving = true;
                ApiModelCache.getCache().removeElementInfo(baseline);
                return success;
            }
        }
        return false;
    }

    public void loadBaselineInfos(IApiBaseline baseline) throws CoreException {
        File file;
        this.initializeStateCache();
        if (this.hasinfos.contains(baseline.getName())) {
            return;
        }
        String filename = this.handlecache.get(baseline.getName());
        if (filename != null && (file = new File(filename)).exists()) {
            block16: {
                FileInputStream inputStream = null;
                try {
                    try {
                        inputStream = new FileInputStream(file);
                        this.restoreBaseline(baseline, inputStream);
                    }
                    catch (IOException e) {
                        ApiPlugin.log(e);
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (IOException iOException) {}
                        }
                        break block16;
                    }
                }
                catch (Throwable throwable) {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            this.hasinfos.add(baseline.getName());
        }
    }

    private synchronized void initializeStateCache() {
        long time = System.currentTimeMillis();
        if (this.baselinecache == null) {
            String def;
            Object baseline;
            this.handlecache = new HashMap(8);
            this.hasinfos = new HashSet(8);
            this.baselinecache = new LinkedHashMap<String, IApiBaseline>(8);
            if (!ApiPlugin.isRunningInFramework()) {
                return;
            }
            File[] baselines = this.savelocation.toFile().listFiles(pathname -> pathname.getName().endsWith(BASELINE_FILE_EXTENSION));
            if (baselines != null) {
                ApiBaseline newbaseline = null;
                File[] fileArray = baselines;
                int n = baselines.length;
                int n2 = 0;
                while (n2 < n) {
                    baseline = fileArray[n2];
                    if (((File)baseline).exists()) {
                        newbaseline = new ApiBaseline(new Path(((File)baseline).getName()).removeFileExtension().toString());
                        this.handlecache.put(newbaseline.getName(), ((File)baseline).getAbsolutePath());
                        this.baselinecache.put(newbaseline.getName(), newbaseline);
                    }
                    ++n2;
                }
            }
            String string = this.defaultbaseline = (baseline = this.baselinecache.get(def = this.getDefaultProfilePref())) != null ? def : null;
            if (ApiPlugin.DEBUG_BASELINE_MANAGER) {
                System.out.println("Time to initialize state cache: " + (System.currentTimeMillis() - time) + "ms");
            }
        }
    }

    private String getDefaultProfilePref() {
        IPreferencesService service = Platform.getPreferencesService();
        return service.getString("org.eclipse.pde.api.tools", DEFAULT_BASELINE, null, new IScopeContext[]{InstanceScope.INSTANCE});
    }

    private void persistStateCache() throws CoreException, IOException {
        if (this.savelocation == null) {
            return;
        }
        IEclipsePreferences node = InstanceScope.INSTANCE.getNode("org.eclipse.pde.api.tools");
        if (this.defaultbaseline != null) {
            node.put(DEFAULT_BASELINE, this.defaultbaseline);
        } else {
            node.remove(DEFAULT_BASELINE);
        }
        if (this.baselinecache != null && this.hasinfos != null) {
            File dir = new File(this.savelocation.toOSString());
            if (!dir.exists()) {
                dir.mkdirs();
            }
            String id = null;
            File file = null;
            FileOutputStream fout = null;
            IApiBaseline baseline = null;
            for (Map.Entry<String, IApiBaseline> entry : this.baselinecache.entrySet()) {
                id = entry.getKey();
                baseline = entry.getValue();
                if (!this.hasinfos.contains(baseline.getName())) continue;
                file = this.savelocation.append(String.valueOf(id) + BASELINE_FILE_EXTENSION).toFile();
                if (!file.exists()) {
                    file.createNewFile();
                }
                try {
                    fout = new FileOutputStream(file);
                    this.writeBaselineDescription(baseline, fout);
                    this.handlecache.put(baseline.getName(), file.getAbsolutePath());
                    fout.flush();
                }
                finally {
                    if (fout != null) {
                        fout.close();
                    }
                }
            }
        }
    }

    private void writeBaselineDescription(IApiBaseline baseline, OutputStream stream) throws CoreException {
        String xml = this.getProfileXML(baseline);
        try {
            stream.write(xml.getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            ApiBaselineManager.abort("Error writing pofile descrition", e);
        }
    }

    private String getProfileXML(IApiBaseline baseline) throws CoreException {
        IApiComponent[] components;
        Document document = Util.newDocument();
        Element root = document.createElement("apiprofile");
        document.appendChild(root);
        root.setAttribute("name", baseline.getName());
        root.setAttribute("version", "2");
        String location = baseline.getLocation();
        if (location != null) {
            root.setAttribute("location", location);
        }
        Element celement = null;
        IApiComponent[] iApiComponentArray = components = baseline.getApiComponents();
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            IApiComponent component = iApiComponentArray[n2];
            HashSet<IApiComponent> allComponentSet = new HashSet<IApiComponent>();
            Set<IApiComponent> multipleComponents = baseline.getAllApiComponents(component.getSymbolicName());
            if (multipleComponents.isEmpty()) {
                allComponentSet.add(component);
            } else {
                allComponentSet.addAll(multipleComponents);
            }
            for (IApiComponent iApiComponent : allComponentSet) {
                if (iApiComponent.isSystemComponent()) continue;
                celement = document.createElement("apicomponent");
                celement.setAttribute("id", iApiComponent.getSymbolicName());
                celement.setAttribute("version", iApiComponent.getVersion());
                celement.setAttribute("location", new Path(iApiComponent.getLocation()).toPortableString());
                root.appendChild(celement);
            }
            allComponentSet.clear();
            ++n2;
        }
        return Util.serializeDocument(document);
    }

    private static void abort(String message, Throwable e) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.api.tools", message, e));
    }

    private void restoreBaseline(IApiBaseline baseline, InputStream stream) throws CoreException {
        long start;
        block23: {
            start = System.currentTimeMillis();
            DocumentBuilder parser = null;
            try {
                parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                parser.setErrorHandler(new DefaultHandler());
            }
            catch (FactoryConfigurationError | ParserConfigurationException e) {
                ApiBaselineManager.abort("Error restoring API baseline", e);
            }
            try {
                try {
                    Document document = parser.parse(stream);
                    Element root = document.getDocumentElement();
                    if (root.getNodeName().equals("apiprofile")) {
                        String location;
                        String baselineLocation = root.getAttribute("location");
                        if (baselineLocation != null && !baselineLocation.equals("")) {
                            baseline.setLocation(Path.fromPortableString((String)baselineLocation).toOSString());
                        }
                        NodeList children = root.getElementsByTagName("apicomponent");
                        ArrayList<IApiComponent> components = new ArrayList<IApiComponent>();
                        int j = 0;
                        while (j < children.getLength()) {
                            IApiComponent component;
                            Element componentNode = (Element)children.item(j);
                            if (componentNode.getParentNode().equals(root) && (component = ApiModelFactory.newApiComponent(baseline, Path.fromPortableString((String)(location = componentNode.getAttribute("location"))).toOSString())) != null) {
                                components.add(component);
                            }
                            ++j;
                        }
                        children = root.getElementsByTagName("pool");
                        IApiComponent component = null;
                        int j2 = 0;
                        while (j2 < children.getLength()) {
                            location = ((Element)children.item(j2)).getAttribute("location");
                            IPath poolPath = Path.fromPortableString((String)location);
                            NodeList componentNodes = root.getElementsByTagName("apicomponent");
                            int i = 0;
                            while (i < componentNodes.getLength()) {
                                Element compElement = (Element)componentNodes.item(i);
                                String id = compElement.getAttribute("id");
                                String ver = compElement.getAttribute("version");
                                StringBuilder name = new StringBuilder();
                                name.append(id);
                                name.append('_');
                                name.append(ver);
                                File file = poolPath.append(name.toString()).toFile();
                                if (!file.exists()) {
                                    name.append(".jar");
                                    file = poolPath.append(name.toString()).toFile();
                                }
                                if ((component = ApiModelFactory.newApiComponent(baseline, file.getAbsolutePath())) != null) {
                                    components.add(component);
                                }
                                ++i;
                            }
                            ++j2;
                        }
                        baseline.addApiComponents(components.toArray(new IApiComponent[components.size()]));
                    }
                }
                catch (IOException | SAXException e) {
                    ApiBaselineManager.abort("Error restoring API baseline", e);
                    try {
                        stream.close();
                    }
                    catch (IOException io) {
                        ApiPlugin.log(io);
                    }
                    break block23;
                }
            }
            catch (Throwable throwable) {
                try {
                    stream.close();
                }
                catch (IOException io) {
                    ApiPlugin.log(io);
                }
                throw throwable;
            }
            try {
                stream.close();
            }
            catch (IOException io) {
                ApiPlugin.log(io);
            }
        }
        if (baseline == null) {
            ApiBaselineManager.abort("Invalid baseline description", null);
        }
        if (ApiPlugin.DEBUG_BASELINE_MANAGER) {
            System.out.println("Time to restore a persisted baseline : " + (System.currentTimeMillis() - start) + "ms");
        }
    }

    public void saving(ISaveContext context) throws CoreException {
        if (!this.fNeedsSaving) {
            return;
        }
        try {
            this.persistStateCache();
            this.cleanStateCache();
            this.fNeedsSaving = false;
        }
        catch (IOException e) {
            ApiPlugin.log(e);
        }
    }

    private void cleanStateCache() {
        if (this.baselinecache != null) {
            IApiBaseline baseline = null;
            for (Map.Entry<String, IApiBaseline> entry : this.baselinecache.entrySet()) {
                baseline = entry.getValue();
                if (baseline.getName().equals(this.defaultbaseline)) continue;
                baseline.dispose();
                this.hasinfos.remove(baseline.getName());
            }
        }
    }

    public boolean isExistingProfileName(String name) {
        if (this.baselinecache == null) {
            return false;
        }
        return this.baselinecache.containsKey(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        try {
            if (this.baselinecache != null) {
                for (IApiBaseline iApiBaseline : this.baselinecache.values()) {
                    iApiBaseline.dispose();
                }
                this.baselinecache.clear();
            }
            ApiBaselineManager apiBaselineManager = this;
            synchronized (apiBaselineManager) {
                if (this.workspacebaseline != null) {
                    this.workspacebaseline.dispose();
                }
            }
            if (this.handlecache != null) {
                this.handlecache.clear();
            }
            if (this.hasinfos != null) {
                this.hasinfos.clear();
            }
            StubApiComponent.disposeAllCaches();
        }
        finally {
            if (ApiPlugin.isRunningInFramework()) {
                ApiPlugin.getDefault().removeSaveParticipant(this);
            }
        }
    }

    public void doneSaving(ISaveContext context) {
    }

    public void prepareToSave(ISaveContext context) throws CoreException {
    }

    public void rollback(ISaveContext context) {
    }

    @Override
    public synchronized IApiBaseline getDefaultApiBaseline() {
        this.initializeStateCache();
        return this.baselinecache.get(this.defaultbaseline);
    }

    @Override
    public void setDefaultApiBaseline(String name) {
        this.fNeedsSaving = true;
        this.defaultbaseline = name;
    }

    @Override
    public synchronized IApiBaseline getWorkspaceBaseline() {
        if (ApiPlugin.isRunningInFramework()) {
            if (this.workspacebaseline == null) {
                try {
                    this.workspacebaseline = this.createWorkspaceBaseline();
                }
                catch (CoreException e) {
                    ApiPlugin.log(e);
                }
            }
            return this.workspacebaseline;
        }
        return null;
    }

    synchronized void disposeWorkspaceBaseline() {
        if (this.workspacebaseline != null) {
            if (ApiPlugin.DEBUG_BASELINE_MANAGER) {
                System.out.println("disposing workspace baseline");
            }
            this.workspacebaseline.dispose();
            StubApiComponent.disposeAllCaches();
            this.workspacebaseline = null;
        }
    }

    private IApiBaseline createWorkspaceBaseline() throws CoreException {
        long time = System.currentTimeMillis();
        WorkspaceBaseline baseline = null;
        try {
            baseline = new WorkspaceBaseline();
            Set ids = DependencyManager.getSelfandDependencies((IPluginModelBase[])PluginRegistry.getWorkspaceModels(), null);
            ArrayList<IApiComponent> componentsList = new ArrayList<IApiComponent>(ids.size());
            IApiComponent apiComponent = null;
            ModelEntry modelEntry = null;
            for (String id : ids) {
                modelEntry = PluginRegistry.findEntry((String)id);
                IPluginModelBase[] workspaceModels = modelEntry.getWorkspaceModels();
                if (workspaceModels.length == 0) {
                    IPluginModelBase externalModel = PluginRegistry.findModel((String)id);
                    if (externalModel == null) continue;
                    try {
                        apiComponent = ApiModelFactory.newApiComponent((IApiBaseline)baseline, externalModel);
                        if (apiComponent == null) continue;
                        componentsList.add(apiComponent);
                    }
                    catch (CoreException e) {
                        ApiPlugin.log(e);
                    }
                    continue;
                }
                IPluginModelBase[] iPluginModelBaseArray = workspaceModels;
                int n = workspaceModels.length;
                int n2 = 0;
                while (n2 < n) {
                    IPluginModelBase iPluginModelBase = iPluginModelBaseArray[n2];
                    try {
                        apiComponent = ApiModelFactory.newApiComponent((IApiBaseline)baseline, iPluginModelBase);
                        if (apiComponent != null) {
                            componentsList.add(apiComponent);
                        }
                    }
                    catch (CoreException e) {
                        ApiPlugin.log(e);
                    }
                    ++n2;
                }
            }
            baseline.addApiComponents(componentsList.toArray(new IApiComponent[componentsList.size()]));
        }
        finally {
            if (ApiPlugin.DEBUG_BASELINE_MANAGER) {
                System.out.println("Time to create a workspace baseline : " + (System.currentTimeMillis() - time) + "ms");
            }
        }
        return baseline;
    }

    @Override
    public synchronized IApiComponent getWorkspaceComponent(String symbolicName) {
        IApiBaseline baseline = this.getWorkspaceBaseline();
        if (baseline != null) {
            return baseline.getApiComponent(symbolicName);
        }
        return null;
    }
}

