/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.volkano.internal.core;

import com.nxp.s32ds.debug.ide.volkano.CommandExecutor;
import com.nxp.s32ds.debug.ide.volkano.internal.core.VolkanoActivator;
import com.nxp.s32ds.debug.ide.volkano.internal.core.VolkanoMessage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class CommandExecutorImpl
implements CommandExecutor {
    private static final String ERROR_TEMPLATE = "**error**";
    private List<String> output = new ArrayList<String>();

    @Override
    public IStatus exec(ProcessBuilder processBuilder) throws IOException {
        if (processBuilder == null) {
            return new Status(4, VolkanoActivator.getBundle().getBundleId(), VolkanoMessage.Volkano_command_empty_or_null);
        }
        Process process = processBuilder.start();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                this.output.clear();
                this.output = reader.lines().collect(Collectors.toList());
                if (CommandExecutorImpl.outputHasErrors(this.output)) {
                    String message = CommandExecutorImpl.buildErrorMessage(this.output);
                    return VolkanoActivator.getBundle().createError(NLS.bind((String)VolkanoMessage.Volkano_error_execute_command, (Object)message));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            return new Status(4, VolkanoActivator.getBundle().getBundleId(), e.getMessage());
        }
        return Status.OK_STATUS;
    }

    private static boolean outputHasErrors(List<String> output) {
        return output.stream().anyMatch(l -> l.contains(ERROR_TEMPLATE));
    }

    private static String buildErrorMessage(List<String> output) {
        return output.stream().filter(item -> item.contains(ERROR_TEMPLATE)).map(item -> item.replaceAll(Pattern.quote(ERROR_TEMPLATE), "")).map(String::trim).collect(Collectors.joining());
    }

    @Override
    public List<String> getOutput() {
        return this.output;
    }
}

