/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.runtime.sdk.internal.registry.core.symbol;

import com.nxp.s32ds.cle.runtime.sdk.registry.symbol.SymbolSdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.symbol.SymbolSdkKind;
import com.nxp.s32ds.ext.rcp.registry.ElementDescriptor;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SymbolSdkDescriptorImplementation
extends ElementDescriptor
implements SymbolSdkDescriptor {
    private String sdkId;
    private String toolChainId;

    public SymbolSdkDescriptorImplementation(Element element, String sdkId) {
        super(element);
        this.addSubstitution("sourceId", "name");
        this.sdkId = sdkId;
        this.toolChainId = "";
    }

    public SymbolSdkDescriptorImplementation(Element element, String sdkId, String toolChainId) {
        this(element, sdkId);
        this.toolChainId = toolChainId;
    }

    public String getName() {
        return this.getSourceId();
    }

    public String getSdkId() {
        return this.getTargetId();
    }

    public String getTargetId() {
        return this.sdkId;
    }

    public String getToolChainId() {
        return this.toolChainId;
    }

    public SymbolSdkKind getKind() {
        return SymbolSdkKind.of((String)this.getAttribute("type"));
    }

    public String getLangId() {
        return this.getAttribute("langId");
    }

    public Set<String> getConfigurations() {
        return this.getAttributesSet("configurations");
    }

    public String getConditionRef() {
        return this.getAttribute("conditionRef");
    }

    public String toString() {
        String conditionRef;
        StringBuilder sb = new StringBuilder();
        sb.append("Symbol: name=").append(this.getName()).append(" type=").append(this.getKind());
        String langId = this.getLangId();
        if (!langId.isEmpty()) {
            sb.append(" langId=").append(langId);
        }
        if (!(conditionRef = this.getConditionRef()).isEmpty()) {
            sb.append(" conditionRef=").append(conditionRef);
        } else {
            Set<String> configurations = this.getConfigurations();
            if (!configurations.isEmpty()) {
                sb.append(" configurations=").append(String.join((CharSequence)",", configurations));
            }
        }
        sb.append(" toolChainId=").append(this.getToolChainId()).append(" sdkId=").append(this.getSdkId());
        return sb.toString();
    }

    public Element convertToXml(Document document, Element holderElement) {
        String conditionRef;
        Element symbolElement = document.createElement("symbol");
        symbolElement.setAttribute("name", this.getName());
        symbolElement.setAttribute("langId", this.getLangId());
        symbolElement.setAttribute("type", this.getKind().getXmlTypeAttribueValue());
        Set<String> configurations = this.getConfigurations();
        if (!configurations.isEmpty()) {
            symbolElement.setAttribute("configurations", String.join((CharSequence)",", configurations));
        }
        if (!(conditionRef = this.getConditionRef()).isEmpty()) {
            symbolElement.setAttribute("conditionRef", conditionRef);
        }
        holderElement.appendChild(symbolElement);
        return symbolElement;
    }
}

