/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.runtime.sdk.registry.core.environment;

import com.nxp.s32ds.cle.runtime.sdk.internal.registry.core.Messages;
import com.nxp.s32ds.cle.runtime.sdk.internal.registry.core.SdkRegistryCoreActivator;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.SdkRegistryLogger;
import com.nxp.s32ds.cle.runtime.sdk.registry.environment.EnvironmentSdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.environment.EnvironmentSdkRegistry;
import java.util.List;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EnvironmentSdkDescriptors {
    private EnvironmentSdkDescriptors() {
    }

    public static EnvironmentSdkRegistry getEnvironmentSdkRegistry() {
        return SdkRegistryCoreActivator.getInstance().getEnvironmentSdkRegistry();
    }

    public static List<EnvironmentSdkDescriptor> getEnvironmentSdkDescriptors() {
        return EnvironmentSdkDescriptors.getEnvironmentSdkRegistry().getEnvironmentSdkDescriptors();
    }

    public static List<EnvironmentSdkDescriptor> getEnvironmentSdkDescriptorsByName(String name) {
        return EnvironmentSdkDescriptors.getEnvironmentSdkRegistry().getEnvironmentSdkDescriptorsByName(name);
    }

    public static EnvironmentSdkDescriptor getEnvironmentSdkDescriptorByName(String name) {
        List<EnvironmentSdkDescriptor> descriptors = EnvironmentSdkDescriptors.getEnvironmentSdkDescriptorsByName(name);
        return !descriptors.isEmpty() ? descriptors.get(0) : null;
    }

    public static List<EnvironmentSdkDescriptor> getEnvironmentSdkDescriptorsBySdkId(String sdkId) {
        return EnvironmentSdkDescriptors.getEnvironmentSdkRegistry().getEnvironmentSdkDescriptorsBySdkId(sdkId);
    }

    public static EnvironmentSdkDescriptor getEnvironmentSdkDescriptorBySdkId(String sdkId) {
        List<EnvironmentSdkDescriptor> descriptors = EnvironmentSdkDescriptors.getEnvironmentSdkDescriptorsBySdkId(sdkId);
        return !descriptors.isEmpty() ? descriptors.get(0) : null;
    }

    public static void addEnvironmentSdkDescriptor(EnvironmentSdkDescriptor descriptor) {
        EnvironmentSdkDescriptors.getEnvironmentSdkRegistry().addEnvironmentSdkDescriptor(descriptor);
        SdkRegistryLogger.logDebugInfo(NLS.bind((String)Messages.EnvironmentSdkDescriptors_register_descriptor_message, (Object)descriptor.getName(), (Object)descriptor.getSdkId()));
    }

    public static void removeEnvironmentSdkDescriptor(EnvironmentSdkDescriptor descriptor) {
        EnvironmentSdkDescriptors.getEnvironmentSdkRegistry().removeEnvironmentSdkDescriptor(descriptor);
        SdkRegistryLogger.logDebugInfo(NLS.bind((String)Messages.EnvironmentSdkDescriptors_unregister_descriptor_message, (Object)descriptor.getName(), (Object)descriptor.getSdkId()));
    }

    public static void removeEnvironmentSdkDescriptors(String sdkId) {
        EnvironmentSdkDescriptors.getEnvironmentSdkRegistry().removeEnvironmentSdkDescriptorsBySdkId(sdkId);
        SdkRegistryLogger.logDebugInfo(NLS.bind((String)Messages.EnvironmentSdkDescriptors_unregister_descriptors_message, (Object)sdkId));
    }

    public static void convertToXml(String sdkId, Document document, Element holderElement) {
        EnvironmentSdkDescriptor environment = EnvironmentSdkDescriptors.getEnvironmentSdkDescriptorBySdkId(sdkId);
        if (environment != null) {
            environment.convertToXml(document, holderElement);
        }
    }
}

