/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.runtime.sdk.registry.core.module;

import com.nxp.s32ds.cle.runtime.sdk.internal.registry.core.Messages;
import com.nxp.s32ds.cle.runtime.sdk.internal.registry.core.SdkRegistryCoreActivator;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.SdkRegistryLogger;
import com.nxp.s32ds.cle.runtime.sdk.registry.module.ModuleSdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.module.ModuleSdkRegistry;
import java.util.List;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ModuleSdkDescriptors {
    private ModuleSdkDescriptors() {
    }

    public static ModuleSdkRegistry getModuleSdkRegistry() {
        return SdkRegistryCoreActivator.getInstance().getModuleSdkRegistry();
    }

    public static List<ModuleSdkDescriptor> getModuleSdkDescriptors() {
        return ModuleSdkDescriptors.getModuleSdkRegistry().getModuleSdkDescriptors();
    }

    public static List<ModuleSdkDescriptor> getModuleSdkDescriptorsByModuleId(String moduleId) {
        return ModuleSdkDescriptors.getModuleSdkRegistry().getModuleSdkDescriptorsByModuleId(moduleId);
    }

    public static List<ModuleSdkDescriptor> getModuleSdkDescriptorsBySdkId(String sdkId) {
        return ModuleSdkDescriptors.getModuleSdkRegistry().getModuleSdkDescriptorsBySdkId(sdkId);
    }

    public static void addModuleSdkDescriptor(ModuleSdkDescriptor descriptor) {
        ModuleSdkDescriptors.getModuleSdkRegistry().addModuleSdkDescriptor(descriptor);
        SdkRegistryLogger.logDebugInfo(NLS.bind((String)Messages.ModuleSdkDescriptors_register_descriptor_message, (Object)descriptor.getModuleId(), (Object)descriptor.getSdkId()));
    }

    public static void removeModuleSdkDescriptor(ModuleSdkDescriptor descriptor) {
        ModuleSdkDescriptors.getModuleSdkRegistry().removeModuleSdkDescriptor(descriptor);
        SdkRegistryLogger.logDebugInfo(NLS.bind((String)Messages.ModuleSdkDescriptors_unregister_descriptor_message, (Object)descriptor.getModuleId(), (Object)descriptor.getSdkId()));
    }

    public static void removeModuleSdkDescriptors(String sdkId) {
        ModuleSdkDescriptors.getModuleSdkRegistry().removeModuleSdkDescriptorsBySdkId(sdkId);
        SdkRegistryLogger.logDebugInfo(NLS.bind((String)Messages.ModuleSdkDescriptors_unregister_descriptors_message, (Object)sdkId));
    }

    public static void convertToXml(String sdkId, Document document, Element holderElement) {
        List<ModuleSdkDescriptor> modules = ModuleSdkDescriptors.getModuleSdkDescriptorsBySdkId(sdkId);
        if (!modules.isEmpty()) {
            Element modulesElement = document.createElement("modules");
            modules.forEach(module -> {
                Element element2 = module.convertToXml(document, modulesElement);
            });
            holderElement.appendChild(modulesElement);
        }
    }
}

