/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.runtime.sdk.registry.core.toolchain;

import com.nxp.s32ds.cle.runtime.sdk.internal.registry.core.Messages;
import com.nxp.s32ds.cle.runtime.sdk.internal.registry.core.SdkRegistryCoreActivator;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.SdkRegistryLogger;
import com.nxp.s32ds.cle.runtime.sdk.registry.toolchain.ToolChainSdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.toolchain.ToolChainSdkRegistry;
import java.util.List;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ToolChainSdkDescriptors {
    private ToolChainSdkDescriptors() {
    }

    public static ToolChainSdkRegistry getToolChainSdkRegistry() {
        return SdkRegistryCoreActivator.getInstance().getToolChainSdkRegistry();
    }

    public static List<ToolChainSdkDescriptor> getToolChainSdkDescriptors() {
        return ToolChainSdkDescriptors.getToolChainSdkRegistry().getToolChainSdkDescriptors();
    }

    public static List<ToolChainSdkDescriptor> getToolChainSdkDescriptorsByToolChainId(String toolChainId) {
        return ToolChainSdkDescriptors.getToolChainSdkRegistry().getToolChainSdkDescriptorsByToolChainId(toolChainId);
    }

    public static List<ToolChainSdkDescriptor> getToolChainSdkDescriptorsBySdkId(String sdkId) {
        return ToolChainSdkDescriptors.getToolChainSdkRegistry().getToolChainSdkDescriptorsBySdkId(sdkId);
    }

    public static ToolChainSdkDescriptor getRootToolChainSdkDescriptor(String sdkId) {
        return ToolChainSdkDescriptors.getToolChainSdkDescriptorsBySdkId(sdkId).stream().filter(ToolChainSdkDescriptor::isRootToolChain).findFirst().orElse(null);
    }

    public static void addToolChainSdkDescriptor(ToolChainSdkDescriptor descriptor) {
        ToolChainSdkDescriptors.getToolChainSdkRegistry().addToolChainSdkDescriptor(descriptor);
        SdkRegistryLogger.logDebugInfo(NLS.bind((String)Messages.ToolChainSdkDescriptors_register_descriptor_message, (Object)descriptor.getToolChainId(), (Object)descriptor.getSdkId()));
    }

    public static void removeToolChainSdkDescriptor(ToolChainSdkDescriptor descriptor) {
        ToolChainSdkDescriptors.getToolChainSdkRegistry().removeToolChainSdkDescriptor(descriptor);
        SdkRegistryLogger.logDebugInfo(NLS.bind((String)Messages.ToolChainSdkDescriptors_unregister_descriptor_message, (Object)descriptor.getToolChainId(), (Object)descriptor.getSdkId()));
    }

    public static void removeToolChainSdkDescriptors(String sdkId) {
        ToolChainSdkDescriptors.getToolChainSdkRegistry().removeToolChainSdkDescriptorsBySdkId(sdkId);
        SdkRegistryLogger.logDebugInfo(NLS.bind((String)Messages.ToolChainSdkDescriptors_unregister_descriptors_message, (Object)sdkId));
    }

    public static void convertToXml(String sdkId, Document document, Element holderElement) {
        ToolChainSdkDescriptors.getToolChainSdkDescriptorsBySdkId(sdkId).forEach(toolChain -> {
            Element element2 = toolChain.convertToXml(document, holderElement);
        });
    }
}

