/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.runtime.hardware.internal.registry;

import com.nxp.s32ds.cle.runtime.hardware.registry.HardwareCompatibilityDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.HardwareCompatibilityRegistry;
import com.nxp.s32ds.ext.rcp.registry.BaseRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public class HardwareCompatibilityRegistryImpl
extends BaseRegistry
implements HardwareCompatibilityRegistry {
    private Map<String, List<HardwareCompatibilityDescriptor>> descriptors = new HashMap<String, List<HardwareCompatibilityDescriptor>>();

    @Override
    public List<HardwareCompatibilityDescriptor> getHardwareCompatibilityDescriptors(String component) {
        return this.descriptors.computeIfAbsent(component, new Function<String, List<HardwareCompatibilityDescriptor>>(){

            @Override
            public List<HardwareCompatibilityDescriptor> apply(String t) {
                return Collections.emptyList();
            }
        });
    }

    @Override
    public HardwareCompatibilityDescriptor getCompatibleHardwareByComponent(String component, String source) {
        Optional<HardwareCompatibilityDescriptor> optDecsriptor = this.getHardwareCompatibilityDescriptors(component).stream().filter(d -> d.getHardwareSource().equals(source)).findFirst();
        if (optDecsriptor.isPresent()) {
            return optDecsriptor.get();
        }
        return null;
    }

    @Override
    public void addHardwareCompatiblityDescriptor(HardwareCompatibilityDescriptor descriptor) {
        this.descriptors.computeIfAbsent(descriptor.getComponent(), d -> new ArrayList()).add(descriptor);
    }

    @Override
    public List<HardwareCompatibilityDescriptor> getHardwareCompatibilityDescriptors() {
        return this.descriptors.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }
}

