/*
 * Decompiled with CFR 0.152.
 */
package animations.swt;

import animations.swt.EaseEffects.Bounce;
import animations.swt.EaseEffects.Chain;
import animations.swt.EaseEffects.Exponential;
import animations.swt.EaseEffects.Pulse;
import animations.swt.EaseEffects.Shake;
import animations.swt.EaseEffects.Spike;
import org.pushingpixels.trident.api.ease.Linear;
import org.pushingpixels.trident.api.ease.Sine;
import org.pushingpixels.trident.api.ease.Spline;
import org.pushingpixels.trident.api.ease.TimelineEase;

public enum EaseSelector {
    LINEAR((TimelineEase)new Linear()),
    SINE((TimelineEase)new Sine()),
    SPLINE((TimelineEase)new Spline(0.5f)),
    EXP(new Exponential()),
    BOUNCE(new Bounce()),
    PULSE(new Pulse()),
    SHAKE(new Shake()),
    SPIKE(new Spike()),
    CHAIN(new Chain(BOUNCE, LINEAR));

    private TimelineEase timelineEase;

    private EaseSelector(TimelineEase timelineEase) {
        this.timelineEase = timelineEase;
    }

    public EaseSelector addEaseToChain(EaseSelector ... easeSelector) {
        this.timelineEase = new Chain(easeSelector);
        return CHAIN;
    }

    public TimelineEase select() {
        return this.timelineEase;
    }
}

