/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.rcp.license.ui;

import com.nxp.s32ds.rcp.license.core.FNOId;
import com.nxp.s32ds.rcp.license.core.LicenseChangeRequest;
import com.nxp.s32ds.rcp.license.core.LicenseCoreActivator;
import com.nxp.s32ds.rcp.license.core.LicenseException;
import com.nxp.s32ds.rcp.license.ui.ExpectedFeature;
import com.nxp.s32ds.rcp.license.ui.LicenseUIActivator;
import com.nxp.s32ds.rcp.license.ui.Messages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ActivateWindow
extends Dialog {
    private static final boolean ENABLE_REFRESH = true;
    private Text actIDText;
    private Button checkOffline;
    private Button btnLoadOfflineResponse;
    private final boolean activationMode;
    private final ExpectedFeature feature;

    public ActivateWindow(Shell parentShell, ExpectedFeature feature, boolean activationMode) {
        super(parentShell);
        this.feature = feature;
        this.activationMode = activationMode;
        this.setShellStyle(67696);
        this.setBlockOnOpen(true);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        String featureLabel = this.feature.getLabel();
        newShell.setText(Messages.getString(this.activationMode ? "LicenseWindow_titleActivate" : "LicenseWindow_titleOpen", new String[]{featureLabel}));
    }

    protected void createButtonsForButtonBar(Composite parent) {
        if (this.activationMode) {
            this.createButton(parent, 0, Messages.getString("LicenseWindow_activate", null), true);
        } else {
            this.createButton(parent, 0, Messages.getString("LicenseWindow_return", null), false);
        }
        if (this.activationMode) {
            this.btnLoadOfflineResponse = this.createButton(parent, 1025, Messages.getString("LicenseWindow_activateLoadOffline", null), false);
            this.btnLoadOfflineResponse.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    ActivateWindow.this.processOfflineResponse();
                }
            });
        } else {
            Button btnRefresh = this.createButton(parent, 1026, Messages.getString("LicenseWindow_refresh", null), false);
            btnRefresh.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CLLJob cllJob = new CLLJob(){

                        @Override
                        public void runCLL() throws LicenseException {
                            try {
                                LicenseUIActivator.getService().refresh(LicenseUIActivator.getService().fetchLicenseFeature((FNOId)ActivateWindow.this.feature).getActivationId());
                            }
                            catch (LicenseException e) {
                                LicenseCoreActivator.log((int)4, (String)e.getMessage());
                            }
                        }
                    };
                    BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)cllJob);
                    if (cllJob.getException() != null) {
                        LicenseCoreActivator.log((int)4, (String)cllJob.getException().getMessage());
                        ActivateWindow.this.showError("Offline Activation error", cllJob.getException().getMessage());
                    }
                    ActivateWindow.super.okPressed();
                }
            });
        }
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, !this.activationMode);
    }

    protected Control createDialogArea(Composite parent) {
        Composite panel = new Composite((Composite)super.createDialogArea(parent), 0);
        GridLayout layout = new GridLayout(2, false);
        panel.setLayout((Layout)layout);
        panel.setLayoutData((Object)new GridData(1808));
        new Label(panel, 0).setText("Software Activation Code: ");
        this.actIDText = new Text(panel, 2048);
        String actId = "";
        if (!this.activationMode) {
            try {
                actId = LicenseUIActivator.getService().fetchLicenseFeature((FNOId)this.feature).getActivationId();
            }
            catch (LicenseException e) {
                actId = "error";
                LicenseCoreActivator.log((int)4, (String)e.getMessage());
            }
        }
        this.actIDText.setText(actId);
        this.actIDText.setLayoutData((Object)new GridData(768));
        this.actIDText.setEditable(this.activationMode);
        this.checkOffline = new Button(panel, 32);
        GridData gdata = new GridData();
        gdata.horizontalSpan = 2;
        this.checkOffline.setLayoutData((Object)gdata);
        this.checkOffline.setText(Messages.getString("LicenseWindow_activateGenerateOfflineRequest", null));
        return panel;
    }

    protected void okPressed() {
        try {
            if (this.isOfflineMode()) {
                if (this.activationMode) {
                    this.generateOfflineRequest(false);
                    return;
                }
                this.generateOfflineRequest(true);
                super.okPressed();
            } else {
                this.onlineRequest(!this.activationMode);
            }
            super.okPressed();
        }
        catch (Exception e) {
            LicenseCoreActivator.log((int)2, (String)e.getMessage());
            this.showError("Software Activation Code error", e.getMessage());
        }
    }

    private boolean generateOfflineRequest(boolean returnLicense) throws LicenseException {
        FileDialog fDialog = new FileDialog(this.getShell(), 8192);
        fDialog.setFileName("request.xml");
        fDialog.setOverwrite(true);
        String path = fDialog.open();
        if (path == null) {
            return false;
        }
        String id = this.getUsersActivationId();
        if (!returnLicense) {
            this.activate(LicenseChangeRequest.offlineActivationRequest((String)id, (String)path));
        } else {
            LicenseUIActivator.getService().returnLicense(LicenseChangeRequest.offlineReturn((String)id, (String)path));
        }
        MessageDialog.openInformation((Shell)this.getShell(), (String)"Offline Request Generation", (String)("Path to offline license request file: " + path));
        return true;
    }

    private String getUsersActivationId() {
        return this.actIDText.getText().trim();
    }

    private void onlineRequest(final boolean returnLicense) throws LicenseException {
        CLLJob cllJob = new CLLJob(){

            @Override
            public void runCLL() throws LicenseException {
                String id = ActivateWindow.this.getUsersActivationId();
                if (!returnLicense) {
                    LicenseChangeRequest request = LicenseChangeRequest.onlineActivation((String)id);
                    ActivateWindow.this.activate(request);
                } else {
                    LicenseUIActivator.getService().returnLicense(LicenseChangeRequest.onlineReturn((String)id));
                }
            }
        };
        BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)cllJob);
        if (cllJob.getException() != null) {
            throw cllJob.getException();
        }
    }

    private void showError(String title, String message) {
        MessageDialog.openError((Shell)this.getShell(), (String)title, (String)message);
    }

    private void activate(LicenseChangeRequest request) throws LicenseException {
        LicenseUIActivator.getService().activate(request);
        if (!this.activationMode) {
            return;
        }
        if (this.isOfflineMode() && !request.isOfflineResponse()) {
            return;
        }
        if (LicenseUIActivator.getService().fetchLicenseFeature((FNOId)this.feature).getStatus().isEnabled()) {
            return;
        }
        if (MessageDialog.openQuestion((Shell)this.getShell(), (String)"Feature NOT activated.", (String)"Your Software Activation Code is for another feature. Do you want to return it?")) {
            if (this.isOfflineMode()) {
                this.generateOfflineRequest(true);
            } else {
                this.onlineRequest(true);
            }
        }
    }

    private boolean isOfflineMode() {
        return this.checkOffline.getSelection();
    }

    private void processOfflineResponse() {
        String path = new FileDialog(this.getShell(), 4096).open();
        if (path == null) {
            return;
        }
        try {
            this.activate(LicenseChangeRequest.offlineActivationResponse((String)path));
        }
        catch (Exception e) {
            LicenseCoreActivator.log((int)4, (String)e.getMessage());
            this.showError("Offline Activation error", e.getMessage());
        }
        ActivateWindow.super.okPressed();
    }

    private static abstract class CLLJob
    implements Runnable {
        private LicenseException exception = null;

        private CLLJob() {
        }

        @Override
        public void run() {
            try {
                this.runCLL();
            }
            catch (LicenseException ex) {
                this.exception = ex;
            }
        }

        public LicenseException getException() {
            return this.exception;
        }

        public abstract void runCLL() throws LicenseException;
    }
}

