/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.rcp.license.ui;

import com.nxp.s32ds.rcp.license.core.FNOId;
import com.nxp.s32ds.rcp.license.core.LicenseException;
import com.nxp.s32ds.rcp.license.core.LicenseStatus;
import com.nxp.s32ds.rcp.license.ui.ExpectedFeature;
import com.nxp.s32ds.rcp.license.ui.LicenseUIActivator;
import com.nxp.s32ds.rcp.license.ui.LicenseUiUtils;
import com.nxp.s32ds.rcp.license.ui.LicenseWindow;
import com.nxp.s32ds.rcp.license.ui.Messages;
import com.nxp.s32ds.rcp.license.ui.WarningMessageDialog;
import com.nxp.s32ds.rcp.license.ui.internal.ExpectedLicenses;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class StartupVerification
implements IStartup {
    private static final CLLMutext cllMutex = new CLLMutext();
    public static final String JOB_NAME = "Licenses verification";

    public static CLLMutext getCllMutex() {
        return cllMutex;
    }

    public void earlyStartup() {
        Job job = new Job(JOB_NAME){

            protected IStatus run(IProgressMonitor monitor) {
                StartupVerification.this.execute(monitor);
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return family.equals(StartupVerification.JOB_NAME) || super.belongsTo(family);
            }
        };
        job.setRule((ISchedulingRule)cllMutex);
        job.schedule();
    }

    private static boolean isEvaluationEnding(LicenseStatus status) {
        IPreferenceStore store = LicenseUiUtils.getStore();
        String delayType = store.getString("choiceDelayType");
        int days = status.getDaysLeft();
        int numberOfDays = store.getInt("intNumberOfDays");
        int evaluationWarning = store.getDefaultInt("intNumberOfDays");
        if (delayType.equals("custom")) {
            evaluationWarning = numberOfDays;
        }
        return days < evaluationWarning;
    }

    public void execute(IProgressMonitor monitor) {
        ExpectedFeature[] features = ExpectedLicenses.list();
        boolean licenseMissing = false;
        boolean evaluationEnding = false;
        ExpectedFeature[] expectedFeatureArray = features;
        int n = features.length;
        int n2 = 0;
        while (n2 < n) {
            LicenseStatus status;
            ExpectedFeature feature = expectedFeatureArray[n2];
            try {
                status = LicenseUIActivator.getService().fetchLicenseFeature((FNOId)feature).getStatus();
            }
            catch (LicenseException e) {
                status = LicenseStatus.error((Throwable)e);
            }
            if (!status.isEnabled()) {
                licenseMissing = true;
            } else if (status.getType() == LicenseStatus.LicenseStatusType.EVALUATION && StartupVerification.isEvaluationEnding(status)) {
                evaluationEnding = true;
            }
            ++n2;
        }
        if (licenseMissing) {
            StartupVerification.runInUI(new Runnable(){

                @Override
                public void run() {
                    LicenseWindow.block();
                    cllMutex.setWindowNeeded(false);
                }
            });
        } else if (evaluationEnding && LicenseUiUtils.getStore().getBoolean("booleanDisplayWarningWindow")) {
            StartupVerification.displayEndingDialog();
        }
    }

    private static void runInUI(Runnable runnable) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (!workbench.getDisplay().isDisposed()) {
            workbench.getDisplay().syncExec(runnable);
        }
    }

    private static void displayEndingDialog() {
        StartupVerification.runInUI(new Runnable(){

            @Override
            public void run() {
                String[] buttons = new String[]{Messages.getString("StartupVerification_Yes", null), Messages.getString("StartupVerification_No", null)};
                WarningMessageDialog dialog = new WarningMessageDialog("booleanDisplayWarningWindow", PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), Messages.getString("StartupVerification_licensedProd", null), null, Messages.getString("StartupVerification_licenseEnding", null), 3, buttons, 0);
                if (dialog.open() == 0) {
                    LicenseWindow.block();
                }
            }
        });
    }

    public static class CLLMutext
    implements ISchedulingRule {
        private volatile boolean needWindow = true;

        public boolean isConflicting(ISchedulingRule rule) {
            return rule == this;
        }

        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }

        public void setWindowNeeded(boolean need) {
            this.needWindow = need;
        }

        public boolean isNeedWindow() {
            return this.needWindow;
        }
    }
}

