/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cdt.internal.svd.dsf;

import com.nxp.s32ds.cdt.internal.svd.dsf.SvdDsfRegistersCompositeCache;
import com.nxp.s32ds.cdt.internal.svd.dsf.SvdDsfRegistersCompositeCacheBuilder;
import com.nxp.s32ds.cdt.internal.svd.dsf.memory.SvdDsfMemoryRegistersCompositeCache;
import com.nxp.s32ds.cdt.internal.svd.dsf.system.SvdDsfSystemRegistersCompositeCache;
import com.nxp.s32ds.cdt.svd.model.SvdRegister;
import com.nxp.s32ds.cdt.svd.model.watch.SvdWatchModel;
import com.nxp.s32ds.cdt.svd.parser.model.AccessType;
import com.nxp.s32ds.cdt.svd.utils.SvdTrace;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.service.DsfSession;

public class SvdDsfRegistersSessionCache {
    private static final DummyCache DUMMY_CACHE = new DummyCache();
    private static final SvdDsfRegistersCompositeCacheBuilder[] BUILDERS = new SvdDsfRegistersCompositeCacheBuilder[]{new SvdDsfRegistersCompositeCacheBuilder(SvdDsfMemoryRegistersCompositeCache.SUPORTED_TYPES, (s, m) -> SvdDsfMemoryRegistersCompositeCache.build(s, m)), new SvdDsfRegistersCompositeCacheBuilder(SvdDsfSystemRegistersCompositeCache.SUPORTED_TYPES, (s, m) -> SvdDsfSystemRegistersCompositeCache.build(s, m))};
    private final Set<IAddress> wasWrittenSet = new HashSet<IAddress>();
    private final SvdDsfRegistersCompositeCache cache;

    public SvdDsfRegistersSessionCache(DsfSession session, SvdWatchModel model, SvdDsfRegistersCompositeCacheBuilder ... builders) {
        this.cache = Arrays.stream(builders).filter(b -> b.getSupportedTypes().contains(model.getType())).findFirst().map(b -> b.build(session, model)).orElse(DUMMY_CACHE);
    }

    public SvdDsfRegistersSessionCache(DsfSession session, SvdWatchModel model) {
        this(session, model, BUILDERS);
    }

    public boolean canWrite(SvdRegister r) {
        AccessType accessType = r.getAccessType();
        switch (accessType) {
            case READ_ONLY: {
                return false;
            }
            case WRITE_ONCE: 
            case READ_WRITE_ONCE: {
                return !this.wasWrittenSet.contains(r.getAddress());
            }
        }
        return true;
    }

    public static boolean canRead(SvdRegister r) {
        AccessType accessType = r.getAccessType();
        switch (accessType) {
            case WRITE_ONLY: 
            case WRITE_ONCE: {
                return false;
            }
        }
        return true;
    }

    public void setValue(SvdRegister r, BigInteger value) {
        SvdTrace.trace("set value for register {}:{} ", r.getName(), r.getAddress());
        if (!this.canWrite(r)) {
            return;
        }
        AccessType accessType = r.getAccessType();
        switch (accessType) {
            case WRITE_ONCE: 
            case READ_WRITE_ONCE: {
                this.wasWrittenSet.add(r.getAddress());
                break;
            }
        }
        this.cache.setValue(r, value);
    }

    public BigInteger getValue(SvdRegister r) {
        SvdTrace.trace("get value for register {}:{} ", r.getName(), r.getAddress());
        switch (r.getAccessType()) {
            case WRITE_ONLY: 
            case WRITE_ONCE: {
                return null;
            }
        }
        return this.cache.getValue(r);
    }

    public BigInteger getPrevValue(SvdRegister r) {
        switch (r.getAccessType()) {
            case WRITE_ONLY: 
            case WRITE_ONCE: {
                return null;
            }
        }
        return this.cache.getPrevValue(r);
    }

    public void removeRegisters(Collection<SvdRegister> registers) {
        this.cache.removeRegisters(registers);
    }

    public void addRegisters(Collection<SvdRegister> registers) {
        registers = registers.stream().filter(SvdDsfRegistersSessionCache::canRead).collect(Collectors.toList());
        this.cache.addRegisters(registers);
    }

    public void updateValues() {
        SvdTrace.trace("update values", new Object[0]);
        this.cache.update();
    }

    public void initialize(IDMContext idmContext) {
        this.cache.initialize(idmContext);
    }

    public void dispose() {
        this.cache.dispose();
    }

    private static class DummyCache
    implements SvdDsfRegistersCompositeCache {
        private DummyCache() {
        }

        @Override
        public void initialize(IDMContext idmContext) {
        }

        @Override
        public void setValue(SvdRegister r, BigInteger value) {
        }

        @Override
        public BigInteger getValue(SvdRegister r) {
            return null;
        }

        @Override
        public void update() {
        }

        @Override
        public BigInteger getPrevValue(SvdRegister r) {
            return null;
        }

        @Override
        public void addRegisters(Collection<SvdRegister> registers) {
        }

        @Override
        public void removeRegisters(Collection<SvdRegister> registers) {
        }

        @Override
        public void dispose() {
        }
    }
}

