/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cdt.internal.svd.dsf.system;

import com.nxp.s32ds.cdt.internal.svd.dsf.cmd.SvdDsfCmdRequestor;
import com.nxp.s32ds.cdt.svd.model.SvdRegister;
import com.nxp.s32ds.cdt.svd.utils.SvdNumberToStrings;
import com.nxp.s32ds.cdt.svd.utils.SvdTrace;
import com.nxp.s32ds.ext.cdt.dsf.DsfConversions;
import com.nxp.s32ds.ext.cdt.dsf.DsfRequest;
import com.nxp.s32ds.ext.cdt.dsf.DsfResponse;
import java.math.BigInteger;
import org.eclipse.cdt.dsf.mi.service.command.output.MIConsoleStreamOutput;

public class SvdDsfSystemRegistersRequestor
extends SvdDsfCmdRequestor<SvdRegister, BigInteger, BigInteger> {
    private static final String READ_CMD = "reg_read %s %d";
    private static final String WRITE_CMD = "reg_write %s %s";
    private static SvdDsfSystemRegistersRequestor INSTANCE = new SvdDsfSystemRegistersRequestor();

    private SvdDsfSystemRegistersRequestor() {
    }

    public static SvdDsfSystemRegistersRequestor getInstance() {
        return INSTANCE;
    }

    protected String getReadCommand(DsfRequest<SvdRegister, ?> request) {
        String command = String.format(READ_CMD, SvdNumberToStrings.toHexString(((SvdRegister)request.base).getAddress(), 32), ((SvdRegister)request.base).getBitLength() / 8);
        SvdTrace.trace("getReadCommand()=[{}]", command);
        return command;
    }

    protected String getWriteCommand(DsfRequest<SvdRegister, BigInteger> request) {
        String command = String.format(WRITE_CMD, SvdNumberToStrings.toHexString(((SvdRegister)request.base).getAddress(), 32), request.value);
        SvdTrace.trace("getWriteCommand()=[{}({})]", command, SvdNumberToStrings.toHexString((BigInteger)request.value, ((SvdRegister)request.base).getBitLength()));
        return command;
    }

    protected DsfResponse<SvdRegister, BigInteger> createResponse(DsfRequest<SvdRegister, ?> request, MIConsoleStreamOutput output) {
        String response = DsfConversions.cleanUp((String)output.getString());
        SvdTrace.trace("createResponse()=[{}({})]", response, SvdTrace.lazy(() -> SvdNumberToStrings.toHexString(new BigInteger(response), ((SvdRegister)dsfRequest.base).getBitLength())));
        return new DsfResponse(request, (Object)new BigInteger(response));
    }
}

