/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cdt.internal.svd.parser;

import com.nxp.s32ds.cdt.internal.svd.Messages;
import com.nxp.s32ds.cdt.internal.svd.SvdActivator;
import com.nxp.s32ds.cdt.svd.parser.SvdDeviceDescriptor;
import com.nxp.s32ds.cdt.svd.parser.SvdParser;
import com.nxp.s32ds.cdt.svd.parser.model.Device;
import com.nxp.s32ds.cle.ide.debugger.svd.SvdSource;
import com.nxp.s32ds.ext.orbit.jaxb.OrbitJAXBContextFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;
import org.xml.sax.SAXException;

public class SvdParserImpl
extends SvdParser {
    private static final String SCHEMA_PATH = "resources/schema/cmsis-svd.xsd";
    private final Unmarshaller unmarshaller;

    public SvdParserImpl() throws JAXBException, SAXException, IOException {
        JAXBContext context = OrbitJAXBContextFactory.createContext(Device.class);
        this.unmarshaller = context.createUnmarshaller();
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        URL schemaUrl = SvdActivator.getInstance().getPathUrl(SCHEMA_PATH);
        Throwable throwable = null;
        Object var5_6 = null;
        try (InputStream stream = schemaUrl.openStream();){
            Schema schema = schemaFactory.newSchema(new StreamSource(stream));
            this.unmarshaller.setSchema(schema);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public SvdDeviceDescriptor parse(SvdSource source) throws CoreException {
        String uid = source.getUID();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (InputStream stream = source.getInputStream();){
                return new SvdDeviceDescriptor(uid, this.parse(new StreamSource(stream)));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | JAXBException e) {
            Throwable linkedException;
            Throwable cause = e;
            if (e instanceof JAXBException && (linkedException = ((JAXBException)e).getLinkedException()) != null) {
                cause = linkedException;
            }
            throw new CoreException(SvdActivator.getInstance().createError(NLS.bind((String)Messages.SvdParser_cannot_parse_file, (Object)uid), cause));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Device parse(Source source) throws JAXBException {
        Unmarshaller unmarshaller = this.unmarshaller;
        synchronized (unmarshaller) {
            return (Device)this.unmarshaller.unmarshal(source, Device.class).getValue();
        }
    }
}

