/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cdt.svd.dsf;

import com.nxp.s32ds.cdt.internal.svd.dsf.SvdDsfRegistersSessionCache;
import com.nxp.s32ds.cdt.internal.svd.dsf.SvdDsfSessionModelsAndRegistersCache;
import com.nxp.s32ds.cdt.svd.dsf.SvdDsfSessionCacheListener;
import com.nxp.s32ds.cdt.svd.model.SvdRegister;
import com.nxp.s32ds.cdt.svd.model.watch.SvdWatchModel;
import com.nxp.s32ds.cdt.svd.model.watch.SvdWatchModels;
import com.nxp.s32ds.cdt.svd.utils.SvdTrace;
import com.nxp.s32ds.ext.cdt.dsf.DsfSessionInactiveException;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Map;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.ListenerList;

public class SvdDsfSessionCacheManager {
    public static final Object UPDATE_JOB_FAMILY = new Object();
    private static final SvdDsfSessionCacheManager INSTANCE = new SvdDsfSessionCacheManager();
    private final ListenerList<SvdDsfSessionCacheListener> listeners = new ListenerList();
    private final SvdDsfSessionModelsAndRegistersCache cache = new SvdDsfSessionModelsAndRegistersCache();

    private SvdDsfRegistersSessionCache computeIfAbsent(DsfSession session, IDMContext idmContext, SvdWatchModel model) throws DsfSessionInactiveException {
        return this.cache.computeIfAbsent(session, model, (SvdDsfRegistersSessionCache p) -> p.initialize(idmContext));
    }

    public static SvdDsfSessionCacheManager getInstance() {
        return INSTANCE;
    }

    public void addCacheListener(SvdDsfSessionCacheListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeCacheListener(SvdDsfSessionCacheListener listener) {
        this.listeners.remove((Object)listener);
    }

    public void fireCacheChanged(DsfSession session) {
        SvdDsfSessionCacheListener.CacheEvent event = new SvdDsfSessionCacheListener.CacheEvent(session, SvdDsfSessionCacheListener.CacheEventType.CACHE_CHANGED);
        for (SvdDsfSessionCacheListener listener : this.listeners) {
            listener.cacheChanged(event);
        }
    }

    public void fireUpdateStart(DsfSession session) {
        SvdDsfSessionCacheListener.CacheEvent event = new SvdDsfSessionCacheListener.CacheEvent(session, SvdDsfSessionCacheListener.CacheEventType.UPDATE_START);
        for (SvdDsfSessionCacheListener listener : this.listeners) {
            listener.cacheChanged(event);
        }
    }

    public void fireUpdateEnd(DsfSession session) {
        SvdDsfSessionCacheListener.CacheEvent event = new SvdDsfSessionCacheListener.CacheEvent(session, SvdDsfSessionCacheListener.CacheEventType.UPDATE_END);
        for (SvdDsfSessionCacheListener listener : this.listeners) {
            listener.cacheChanged(event);
        }
    }

    public boolean canWrite(DsfSession session, IDMContext idmContext, SvdRegister r) {
        try {
            return this.computeIfAbsent(session, idmContext, SvdWatchModels.getModel(r)).canWrite(r);
        }
        catch (DsfSessionInactiveException dsfSessionInactiveException) {
            return false;
        }
    }

    public void setValue(DsfSession session, IDMContext idmContext, SvdRegister r, BigInteger value) {
        try {
            this.computeIfAbsent(session, idmContext, SvdWatchModels.getModel(r)).setValue(r, value);
        }
        catch (DsfSessionInactiveException dsfSessionInactiveException) {}
    }

    public BigInteger getValue(DsfSession session, IDMContext idmContext, SvdRegister r) {
        SvdTrace.trace("get value for session({}) {}:{}", session.getId(), r.getName(), r.getAddress());
        try {
            return this.computeIfAbsent(session, idmContext, SvdWatchModels.getModel(r)).getValue(r);
        }
        catch (DsfSessionInactiveException dsfSessionInactiveException) {
            return null;
        }
    }

    public BigInteger getPrevValue(DsfSession session, IDMContext idmContext, SvdRegister r) {
        try {
            return this.computeIfAbsent(session, idmContext, SvdWatchModels.getModel(r)).getPrevValue(r);
        }
        catch (DsfSessionInactiveException dsfSessionInactiveException) {
            return null;
        }
    }

    public void updateValues(DsfSession session, IDMContext idmContext) {
        SvdTrace.trace("updateValues session({})", session);
        Map map = (Map)this.cache.get(session);
        if (map == null) {
            return;
        }
        map.values().stream().forEach(v -> v.updateValues());
    }

    public void addRegisters(DsfSession session, IDMContext idmContext, Collection<SvdRegister> registers) {
        SvdWatchModels.forEachModel(registers, (m, r) -> {
            try {
                this.computeIfAbsent(session, idmContext, (SvdWatchModel)m).addRegisters((Collection<SvdRegister>)r);
            }
            catch (DsfSessionInactiveException dsfSessionInactiveException) {}
        });
    }

    public void removeRegisters(DsfSession session, IDMContext idmContext, Collection<SvdRegister> registers) {
        SvdWatchModels.forEachModel(registers, (m, r) -> {
            try {
                this.computeIfAbsent(session, idmContext, (SvdWatchModel)m).removeRegisters((Collection<SvdRegister>)r);
            }
            catch (DsfSessionInactiveException dsfSessionInactiveException) {}
        });
    }
}

