/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cdt.svd.interchange.registers;

import com.nxp.s32ds.cdt.internal.svd.Messages;
import com.nxp.s32ds.cdt.internal.svd.SvdActivator;
import com.nxp.s32ds.cdt.svd.interchange.registers.model.ObjectFactory;
import com.nxp.s32ds.cdt.svd.interchange.registers.model.Register;
import com.nxp.s32ds.cdt.svd.interchange.registers.model.Registers;
import com.nxp.s32ds.cdt.svd.model.SvdRegister;
import com.nxp.s32ds.cdt.svd.utils.SvdRegisters;
import com.nxp.s32ds.ext.orbit.jaxb.OrbitJAXBContextFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;
import org.xml.sax.SAXException;

public class SvdRegistersInterchange {
    private static final String SCHEMA_PATH = "resources/schema/registers-interchange.xsd";
    private static final ObjectFactory OBJECT_FACTORY = new ObjectFactory();

    private SvdRegistersInterchange() {
    }

    public static Register createRegister() {
        return OBJECT_FACTORY.createRegister();
    }

    public static Registers unmarshal(Reader reader) throws CoreException {
        if (reader == null) {
            throw new IllegalArgumentException("Argument reader is null");
        }
        try {
            JAXBContext context = OrbitJAXBContextFactory.createContext(Registers.class);
            Unmarshaller unmarshaller = context.createUnmarshaller();
            unmarshaller.setSchema(SvdRegistersInterchange.getSchema());
            StreamSource streamSource = new StreamSource(reader);
            return (Registers)unmarshaller.unmarshal((Source)streamSource, Registers.class).getValue();
        }
        catch (Exception e) {
            Throwable throwable = e;
            if (e instanceof JAXBException) {
                throwable = ((JAXBException)((Object)e)).getLinkedException();
            }
            throw new CoreException(SvdActivator.getInstance().createError(NLS.bind((String)Messages.SvdRegistersInterchange_cannot_unmarshal_registers_0, (Object)throwable.getMessage()), throwable));
        }
    }

    public static void marshal(List<Register> registersList, Writer writer) throws CoreException {
        if (registersList == null) {
            throw new IllegalArgumentException("Argument registersList is null");
        }
        if (writer == null) {
            throw new IllegalArgumentException("Argument writer is null");
        }
        try {
            JAXBContext context = OrbitJAXBContextFactory.createContext(Registers.class);
            Marshaller marshaller = context.createMarshaller();
            marshaller.setSchema(SvdRegistersInterchange.getSchema());
            Registers registers = OBJECT_FACTORY.createRegisters();
            registers.getRegister().addAll(registersList);
            JAXBElement<Registers> jaxbObject = OBJECT_FACTORY.createRegisters(registers);
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.marshal(jaxbObject, writer);
        }
        catch (Exception e) {
            Throwable throwable = e;
            if (e instanceof JAXBException) {
                throwable = ((JAXBException)((Object)e)).getLinkedException();
            }
            throw new CoreException(SvdActivator.getInstance().createError(NLS.bind((String)Messages.SvdRegistersInterchange_cannot_marshal_registers_0, (Object)throwable.getMessage()), throwable));
        }
    }

    private static Schema getSchema() throws SAXException, IOException {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        URL schemaUrl = SvdActivator.getInstance().getPathUrl(SCHEMA_PATH);
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream openStream = schemaUrl.openStream();){
            return schemaFactory.newSchema(new StreamSource(openStream));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static List<Register> convert(List<SvdRegister> list, Function<SvdRegister, String> valueFunction) {
        ArrayList<Register> result = new ArrayList<Register>();
        for (SvdRegister svdRegister : list) {
            String value;
            Register register = OBJECT_FACTORY.createRegister();
            result.add(register);
            register.setPath(SvdRegisters.getPathToPeripheral(svdRegister));
            if (valueFunction == null || (value = valueFunction.apply(svdRegister)) == null) continue;
            register.setValue(value);
        }
        return result;
    }
}

