/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cdt.svd.job;

import java.util.List;
import java.util.function.Consumer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;

public class SvdQueueJob<T>
extends Job {
    private final List<T> requests;
    private final Consumer<T> consumer;

    public SvdQueueJob(String name, List<T> requests, Consumer<T> consumer) {
        super(name);
        this.requests = requests;
        this.consumer = consumer;
    }

    protected IStatus run(IProgressMonitor monitor) {
        int size = this.requests.size();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)this.getName(), (int)size);
        int i = 0;
        while (i < size) {
            if (subMonitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            subMonitor.setTaskName(String.valueOf(this.getName()) + " " + this.requests.get(i).toString());
            this.consumer.accept(this.requests.get(i));
            subMonitor.worked(1);
            ++i;
        }
        return Status.OK_STATUS;
    }
}

