/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cdt.svd.model.watch;

import com.nxp.s32ds.cdt.internal.svd.SvdActivator;
import com.nxp.s32ds.cdt.internal.svd.dsf.watch.SvdSessionWatchModelCache;
import com.nxp.s32ds.cdt.svd.model.SvdAdresableContainer;
import com.nxp.s32ds.cdt.svd.model.SvdChildElement;
import com.nxp.s32ds.cdt.svd.model.SvdCluster;
import com.nxp.s32ds.cdt.svd.model.SvdContainer;
import com.nxp.s32ds.cdt.svd.model.SvdDeviceModel;
import com.nxp.s32ds.cdt.svd.model.SvdDeviceModels;
import com.nxp.s32ds.cdt.svd.model.SvdModelBase;
import com.nxp.s32ds.cdt.svd.model.SvdPeripheral;
import com.nxp.s32ds.cdt.svd.model.SvdPeripheralGroup;
import com.nxp.s32ds.cdt.svd.model.SvdRegister;
import com.nxp.s32ds.cdt.svd.model.watch.SvdWatchContext;
import com.nxp.s32ds.cdt.svd.model.watch.SvdWatchModel;
import com.nxp.s32ds.cdt.svd.model.watch.SvdWatchModelChangeEvent;
import com.nxp.s32ds.cdt.svd.model.watch.SvdWatchModelChangeListener;
import com.nxp.s32ds.cdt.svd.model.watch.SvdWatchModelLoader;
import com.nxp.s32ds.cdt.svd.model.watch.SvdWatchModels;
import com.nxp.s32ds.cle.ide.debugger.svd.SvdSourceType;
import com.nxp.s32ds.ext.cdt.dsf.DsfSessionInactiveException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.osgi.util.NLS;

public class SvdWatchModelCacheManager {
    private final ListenerList<SvdWatchModelChangeListener> listeners = new ListenerList(1);
    private final SvdSessionWatchModelCache cache = new SvdSessionWatchModelCache(mb -> this.createWatchModel(loader, (SvdModelBase)mb));

    public SvdWatchModelCacheManager(SvdWatchModelLoader loader) {
    }

    public void addListener(SvdWatchModelChangeListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeListener(SvdWatchModelChangeListener listener) {
        this.listeners.remove((Object)listener);
    }

    public void fireModelChanged(SvdWatchModelChangeEvent event) {
        for (SvdWatchModelChangeListener listener : this.listeners) {
            try {
                listener.modelChanged(event);
            }
            catch (Exception e) {
                SvdActivator.getInstance().logError("Error during listener call.", e);
            }
        }
    }

    public SvdWatchModel computeIfAbsent(DsfSession session, SvdContainer element) throws DsfSessionInactiveException {
        return this.cache.computeIfAbsent(session, SvdDeviceModels.getModel(element));
    }

    public void addToWatch(DsfSession session, Collection<SvdRegister> registers) {
        if (registers.isEmpty()) {
            return;
        }
        SvdDeviceModels.forEachModel(registers, (m, r) -> {
            try {
                this.addToWatch(this.cache.computeIfAbsent(session, (SvdDeviceModel)m), (Collection<SvdRegister>)r);
            }
            catch (DsfSessionInactiveException dsfSessionInactiveException) {}
        });
    }

    public void addToWatch(SvdWatchModel model, Collection<SvdRegister> registers) {
        Collection<SvdChildElement> results = SvdWatchModelCacheManager.addToWatchModel(model, registers);
        if (results.isEmpty()) {
            return;
        }
        this.fireModelChanged(new SvdWatchModelChangeEvent(model, 1, results));
    }

    public static Collection<SvdChildElement> addToWatchModel(SvdWatchModel model, Collection<SvdRegister> registers) {
        if (registers.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet<SvdChildElement> results = new LinkedHashSet<SvdChildElement>();
        for (SvdRegister register : registers) {
            if (model.getByPath(register.getPath()) != null) continue;
            results.add(SvdWatchModelCacheManager.getOrCreate(model, register));
        }
        return results;
    }

    public void removeFromWatch(DsfSession session, Collection<SvdRegister> registers) {
        if (registers == null) {
            throw new IllegalArgumentException("Argument registers is null.");
        }
        if (registers.isEmpty()) {
            return;
        }
        SvdWatchModels.forEachModel(registers, (m, r) -> this.removeFromWatch((SvdWatchModel)m, (Collection<SvdRegister>)r));
    }

    private void removeFromWatch(SvdWatchModel model, Collection<SvdRegister> registers) {
        LinkedHashSet<SvdChildElement> fullRemoveSet = new LinkedHashSet<SvdChildElement>();
        for (SvdRegister register : registers) {
            SvdChildElement childElement = model.getByPath(register.getPath());
            if (childElement == null) continue;
            SvdWatchModelCacheManager.collectRemoveHierarchically(fullRemoveSet, childElement);
        }
        if (fullRemoveSet.size() == 0) {
            return;
        }
        this.fireModelChanged(new SvdWatchModelChangeEvent(model, 2, fullRemoveSet));
        for (SvdChildElement toRemove : this.collectTopElements(fullRemoveSet)) {
            toRemove.getParent().remove(toRemove);
        }
        this.fireModelChanged(new SvdWatchModelChangeEvent(model, 3, fullRemoveSet));
    }

    private Collection<SvdChildElement> collectTopElements(Set<SvdChildElement> list) {
        return list.stream().map(e -> this.getTopParent(list, (SvdChildElement)e)).collect(Collectors.toSet());
    }

    private SvdChildElement getTopParent(Set<SvdChildElement> list, SvdChildElement e) {
        SvdContainer parent = e.getParent();
        if (list.contains(parent)) {
            return this.getTopParent(list, parent);
        }
        return e;
    }

    private static void collectRemoveHierarchically(Set<SvdChildElement> list, SvdChildElement element) {
        list.add(element);
        SvdContainer parent = element.getParent();
        if (parent instanceof SvdModelBase) {
            return;
        }
        long count = parent.getChildren().stream().filter(c -> !list.contains(c)).count();
        if (count == 0L) {
            SvdWatchModelCacheManager.collectRemoveHierarchically(list, parent);
        }
    }

    public static SvdContainer getOrCreate(SvdWatchModel model, SvdChildElement element) {
        if (element instanceof SvdModelBase) {
            return model;
        }
        SvdChildElement childElement = model.getByPath(element.getPath());
        if (childElement != null) {
            if (childElement instanceof SvdContainer) {
                return (SvdContainer)childElement;
            }
            return null;
        }
        SvdContainer parent = SvdWatchModelCacheManager.getOrCreate(model, element.getParent());
        if (parent == null) {
            SvdActivator.getInstance().createError(NLS.bind((String)"Cannot get parent: {0}", (Object)element.getParent().getPath()));
            return null;
        }
        SvdContainer copy = SvdWatchModelCacheManager.createCopy(parent, element);
        if (copy != null) {
            parent.add(copy);
        } else {
            SvdActivator.getInstance().createError(NLS.bind((String)"Cannot get create copy : {0}", (Object)element.getPath()));
        }
        return copy;
    }

    public static SvdWatchModelLoader.SvdWatchModelState collectModelState(SvdWatchModel model) {
        SvdWatchModelLoader.SvdWatchModelState modelState = new SvdWatchModelLoader.SvdWatchModelState();
        model.flattened().filter(e -> e instanceof SvdRegister).map(e -> (SvdRegister)e).forEach(r -> {
            String path = r.getPath();
            modelState.getPaths().add(path);
            SvdWatchContext existingContext = model.getContextManager().getContext((SvdRegister)r);
            SvdWatchContext defaultContext = SvdWatchContext.builder().build((SvdRegister)r);
            if (!defaultContext.equals(existingContext)) {
                modelState.getContexts().put(path, existingContext);
            }
        });
        return modelState;
    }

    private static SvdContainer createCopy(SvdContainer parent, SvdChildElement container) {
        if (container instanceof SvdPeripheralGroup) {
            return new SvdPeripheralGroup((SvdModelBase)parent, (SvdPeripheralGroup)container);
        }
        if (container instanceof SvdPeripheral) {
            return new SvdPeripheral((SvdPeripheralGroup)parent, (SvdPeripheral)container);
        }
        if (container instanceof SvdCluster) {
            return new SvdCluster((SvdAdresableContainer)parent, (SvdCluster)container);
        }
        if (container instanceof SvdRegister) {
            SvdRegister register = new SvdRegister((SvdAdresableContainer)parent, (SvdRegister)container);
            register.fillFrom((SvdRegister)container);
            return register;
        }
        return null;
    }

    private SvdWatchModel createWatchModel(SvdWatchModelLoader loader, SvdModelBase source) {
        String uid = source.getUID();
        SvdSourceType type = source.getType();
        SvdWatchModel watchModel = new SvdWatchModel(this, uid, type);
        SvdWatchModelLoader.SvdWatchModelState modelState = loader.load(uid);
        if (modelState == null) {
            return watchModel;
        }
        List<String> paths = modelState.getPaths();
        if (paths != null) {
            for (String path : paths) {
                SvdChildElement element = source.getByPath(path);
                if (element == null) continue;
                SvdWatchModelCacheManager.getOrCreate(watchModel, element);
            }
        }
        Map<String, SvdWatchContext> contexts = modelState.getContexts();
        contexts.entrySet().stream().forEach(e -> {
            SvdChildElement element = watchModel.getByPath((String)e.getKey());
            if (element instanceof SvdRegister) {
                SvdRegister register = (SvdRegister)element;
                watchModel.getContextManager().setContext(register, (SvdWatchContext)e.getValue());
            }
        });
        return watchModel;
    }
}

