/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cdt.svd.parser;

import com.nxp.s32ds.cdt.internal.svd.parser.SvdParserUtils;
import com.nxp.s32ds.cdt.svd.model.SvdAdresableContainer;
import com.nxp.s32ds.cdt.svd.model.SvdCluster;
import com.nxp.s32ds.cdt.svd.model.SvdDeviceModel;
import com.nxp.s32ds.cdt.svd.model.SvdEnumeratedValue;
import com.nxp.s32ds.cdt.svd.model.SvdField;
import com.nxp.s32ds.cdt.svd.model.SvdPeripheral;
import com.nxp.s32ds.cdt.svd.model.SvdPeripheralGroup;
import com.nxp.s32ds.cdt.svd.model.SvdRegister;
import com.nxp.s32ds.cdt.svd.parser.SvdDeviceDescriptor;
import com.nxp.s32ds.cdt.svd.parser.SvdTreeBuilder;
import com.nxp.s32ds.cdt.svd.parser.model.AccessType;
import com.nxp.s32ds.cdt.svd.parser.model.ClusterType;
import com.nxp.s32ds.cdt.svd.parser.model.EnumUsageType;
import com.nxp.s32ds.cdt.svd.parser.model.EnumeratedValueType;
import com.nxp.s32ds.cdt.svd.parser.model.FieldType;
import com.nxp.s32ds.cdt.svd.parser.model.PeripheralType;
import com.nxp.s32ds.cdt.svd.parser.model.RegisterType;
import com.nxp.s32ds.cle.ide.debugger.svd.SvdSourceType;
import java.math.BigInteger;
import java.util.Optional;
import java.util.function.Function;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.utils.Addr64;

public class SvdModelBuilder
implements SvdTreeBuilder {
    private final SvdDeviceModel svdModel;

    public SvdDeviceModel getSvdModel() {
        return this.svdModel;
    }

    public SvdModelBuilder(SvdDeviceDescriptor deviceDescriptor, SvdSourceType type) {
        this.svdModel = new SvdDeviceModel(deviceDescriptor, type);
    }

    @Override
    public SvdPeripheral peripheral(PeripheralType peripheral, PeripheralType derivedFrom) {
        String groupName = SvdModelBuilder.getGroupName(SvdModelBuilder.get(peripheral, derivedFrom, PeripheralType::getGroupName));
        SvdPeripheralGroup group = this.svdModel.getOrCreate(groupName);
        String name = SvdModelBuilder.get(peripheral, derivedFrom, PeripheralType::getName);
        String description = SvdParserUtils.removeExtraSpaces(SvdModelBuilder.get(peripheral, derivedFrom, PeripheralType::getDescription));
        SvdPeripheral svdPeripheral = new SvdPeripheral(group, name, description, (IAddress)new Addr64(peripheral.getBaseAddress().getValue()));
        group.add(svdPeripheral);
        return svdPeripheral;
    }

    @Override
    public SvdRegister register(SvdAdresableContainer parent, RegisterType register, String name, BigInteger offset) {
        String description = SvdParserUtils.removeExtraSpaces(register.getDescription());
        IAddress address = parent.getAddress().add(register.getAddressOffset().getValue()).add(offset);
        BigInteger resetValue = register.getResetValue() == null ? null : register.getResetValue().getValue();
        AccessType accessType = Optional.ofNullable(register.getAccess()).orElse(AccessType.READ_ONLY);
        int size = (int)SvdParserUtils.getLongOrDefault(register.getSize(), 32L);
        SvdRegister svdRegister = new SvdRegister(parent, name, description, address, resetValue, accessType, size, register.getReadAction() != null);
        parent.add(svdRegister);
        return svdRegister;
    }

    @Override
    public SvdCluster cluster(SvdAdresableContainer parent, ClusterType cluster, String name, BigInteger offset) {
        String description = SvdParserUtils.removeExtraSpaces(cluster.getDescription());
        IAddress address = parent.getAddress().add(cluster.getAddressOffset().getValue()).add(offset);
        SvdCluster svdCluster = new SvdCluster(parent, name, description, address);
        parent.add(svdCluster);
        return svdCluster;
    }

    @Override
    public SvdField field(SvdRegister parent, FieldType field, int fbitoffset, int fbitlength) {
        String name = field.getName();
        String description = SvdParserUtils.removeExtraSpaces(field.getDescription());
        AccessType accessType = Optional.ofNullable(field.getAccess()).orElse(AccessType.READ_ONLY);
        SvdField svdField = new SvdField(parent, name, description, fbitoffset, fbitlength, accessType, field.getReadAction() != null);
        parent.add(svdField);
        return svdField;
    }

    @Override
    public SvdEnumeratedValue enumeratedValue(SvdField svdField, EnumeratedValueType enumeratedValueType, EnumUsageType enumUsageType) {
        SvdEnumeratedValue svdEnumeratedValue = new SvdEnumeratedValue(svdField, enumeratedValueType, Optional.ofNullable(enumUsageType).orElse(EnumUsageType.READ_WRITE));
        svdField.add(svdEnumeratedValue);
        return svdEnumeratedValue;
    }

    private static <T, R> R get(T original, T derivedFrom, Function<T, R> function) {
        R result = function.apply(original);
        if (result != null) {
            return result;
        }
        if (derivedFrom == null) {
            return null;
        }
        return function.apply(derivedFrom);
    }

    private static String getGroupName(String groupName) {
        if (groupName == null || groupName.trim().isEmpty()) {
            return null;
        }
        return groupName.trim();
    }
}

