/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cdt.svd.parser.model;

import com.nxp.s32ds.cdt.internal.svd.Messages;
import com.nxp.s32ds.cdt.svd.parser.model.ParseRuntimeException;
import com.nxp.s32ds.cdt.svd.parser.model.Scale;
import java.math.BigInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osgi.util.NLS;

public class ScaledNonNegativeInteger {
    private static final String BINARY_PREFIX = "#";
    private static final String HEX_PREFIX = "0x";
    private static final ThreadLocal<Matcher> THREAD_LOCAL = ThreadLocal.withInitial(() -> Pattern.compile("[+]?(0x|0X|#)?([0-9a-fA-F]+)([kmgtKMGT]?)").matcher(""));
    private final BigInteger value;

    public ScaledNonNegativeInteger(long value) {
        this.value = BigInteger.valueOf(value);
    }

    public ScaledNonNegativeInteger(BigInteger value) {
        this.value = value;
    }

    public BigInteger getValue() {
        return this.value;
    }

    public static ScaledNonNegativeInteger parseScaledNonNegativeInteger(String value) {
        if (value == null || value.trim().isEmpty()) {
            throw new ParseRuntimeException(NLS.bind((String)Messages._0_value_should_not_be_empty, (Object)ScaledNonNegativeInteger.class.getSimpleName()));
        }
        Matcher matcher = THREAD_LOCAL.get();
        matcher.reset(value.trim().toLowerCase());
        if (!matcher.matches()) {
            throw new ParseRuntimeException(NLS.bind((String)Messages._0_value_should_match_1, (Object)ScaledNonNegativeInteger.class.getSimpleName(), (Object)"[+]?(0x|0X|\\#)?[0-9a-fA-F]+[kmgtKMGT]?"));
        }
        int radix = ScaledNonNegativeInteger.getRadix(matcher.group(1));
        String number = matcher.group(2);
        Scale scale = ScaledNonNegativeInteger.getScale(matcher.group(3));
        try {
            BigInteger bigInteger = new BigInteger(number, radix);
            if (scale != Scale.ONE) {
                bigInteger = bigInteger.multiply(BigInteger.valueOf(scale.getMagnifier()));
            }
            return new ScaledNonNegativeInteger(bigInteger);
        }
        catch (NumberFormatException e) {
            throw new ParseRuntimeException(NLS.bind((String)Messages._error_of_parsing_0_value_with_radix_1, (Object)value, (Object)radix), e);
        }
    }

    private static int getRadix(String radix) {
        if (HEX_PREFIX.equals(radix)) {
            return 16;
        }
        if (BINARY_PREFIX.equals(radix)) {
            return 2;
        }
        return 10;
    }

    public String printScaledNonNegativeInteger() {
        return HEX_PREFIX + this.value.toString(16);
    }

    private static Scale getScale(String value) {
        switch (value) {
            case "k": {
                return Scale.KILO;
            }
            case "m": {
                return Scale.MEGA;
            }
            case "g": {
                return Scale.GIGA;
            }
            case "t": {
                return Scale.TERA;
            }
        }
        return Scale.ONE;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ScaledNonNegativeInteger other = (ScaledNonNegativeInteger)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public String toString() {
        return this.printScaledNonNegativeInteger();
    }
}

