/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cdt.svd.utils;

import com.nxp.s32ds.cdt.svd.model.SvdEnumeratedValue;
import com.nxp.s32ds.cdt.svd.model.SvdField;
import com.nxp.s32ds.cdt.svd.parser.model.EnumeratedValueDataType;
import java.math.BigInteger;
import java.util.List;
import java.util.stream.Collectors;

public class SvdFields {
    public static final BigInteger ALL_BITS_ON_8 = SvdFields.allBits(8);
    public static final BigInteger ALL_BITS_ON_16 = SvdFields.allBits(16);
    public static final BigInteger ALL_BITS_ON_32 = SvdFields.allBits(32);
    public static final BigInteger ALL_BITS_ON_64 = SvdFields.allBits(64);
    public static final BigInteger ALL_BITS_ON_128 = SvdFields.allBits(128);

    public static List<SvdEnumeratedValue> matchEnumeratedValues(SvdField field, List<SvdEnumeratedValue> values, BigInteger fieldValue) {
        return values.stream().filter(v -> SvdFields.matchEnumeratedValue(field, fieldValue, v.getValue())).collect(Collectors.toList());
    }

    public static boolean matchEnumeratedValue(SvdField field, BigInteger fieldValue, EnumeratedValueDataType valueDataType) {
        BigInteger doNotCareMask = valueDataType.getDoNotCareMask();
        BigInteger cleanedValue = fieldValue.and(doNotCareMask.xor(SvdFields.getMask(field.getBitLength())));
        return valueDataType.getValue().equals(cleanedValue);
    }

    public static BigInteger getFieldValue(SvdField field, BigInteger registerValue) {
        int rBitLength = field.getParent().getBitLength();
        int fBitOffset = field.getBitOffset();
        int fBitLength = field.getBitLength();
        BigInteger rMask = SvdFields.getMask(rBitLength);
        registerValue = registerValue.and(rMask);
        BigInteger shiftRight = registerValue.shiftRight(fBitOffset);
        BigInteger shiftLeftMask = rMask.shiftLeft(fBitLength);
        BigInteger xorMask = shiftLeftMask.xor(rMask);
        BigInteger result = shiftRight.and(xorMask);
        return result;
    }

    public static BigInteger applyFieldEnumeratedValue(SvdField field, BigInteger registerValue, EnumeratedValueDataType valueDataType) {
        return SvdFields.applyFieldValue(field, registerValue, valueDataType.getValue(), valueDataType.getDoNotCareMask());
    }

    public static BigInteger applyFieldValue(SvdField field, BigInteger registerValue, BigInteger fieldValue) {
        return SvdFields.applyFieldValue(field, registerValue, fieldValue, null);
    }

    public static BigInteger applyFieldValue(SvdField field, BigInteger registerValue, BigInteger fieldValue, BigInteger doNotCareMask) {
        int rBitLength = field.getParent().getBitLength();
        int fBitOffset = field.getBitOffset();
        int fBitLength = field.getBitLength();
        BigInteger rMask = SvdFields.getMask(rBitLength);
        registerValue = registerValue.and(rMask);
        BigInteger fMask = SvdFields.getMask(fBitLength);
        fieldValue = fieldValue.and(fMask);
        if (doNotCareMask != null) {
            fMask = fMask.xor(doNotCareMask);
        }
        fMask = fMask.shiftLeft(fBitOffset).and(rMask);
        fMask = fMask.xor(rMask);
        registerValue = registerValue.and(fMask);
        fieldValue = fieldValue.shiftLeft(fBitOffset);
        BigInteger result = registerValue.or(fieldValue);
        return result;
    }

    public static BigInteger getMask(int bitLength) {
        switch (bitLength) {
            case 8: {
                return ALL_BITS_ON_8;
            }
            case 16: {
                return ALL_BITS_ON_16;
            }
            case 32: {
                return ALL_BITS_ON_32;
            }
            case 64: {
                return ALL_BITS_ON_64;
            }
            case 128: {
                return ALL_BITS_ON_128;
            }
        }
        return SvdFields.allBits(bitLength);
    }

    public static BigInteger allBits(int i) {
        return BigInteger.ONE.shiftLeft(i).subtract(BigInteger.ONE);
    }
}

