/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.freertos.gdb.tad.controller.tasklist;

import com.nxp.freertos.gdb.tad.ReadingException;
import com.nxp.freertos.gdb.tad.controller.TadFactory;
import com.nxp.freertos.gdb.tad.controller.TadFactoryData;
import com.nxp.freertos.gdb.tad.controller.TadFactoryDataStatus;
import com.nxp.freertos.gdb.tad.logger.Logger;
import com.nxp.freertos.gdb.tad.model.freertos.FreeRTOS;
import com.nxp.freertos.gdb.tad.model.freertos.FreeRTOSConfig;
import com.nxp.freertos.gdb.tad.model.readers.MemoryReader;
import com.nxp.freertos.gdb.tad.model.readers.VariableReader;
import com.nxp.freertos.gdb.tad.model.views.TadDataCache;
import com.nxp.freertos.gdb.tad.model.views.TadObject;
import com.nxp.freertos.gdb.tad.model.views.queuelist.Queue;
import com.nxp.freertos.gdb.tad.model.views.queuelist.QueueWaitingTask;
import com.nxp.freertos.gdb.tad.model.views.queuelist.QueueWaitingTaskOperation;
import com.nxp.freertos.gdb.tad.model.views.tasklist.Task;
import com.nxp.freertos.gdb.tad.model.views.tasklist.TaskEventObject;
import com.nxp.freertos.gdb.tad.model.views.tasklist.TaskPriority;
import com.nxp.freertos.gdb.tad.model.views.tasklist.TaskStack;
import com.nxp.freertos.gdb.tad.model.views.tasklist.TaskState;
import com.nxp.freertos.gdb.tad.strings.Texts;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class TaskFactory
extends TadFactory {
    private Map<TaskState, String[]> taskLists;
    private List<? extends TadObject> queues;
    private TadDataCache dataCache;
    private long runningTaskPtr;
    private final int STACK_FILL_BYTE = 165;

    public TaskFactory(MemoryReader memoryReader, VariableReader variableReader, FreeRTOS freeRTOS, TadDataCache dataCache) {
        super(memoryReader, variableReader, freeRTOS);
        this.dataCache = dataCache;
        this.taskLists = new HashMap<TaskState, String[]>();
        this.taskLists.put(TaskState.BLOCKED, new String[]{"pxDelayedTaskList", "pxOverflowDelayedTaskList"});
        this.taskLists.put(TaskState.READY, new String[]{"xPendingReadyList"});
        this.taskLists.put(TaskState.SUSPENDED, new String[]{"xSuspendedTaskList"});
    }

    @Override
    public synchronized TadFactoryData getData() {
        LinkedList<Task> list = new LinkedList<Task>();
        long listSize = 0L;
        long listStructSize = 0L;
        long numberOfReadyTasks = 0L;
        try {
            listSize = this.getSize("pxReadyTasksLists");
            listStructSize = this.getStructSize(this.freeRTOS.getStruct("list_item"));
            numberOfReadyTasks = listSize > 0L && listStructSize > 0L ? listSize / listStructSize : 0L;
        }
        catch (ReadingException e) {
            Logger.error(String.format(Texts.get("Error.CouldNotGetSize"), e.getArgs()));
            Logger.error(Texts.get("Error.CannotDisplayReadyTaskList"));
        }
        this.runningTaskPtr = this.readLongVariableSafely("pxCurrentTCB");
        if (this.freeRTOS.isMacroEnabled(FreeRTOSConfig.RUNTIME_STATS)) {
            try {
                this.freeRTOS.setRuntime(this.readLongVariable("ulTotalRunTime"));
            }
            catch (ReadingException readingException) {
                this.freeRTOS.enableMacro(FreeRTOSConfig.RUNTIME_STATS, false);
            }
        }
        this.queues = this.dataCache.getViewTadObjects("Queue List");
        int i = 0;
        while ((long)i < numberOfReadyTasks) {
            String readFrom = "pxReadyTasksLists[" + i + "]";
            try {
                list.addAll(this.readTasksFromList(readFrom, TaskState.READY));
            }
            catch (ReadingException readingException) {
                Logger.error(String.format(Texts.get("Error.CannotReadFrom"), readFrom));
            }
            ++i;
        }
        for (Map.Entry<TaskState, String[]> listItem : this.taskLists.entrySet()) {
            String[] stringArray = listItem.getValue();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String listName = stringArray[n2];
                try {
                    list.addAll(this.readTasksFromList(listName, listItem.getKey()));
                }
                catch (ReadingException readingException) {
                    Logger.error(String.format(Texts.get("Error.CannotReadFrom"), listName));
                }
                ++n2;
            }
        }
        if (!this.freeRTOS.isMacroEnabled(FreeRTOSConfig.RECORD_STACK_HIGH_ADDRESS)) {
            Logger.error(Texts.get("Info.CouldNotReadEndOfStack"));
        }
        Collections.sort(list, new Comparator<Task>(){

            @Override
            public int compare(Task task1, Task task2) {
                if (task1.getTCBNumber() != null && task2.getTCBNumber() != null) {
                    if (task1.getTCBNumber() < task2.getTCBNumber()) {
                        return -1;
                    }
                    if (task1.getTCBNumber() > task2.getTCBNumber()) {
                        return 1;
                    }
                }
                return 0;
            }
        });
        return new TadFactoryData(list, TadFactoryDataStatus.SUCCESS, null);
    }

    private synchronized List<Task> readTasksFromList(String listName, TaskState state) throws ReadingException {
        ArrayList<Task> list = new ArrayList<Task>();
        int numberOfItems = this.readIntVariable(String.valueOf(listName) + ".uxNumberOfItems");
        long listAddress = this.readLongVariable(String.valueOf(listName) + ".xListEnd.pxNext");
        int i = 0;
        while (i < numberOfItems && listAddress > 0L) {
            long eventObjPtr;
            List<Integer> stackMemoryBlock;
            long taskPtr = this.readLongAtAddress(listAddress, this.freeRTOS.getStruct("list_item"), "pvOwner");
            if (taskPtr == 0L) break;
            String name = this.readTaskName(taskPtr);
            Task task = new Task(name, taskPtr, this.freeRTOS);
            int basePriority = 0;
            if (this.freeRTOS.isMacroEnabled(FreeRTOSConfig.USE_MUTEXES)) {
                try {
                    basePriority = this.readIntAtAddress(taskPtr, this.freeRTOS.getStruct("task_control_block"), "uxBasePriority");
                }
                catch (ReadingException readingException) {
                    this.freeRTOS.enableMacro(FreeRTOSConfig.USE_MUTEXES, false);
                }
            }
            task.setPriority(new TaskPriority(this.readIntAtAddress(taskPtr, this.freeRTOS.getStruct("task_control_block"), "uxPriority"), basePriority));
            long stackBaseAddress = this.readLongAtAddress(taskPtr, this.freeRTOS.getStruct("task_control_block"), "pxStack");
            long stackEndAddress = this.readLongAtAddress(taskPtr, this.freeRTOS.getStruct("task_control_block"), "pxTopOfStack");
            if (this.freeRTOS.isMacroEnabled(FreeRTOSConfig.RECORD_STACK_HIGH_ADDRESS)) {
                try {
                    stackEndAddress = this.readLongAtAddress(taskPtr, this.freeRTOS.getStruct("task_control_block"), "pxEndOfStack");
                }
                catch (ReadingException readingException) {
                    this.freeRTOS.enableMacro(FreeRTOSConfig.RECORD_STACK_HIGH_ADDRESS, false);
                }
            }
            if ((stackMemoryBlock = this.readMemoryBlock(stackBaseAddress, stackEndAddress - stackBaseAddress)) != null && !stackMemoryBlock.isEmpty()) {
                task.setStack(new TaskStack(stackBaseAddress, stackEndAddress, stackBaseAddress + this.getStackHighWaterMarkBytes(stackMemoryBlock), this.isStackOverflown(stackMemoryBlock)));
            } else {
                Logger.error(Texts.get("Error.TaskStackDefault"));
                task.setStack(new TaskStack(stackBaseAddress, stackEndAddress, -1L, false));
            }
            if (this.freeRTOS.isMacroEnabled(FreeRTOSConfig.USE_TRACE)) {
                try {
                    task.setNumber(this.readLongAtAddress(taskPtr, this.freeRTOS.getStruct("task_control_block"), "uxTaskNumber"), this.readLongAtAddress(taskPtr, this.freeRTOS.getStruct("task_control_block"), "uxTCBNumber"));
                }
                catch (ReadingException readingException) {
                    this.freeRTOS.enableMacro(FreeRTOSConfig.USE_TRACE, false);
                }
            }
            if ((eventObjPtr = this.readLongAtAddress(taskPtr, this.freeRTOS.getStruct("task_control_block"), "xEventListItem." + (this.freeRTOS.getVersion() < 10.1 ? "pvContainer" : "pxContainer"))) != 0L) {
                TaskEventObject eventObject = new TaskEventObject();
                eventObject.setAddress(eventObjPtr);
                if (this.queues != null && !this.queues.isEmpty()) {
                    block7: for (TadObject tadObject : this.queues) {
                        if (!(tadObject instanceof Queue)) continue;
                        Queue queue = (Queue)tadObject;
                        for (Map.Entry<QueueWaitingTaskOperation, QueueWaitingTask> waitingTask : queue.getWaitingTasks().entrySet()) {
                            if (waitingTask.getValue().getAddress() != eventObjPtr) continue;
                            eventObject.setName(queue.getName());
                            eventObject.setOperation(waitingTask.getKey());
                            continue block7;
                        }
                    }
                }
                task.setEventObject(eventObject);
            }
            if (this.freeRTOS.isMacroEnabled(FreeRTOSConfig.RUNTIME_STATS)) {
                task.setTaskRuntime(this.readLongAtAddress(taskPtr, this.freeRTOS.getStruct("task_control_block"), "ulRunTimeCounter"));
            }
            task.setState(taskPtr == this.runningTaskPtr ? TaskState.RUNNING : state);
            list.add(task);
            listAddress = this.readLongAtAddress(listAddress, this.freeRTOS.getStruct("list_item"), "pxNext");
            ++i;
        }
        return list;
    }

    private long getStackHighWaterMarkBytes(List<Integer> memory) {
        ListIterator<Integer> iter = memory.listIterator();
        long freeBytesCount = 0L;
        while (iter.hasNext() && iter.next() == 165) {
            ++freeBytesCount;
        }
        return freeBytesCount;
    }

    private boolean isStackOverflown(List<Integer> memory) {
        int i = 0;
        while (i < 16) {
            if (memory.get(i) != 165) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

