/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.freertos.gdb.tad.view;

import com.nxp.freertos.gdb.tad.Activator;
import com.nxp.freertos.gdb.tad.controller.TadFactoryDataStatus;
import com.nxp.freertos.gdb.tad.controller.TadViewController;
import com.nxp.freertos.gdb.tad.logger.Log;
import com.nxp.freertos.gdb.tad.logger.LogType;
import com.nxp.freertos.gdb.tad.logger.Logger;
import com.nxp.freertos.gdb.tad.model.Auxiliary;
import com.nxp.freertos.gdb.tad.model.TadModel;
import com.nxp.freertos.gdb.tad.strings.Texts;
import com.nxp.freertos.gdb.tad.view.TadDoubleViewWeight;
import com.nxp.freertos.gdb.tad.view.TadViewType;
import com.nxp.freertos.gdb.tad.view.TadViewViewerType;
import com.nxp.freertos.gdb.tad.view.action.AboutDialogAction;
import com.nxp.freertos.gdb.tad.view.action.PauseViewAction;
import com.nxp.freertos.gdb.tad.view.action.SaveToClipboard;
import com.nxp.freertos.gdb.tad.view.action.SaveToFileAction;
import com.nxp.freertos.gdb.tad.view.column.TadColumn;
import com.nxp.freertos.gdb.tad.view.items.TadItem;
import com.nxp.freertos.gdb.tad.view.providers.TadBarGraphProvider;
import com.nxp.freertos.gdb.tad.view.providers.TadEditingSupport;
import com.nxp.freertos.gdb.tad.view.providers.TadItemColumnLabelProvider;
import com.nxp.freertos.gdb.tad.view.providers.TadItemsViewerComparator;
import com.nxp.freertos.gdb.tad.view.providers.TadTreeContentProvider;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.UIJob;

public abstract class TadView
extends ViewPart {
    private TadViewType viewType;
    private Map<TadViewViewerType, TreeViewer> viewers;
    protected List<TadColumn> parentColumns;
    protected List<TadColumn> childColumns;
    private TadDoubleViewWeight doubleViewWeight;
    private IPartListener2 partListener;
    private boolean visible;
    private Composite parentComposite;
    private Composite progressViewComposite;
    private Composite messageViewComposite;
    private CLabel messageLabel;
    private Label messageDescLabel;
    private Text exceptionText;
    private Composite tadViewComposite;
    private StackLayout layout;
    private TadViewController viewController;
    private int previousSortColumn;
    private TadItem previouslySelectedItem;
    private Action saveToCSV;
    private Action pauseView;

    protected abstract TadView getTadView();

    public TadView(TadViewType type) {
        this.viewType = type;
        this.doubleViewWeight = TadDoubleViewWeight.SAME;
        this.viewers = new LinkedHashMap<TadViewViewerType, TreeViewer>();
        this.parentColumns = new LinkedList<TadColumn>();
        this.childColumns = new LinkedList<TadColumn>();
        this.previousSortColumn = 0;
        this.previouslySelectedItem = null;
    }

    public TadView(TadViewType type, TadDoubleViewWeight weight) {
        this(type);
        this.doubleViewWeight = weight;
    }

    public TadViewController getController() {
        if (this.viewController == null) {
            this.viewController = new TadViewController(this.getTadView());
        }
        return this.viewController;
    }

    public Map<TadViewViewerType, TreeViewer> getTreeViewers() {
        return this.viewers;
    }

    public void createPartControl(Composite parent) {
        this.partListener = new IPartListener2(){

            public void partVisible(IWorkbenchPartReference partRef) {
                if (((Object)((Object)TadView.this)).equals(partRef.getPart(false))) {
                    TadView.this.setVisible(true);
                    if (Activator.getTadModel().isTadReady() && !TadView.this.isViewPaused()) {
                        if (!TadView.this.getController().isDataReady()) {
                            TadView.this.showProgressBar();
                        }
                        TadView.this.getController().requestData();
                    }
                }
            }

            public void partOpened(IWorkbenchPartReference partRef) {
            }

            public void partInputChanged(IWorkbenchPartReference partRef) {
            }

            public void partHidden(IWorkbenchPartReference partRef) {
                if (((Object)((Object)TadView.this)).equals(partRef.getPart(false))) {
                    TadView.this.setVisible(false);
                }
            }

            public void partDeactivated(IWorkbenchPartReference partRef) {
            }

            public void partClosed(IWorkbenchPartReference partRef) {
            }

            public void partBroughtToTop(IWorkbenchPartReference partRef) {
            }

            public void partActivated(IWorkbenchPartReference partRef) {
            }
        };
        this.getSite().getPage().addPartListener(this.partListener);
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                TadView.this.viewers.clear();
                TadView.this.getSite().getPage().removePartListener(TadView.this.partListener);
                TadView.this.getController().dispose();
            }
        });
        this.getController();
        this.parentComposite = new Composite(parent, 0);
        this.layout = new StackLayout();
        this.parentComposite.setLayout((Layout)this.layout);
        this.tadViewComposite = new Composite(this.parentComposite, 0);
        this.tadViewComposite.setLayout((Layout)new FillLayout());
        this.progressViewComposite = new Composite(this.parentComposite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        this.progressViewComposite.setLayout((Layout)gridLayout);
        Label label = new Label(this.progressViewComposite, 0);
        label.setText(Texts.get("Info.FetchingData"));
        ProgressBar pb = new ProgressBar(this.progressViewComposite, 258);
        pb.setLayoutData((Object)new GridData(768));
        this.messageViewComposite = new Composite(this.parentComposite, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        this.messageViewComposite.setLayout((Layout)gridLayout);
        this.messageLabel = new CLabel(this.messageViewComposite, 0x1000000);
        this.messageLabel.setLayoutData((Object)new GridData(1808));
        this.messageDescLabel = new Label(this.messageViewComposite, 0x1000040);
        this.messageDescLabel.setLayoutData((Object)new GridData(1808));
        this.exceptionText = new Text(this.messageViewComposite, 584);
        this.exceptionText.setLayoutData((Object)new GridData(1808));
        switch (this.viewType) {
            case SINGLE: {
                TreeViewer viewer = this.createTreeViewer(new Composite(this.tadViewComposite, 0), this.parentColumns);
                viewer.setContentProvider((IContentProvider)new TadTreeContentProvider(TadViewViewerType.PARENT));
                this.viewers.put(TadViewViewerType.PARENT, viewer);
                break;
            }
            case DOUBLE: {
                SashForm sashForm = new SashForm(this.tadViewComposite, 512);
                sashForm.setBackground(sashForm.getDisplay().getSystemColor(15));
                TreeViewer parentViewer = this.createTreeViewer(new Composite((Composite)sashForm, 0), this.parentColumns);
                final TreeViewer childViewer = this.createTreeViewer(new Composite((Composite)sashForm, 0), this.childColumns);
                sashForm.setWeights(this.doubleViewWeight.getWeight());
                parentViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent event) {
                        IStructuredSelection selection;
                        if (childViewer != null && event.getSelection() instanceof IStructuredSelection && (selection = (IStructuredSelection)event.getSelection()).getFirstElement() instanceof TadItem) {
                            TadItem activeItem;
                            TadItem selectedItem = (TadItem)selection.getFirstElement();
                            TadItem tadItem = activeItem = selectedItem.isParent() ? selectedItem : selectedItem.getParent();
                            if (selectedItem != null && selectedItem != TadView.this.previouslySelectedItem) {
                                TadView.this.previouslySelectedItem = selectedItem;
                                TadView.this.enableViewer(childViewer, activeItem.hasChildItems());
                                childViewer.setInput((Object)activeItem);
                            }
                        }
                    }
                });
                parentViewer.setContentProvider((IContentProvider)new TadTreeContentProvider(TadViewViewerType.PARENT));
                childViewer.setContentProvider((IContentProvider)new TadTreeContentProvider(TadViewViewerType.CHILD));
                this.viewers.put(TadViewViewerType.PARENT, parentViewer);
                this.viewers.put(TadViewViewerType.CHILD, childViewer);
            }
        }
        IToolBarManager toolbar = this.getViewSite().getActionBars().getToolBarManager();
        final Shell parentShell = this.getViewSite().getShell();
        this.pauseView = new PauseViewAction(this);
        this.pauseView.setEnabled(false);
        this.pauseView.setChecked(false);
        toolbar.add((IAction)this.pauseView);
        toolbar.add((IContributionItem)new Separator());
        this.saveToCSV = new SaveToFileAction(parentShell, this.getTitle(), this.viewers);
        this.saveToCSV.setEnabled(false);
        toolbar.add((IAction)this.saveToCSV);
        toolbar.add((IAction)new AboutDialogAction(parentShell));
        for (final TreeViewer viewer : this.viewers.values()) {
            MenuManager menuMgr = new MenuManager();
            menuMgr.setRemoveAllWhenShown(true);
            menuMgr.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager manager) {
                    manager.add((IAction)new SaveToClipboard(parentShell, viewer));
                }
            });
            viewer.getControl().setMenu(menuMgr.createContextMenu((Control)viewer.getTree()));
        }
        this.showTadView();
    }

    private TreeViewer createTreeViewer(Composite composite, List<TadColumn> columns) {
        TreeColumnLayout layout = new TreeColumnLayout();
        composite.setLayout((Layout)layout);
        final TreeViewer viewer = new TreeViewer(composite, 67584);
        final Tree tree = viewer.getTree();
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        TextCellEditor cellEditor = new TextCellEditor((Composite)tree, 8);
        for (final TadColumn column : columns) {
            TreeViewerColumn treeViewerColumn = new TreeViewerColumn(viewer, 0);
            TreeColumn treeColumn = treeViewerColumn.getColumn();
            layout.setColumnData((Widget)treeColumn, (ColumnLayoutData)new ColumnWeightData(column.getWeight()));
            treeColumn.setText(column.getName());
            treeColumn.setToolTipText(column.getTooltip());
            treeViewerColumn.setEditingSupport((EditingSupport)new TadEditingSupport(viewer, cellEditor, column));
            treeColumn.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    TreeColumn selectedColumn = (TreeColumn)e.getSource();
                    if (tree.getSortColumn() == selectedColumn) {
                        tree.setSortDirection(tree.getSortDirection() == 128 ? 1024 : 128);
                    } else {
                        tree.setSortColumn(selectedColumn);
                        tree.setSortDirection(1024);
                    }
                    viewer.setComparator((ViewerComparator)new TadItemsViewerComparator(column));
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            TadBarGraphProvider barGraphProvider = column.getStyledCell();
            if (barGraphProvider != null) {
                barGraphProvider.setDependency(column.getDependency());
                barGraphProvider.setColumnId(column.getId());
                barGraphProvider.setColumnName(column.getName());
                treeViewerColumn.setLabelProvider((CellLabelProvider)barGraphProvider);
                continue;
            }
            treeViewerColumn.setLabelProvider((CellLabelProvider)new TadItemColumnLabelProvider(column));
        }
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)viewer);
        viewer.getControl().setEnabled(false);
        return viewer;
    }

    private void showPage(final Composite composite) {
        UIJob job = new UIJob("Show page"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (TadView.this.parentComposite != null && TadView.this.layout != null && composite != null) {
                    ((TadView)TadView.this).layout.topControl = composite;
                    TadView.this.parentComposite.layout();
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.setUser(false);
        job.schedule();
    }

    public void showMessage(final TadFactoryDataStatus dataStatus, final String message) {
        UIJob job = new UIJob(""){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (TadView.this.parentComposite != null && TadView.this.layout != null && TadView.this.messageViewComposite != null && message != null) {
                    TadView.this.messageLabel.setText(Auxiliary.capitalize(dataStatus.toString()));
                    TadView.this.messageDescLabel.setText(message);
                    TadView.this.exceptionText.setVisible(false);
                    block0 : switch (dataStatus) {
                        case ERROR: {
                            TadView.this.messageLabel.setImage(TadModel.ERROR_IMG);
                            if (dataStatus != TadFactoryDataStatus.ERROR) break;
                            TadView.this.exceptionText.setVisible(true);
                            Log[] logs = Logger.getLogs();
                            int i = logs.length - 1;
                            while (i > 0) {
                                if (logs[i].getType() == LogType.EXCEPTION) {
                                    TadView.this.exceptionText.setText(logs[i].toString());
                                    break block0;
                                }
                                --i;
                            }
                            break;
                        }
                        case WARNING: {
                            TadView.this.messageLabel.setImage(TadModel.WARNING_BIG_IMG);
                            break;
                        }
                        case INFORMATION: {
                            TadView.this.messageLabel.setImage(TadModel.INFORMATION_IMG_DESC.createImage());
                            break;
                        }
                        case SUCCESS: {
                            Logger.error(Texts.get("Error.ShowMessage"));
                            return Status.CANCEL_STATUS;
                        }
                    }
                    ((TadView)TadView.this).layout.topControl = TadView.this.messageViewComposite;
                    TadView.this.parentComposite.layout();
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.setUser(false);
        job.schedule();
        this.saveToCSV.setEnabled(false);
        this.pauseView.setEnabled(false);
        this.pauseView.setChecked(false);
    }

    public void showProgressBar() {
        this.showPage(this.progressViewComposite);
    }

    public void showTadView() {
        this.showPage(this.tadViewComposite);
    }

    public boolean isVisible() {
        return this.visible;
    }

    private void setVisible(boolean isVisible) {
        this.visible = isVisible;
    }

    public boolean isViewPaused() {
        return this.pauseView.isChecked();
    }

    public void enableAllActions(boolean enable) {
        this.saveToCSV.setEnabled(enable);
        this.pauseView.setEnabled(enable);
        if (!enable) {
            this.pauseView.setChecked(false);
        }
    }

    public void refreshData(final Object data, final boolean enabled) {
        for (final TreeViewer viewer : this.viewers.values()) {
            UIJob job = new UIJob("Refresh " + this.getTitle()){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    viewer.setInput(data);
                    viewer.getControl().setEnabled(enabled);
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.setUser(false);
            job.schedule();
        }
        this.enableAllActions(enabled);
        if (!enabled) {
            this.pauseView.setChecked(false);
        }
    }

    public void clearData() {
        for (final Viewer viewer : this.viewers.values()) {
            UIJob job = new UIJob("Clear " + this.getTitle()){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    viewer.setInput(null);
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.setUser(false);
            job.schedule();
        }
    }

    public void enableAllViewers(final boolean enable) {
        final TreeViewer viewer = this.viewers.get((Object)TadViewViewerType.PARENT);
        final TreeViewer childViewer = this.viewers.get((Object)TadViewViewerType.CHILD);
        UIJob job = new UIJob(String.valueOf(enable ? "Enable " : "Disable ") + this.getTitle()){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                TadView.this.enableViewer(viewer, enable);
                Tree tree = viewer.getTree();
                if (childViewer != null) {
                    TadView.this.enableViewer(childViewer, enable);
                    if (enable && tree.getItems().length > 0) {
                        TreeItem[] treeItemArray = tree.getItems();
                        int n = treeItemArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TreeItem treeItem = treeItemArray[n2];
                            TadItem item = (TadItem)treeItem.getData();
                            if (item.isValid()) {
                                tree.setSelection(treeItem);
                                childViewer.setInput((Object)item);
                                TadView.this.enableViewer(childViewer, item.hasChildItems());
                                break;
                            }
                            ++n2;
                        }
                    }
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.setUser(false);
        job.schedule();
    }

    public void enableViewer(TreeViewer viewer, boolean enable) {
        Tree tree = viewer.getTree();
        if (enable) {
            if (tree.getColumnCount() > this.previousSortColumn) {
                tree.setSortColumn(tree.getColumn(this.previousSortColumn));
            } else {
                tree.setSortColumn(null);
            }
            tree.setSortDirection(128);
        } else {
            if (tree.getSortColumn() != null) {
                int index = 0;
                TreeColumn[] treeColumnArray = tree.getColumns();
                int n = treeColumnArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeColumn column = treeColumnArray[n2];
                    if (column.getText().equals(tree.getSortColumn().getText())) {
                        this.previousSortColumn = index;
                        break;
                    }
                    ++index;
                    ++n2;
                }
            }
            tree.setSortColumn(null);
            tree.setSortDirection(0);
        }
        viewer.getControl().setEnabled(enable);
    }

    public void setFocus() {
    }
}

