/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.freertos.gdb.tad.view.action;

import com.nxp.freertos.gdb.tad.Activator;
import com.nxp.freertos.gdb.tad.logger.Logger;
import com.nxp.freertos.gdb.tad.strings.Texts;
import com.nxp.freertos.gdb.tad.view.TadView;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.TreeViewer;

public class PauseViewAction
extends Action {
    private TadView view;

    public PauseViewAction(TadView view) {
        this.view = view;
    }

    public void run() {
        if (this.isEnabled()) {
            for (TreeViewer viewer : this.view.getTreeViewers().values()) {
                this.view.enableViewer(viewer, !this.isChecked());
            }
            Logger.info(String.format(Texts.get("Info.ViewPaused"), this.view.getTitle(), this.isChecked() ? "paused" : "unpaused"));
            if (!this.isChecked() && !this.view.getController().isDataReady()) {
                this.view.showProgressBar();
                this.view.getController().requestData();
            }
        }
    }

    public String getText() {
        return String.format(Texts.get("Label.PauseView"), this.view.getTitle());
    }

    public String getToolTipText() {
        return String.format(Texts.get("Label.PauseView.ToolTip"), this.view.getTitle());
    }

    public ImageDescriptor getImageDescriptor() {
        return Activator.createImageDesc("blocked.gif");
    }
}

