/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.freertos.gdb.tad.view.views.tasklist;

import com.nxp.freertos.gdb.tad.logger.Logger;
import com.nxp.freertos.gdb.tad.model.Auxiliary;
import com.nxp.freertos.gdb.tad.model.views.tasklist.Task;
import com.nxp.freertos.gdb.tad.model.views.tasklist.TaskEventObject;
import com.nxp.freertos.gdb.tad.model.views.tasklist.TaskPriority;
import com.nxp.freertos.gdb.tad.model.views.tasklist.TaskStack;
import com.nxp.freertos.gdb.tad.strings.Separator;
import com.nxp.freertos.gdb.tad.strings.Texts;
import com.nxp.freertos.gdb.tad.view.column.TadColumnId;
import com.nxp.freertos.gdb.tad.view.items.TadItem;
import com.nxp.freertos.gdb.tad.view.items.TadTreeChildItem;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.swt.graphics.Image;

public class TaskItem
extends TadItem {
    private Task task;
    private List<TadItem> treeChildren;

    public TaskItem(Task task, int index) {
        super(index);
        this.task = task;
        this.treeChildren = new LinkedList<TadItem>();
        TaskStack stack = task.getStack();
        if (stack != null) {
            int i = 1;
            if (task.getTaskNumber() != null) {
                this.treeChildren.add(new TadTreeChildItem(this, i++, "Task Number", String.format("0x%x", task.getTaskNumber())));
            }
            this.treeChildren.add(new TadTreeChildItem(this, i++, "Stack Base", String.format("0x%08x", stack.getBaseAddress())));
            this.treeChildren.add(new TadTreeChildItem(this, i++, "Stack Top", String.format("0x%08x", stack.getEndAddress())));
            this.treeChildren.add(new TadTreeChildItem(this, i++, "Stack High Water Mark", stack.isOverflown() ? "Stack overflow!" : (stack.getHighWaterMarkAddress() == -1L ? "Unknown" : String.format("0x%08x", stack.getHighWaterMarkAddress()))));
        }
    }

    @Override
    public List<? extends TadItem> getTreeChildren() {
        return this.treeChildren;
    }

    @Override
    public int getTextColour() {
        return this.task.getState() != null ? this.task.getState().getColour() : super.getTextColour();
    }

    @Override
    public String toString(Separator separator) {
        return super.toString(new TadColumnId[]{TadColumnId.ID, TadColumnId.NAME, TadColumnId.ADDRESS, TadColumnId.STATE, TadColumnId.PRIORITY, TadColumnId.USAGE_GRAPH, TadColumnId.EVENT_OBJ, TadColumnId.RUNTIME}, separator);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getText(TadColumnId column) {
        try {
            switch (column) {
                case ID: {
                    if (this.task.getTCBNumber() != null) {
                        return String.format("%d", this.task.getTCBNumber());
                    }
                    return null;
                }
                case NAME: {
                    return this.task.getName();
                }
                case ADDRESS: {
                    return String.format("0x%08x", this.task.getAddress());
                }
                case STATE: {
                    return Auxiliary.capitalize(this.task.getState().toString());
                }
                case PRIORITY: {
                    TaskPriority priority = this.task.getPriority();
                    return String.format("%d (%d)", priority.getActual(), priority.getBase());
                }
                case USAGE_GRAPH: {
                    if (this.task.getStack() != null && this.task.getStack().getHighWaterMarkAddress() != -1L) {
                        return String.format("%s / %s", TaskItem.formatBytes(this.task.getStack().getUsage()), TaskItem.formatBytes(this.task.getStack().getSize()));
                    }
                    return "Unknown";
                }
                case EVENT_OBJ: {
                    TaskEventObject eventObject = this.task.getEventObject();
                    if (eventObject != null && eventObject.getAddress() != 0L) {
                        if (eventObject.getName() == null) {
                            return String.valueOf(Texts.get("Error.Unknown")) + String.format(" (0x%08x)", eventObject.getAddress());
                        }
                        return String.format("%s (%s)", eventObject.getName(), Auxiliary.capitalize(eventObject.getOperation().toString()));
                    }
                    return null;
                }
                case RUNTIME: {
                    if (this.task.getTaskRuntime() != null) {
                        return String.format("0x%x (%.1f%%)", this.task.getTaskRuntime(), Auxiliary.getPercentage(this.task.getTaskRuntime(), this.task.getRuntime()));
                    }
                    return null;
                }
            }
            return null;
        }
        catch (NullPointerException e) {
            Logger.exception(e, String.format(Texts.get("Exception.WhileGetTextColumn"), column.toString()));
            return null;
        }
    }

    @Override
    public Long getNumValue(TadColumnId column) {
        switch (column) {
            case ADDRESS: {
                return this.task.getAddress();
            }
            case PRIORITY: {
                return this.task.getPriority() != null ? (long)this.task.getPriority().getActual() : 0L;
            }
            case USAGE_GRAPH: {
                if (this.task.getStack() != null && this.task.getStack().getHighWaterMarkAddress() != -1L) {
                    return (long)(Auxiliary.getPercentage(this.task.getStack().getUsage(), this.task.getStack().getSize()) * 100.0);
                }
                return 0L;
            }
            case RUNTIME: {
                return this.task.getTaskRuntime() != null ? this.task.getTaskRuntime() : null;
            }
        }
        return null;
    }

    @Override
    public Image getImage(TadColumnId column) {
        switch (column) {
            case STATE: {
                return this.task.getState().getImage();
            }
        }
        return null;
    }

    Task getTask() {
        return this.task;
    }
}

