/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.freertos.gdb.tad.view.views.timerlist;

import com.nxp.freertos.gdb.tad.logger.Logger;
import com.nxp.freertos.gdb.tad.model.Auxiliary;
import com.nxp.freertos.gdb.tad.model.views.timerlist.Timer;
import com.nxp.freertos.gdb.tad.strings.Separator;
import com.nxp.freertos.gdb.tad.strings.Texts;
import com.nxp.freertos.gdb.tad.view.column.TadColumnId;
import com.nxp.freertos.gdb.tad.view.items.TadItem;

public class TimerItem
extends TadItem {
    private Timer timer;

    public TimerItem(Timer timer, int index) {
        super(index);
        this.timer = timer;
    }

    @Override
    public String toString(Separator separator) {
        return super.toString(new TadColumnId[]{TadColumnId.ID, TadColumnId.NAME, TadColumnId.NUMBER, TadColumnId.PERIOD, TadColumnId.AUTO_RELOAD, TadColumnId.CALLBACK}, separator);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getText(TadColumnId column) {
        try {
            switch (column) {
                case ID: {
                    return String.format("0x%x", this.timer.getId());
                }
                case NAME: {
                    return this.timer.getName();
                }
                case PERIOD: {
                    return String.format("%d", this.timer.getPeriod());
                }
                case AUTO_RELOAD: {
                    return Auxiliary.yesNo(this.timer.isAutoReload());
                }
                case NUMBER: {
                    if (this.timer.getNumber() != null) {
                        return String.format("0x%x", this.timer.getNumber());
                    }
                    return null;
                }
                case CALLBACK: {
                    return String.format("%s (0x%08x)", this.timer.getCallback().getName(), this.timer.getCallback().getAddress());
                }
            }
            return null;
        }
        catch (NullPointerException e) {
            Logger.exception(e, String.format(Texts.get("Exception.WhileGetTextColumn"), column.toString()));
            return null;
        }
    }

    @Override
    public Long getNumValue(TadColumnId column) {
        switch (column) {
            case ID: {
                return this.timer.getId();
            }
            case NUMBER: {
                if (this.timer.getNumber() != null) {
                    return new Long(this.timer.getNumber());
                }
                return null;
            }
            case CALLBACK: {
                return this.timer.getCallback() != null ? this.timer.getCallback().getAddress() : 0L;
            }
        }
        return null;
    }
}

