/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.rcp.compatibility.data.registry.internal;

import com.nxp.s32ds.ext.rcp.compatibility.data.registry.Archetype;
import com.nxp.s32ds.ext.rcp.compatibility.data.registry.CompatibilitiesDataDescriptor;
import com.nxp.s32ds.ext.rcp.compatibility.data.registry.CompatibilitiesDataRegistry;
import com.nxp.s32ds.ext.rcp.compatibility.data.registry.internal.CompatibilitiesDataRegistryActivator;
import com.nxp.s32ds.ext.rcp.compatibility.data.registry.internal.Messages;
import com.nxp.s32ds.ext.rcp.registry.BaseRegistry;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.osgi.util.NLS;
import org.osgi.service.component.annotations.Component;

@Component
public class CompatibilitiesDataRegistryImplementation
extends BaseRegistry
implements CompatibilitiesDataRegistry {
    private Map<Archetype, Set<CompatibilitiesDataDescriptor>> archetype2CompatibilitiesDataDescriptors = new HashMap<Archetype, Set<CompatibilitiesDataDescriptor>>();

    @Override
    public Set<Archetype> getAllArchetypes() {
        return Collections.unmodifiableSet(this.archetype2CompatibilitiesDataDescriptors.keySet());
    }

    @Override
    public Set<CompatibilitiesDataDescriptor> getCompatibilitiesDataDescriptorForArchetype(Archetype archetype) {
        Set<CompatibilitiesDataDescriptor> ids = this.archetype2CompatibilitiesDataDescriptors.get(archetype);
        if (ids == null) {
            CompatibilitiesDataRegistryActivator.getInstance().logError(NLS.bind((String)Messages.CompatibilitiesDataRegistryImplementation_NotExistArchetype, (Object)archetype));
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(ids);
    }

    @Override
    public void addCompatibilitiesDataDescriptorForArchetype(Archetype archetype, CompatibilitiesDataDescriptor compatibilitiesDataDescriptor) {
        if (!this.archetype2CompatibilitiesDataDescriptors.containsKey(archetype)) {
            CompatibilitiesDataRegistryActivator.getInstance().logError(NLS.bind((String)Messages.CompatibilitiesDataRegistryImplementation_NotExistArchetype, (Object)archetype));
            return;
        }
        Set<CompatibilitiesDataDescriptor> set = this.archetype2CompatibilitiesDataDescriptors.get(archetype);
        if (!set.add(compatibilitiesDataDescriptor)) {
            CompatibilitiesDataRegistryActivator.getInstance().logError(NLS.bind((String)Messages.CompatibilitiesDataRegistryImplementation_ComponentIdForArchetypeAlreadyExist, (Object)compatibilitiesDataDescriptor, (Object)archetype));
        }
    }

    @Override
    public void removeCompatibilitiesDataDescriptorForArchetype(Archetype archetype, CompatibilitiesDataDescriptor compatibilitiesDataDescriptor) {
        if (!this.archetype2CompatibilitiesDataDescriptors.containsKey(archetype)) {
            CompatibilitiesDataRegistryActivator.getInstance().logError(NLS.bind((String)Messages.CompatibilitiesDataRegistryImplementation_NotExistArchetype, (Object)archetype));
            return;
        }
        Set<CompatibilitiesDataDescriptor> set = this.archetype2CompatibilitiesDataDescriptors.get(archetype);
        if (!set.contains(compatibilitiesDataDescriptor)) {
            CompatibilitiesDataRegistryActivator.getInstance().logError(NLS.bind((String)Messages.CompatibilitiesDataRegistryImplementation_NotExistComponentIdForArchetype, (Object)compatibilitiesDataDescriptor, (Object)archetype));
            return;
        }
        set.remove(compatibilitiesDataDescriptor);
    }

    @Override
    public void addArchetype(Archetype archetype) {
        if (this.archetype2CompatibilitiesDataDescriptors.containsKey(archetype)) {
            CompatibilitiesDataRegistryActivator.getInstance().logError(NLS.bind((String)Messages.CompatibilitiesDataRegistryImplementation_ArchetypeAlreadyExist, (Object)archetype));
            return;
        }
        this.archetype2CompatibilitiesDataDescriptors.put(archetype, new HashSet());
    }

    @Override
    public void removeArchetype(Archetype archetype) {
        if (!this.archetype2CompatibilitiesDataDescriptors.containsKey(archetype)) {
            CompatibilitiesDataRegistryActivator.getInstance().logError(NLS.bind((String)Messages.CompatibilitiesDataRegistryImplementation_NotExistArchetype, (Object)archetype));
            return;
        }
        this.archetype2CompatibilitiesDataDescriptors.remove(archetype);
    }
}

