/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.validation;

import com.nxp.s32ds.debug.ide.validation.ErrorMessages;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class NumberFieldValidator
implements IValidator<Object> {
    private static final int ZERO_VALUE = 0;
    private static final String LEADING_ZERO = "0";
    private String parameterName;
    private int minimumValue;
    private int maximumValue;

    public NumberFieldValidator(String parameterName, int minimumValue, int maximumValue) {
        this.parameterName = parameterName;
        this.minimumValue = minimumValue;
        this.maximumValue = maximumValue;
    }

    public IStatus validate(Object value) {
        try {
            String valueStr = String.valueOf(value);
            if (valueStr.isEmpty()) {
                return new Status(4, "com.nxp.s32ds.debug.ide.validation", NLS.bind((String)ErrorMessages.FieldValidator_empty_field, (Object)this.parameterName));
            }
            if (valueStr.startsWith(LEADING_ZERO) && valueStr.length() > 1) {
                return new Status(4, "com.nxp.s32ds.debug.ide.validation", NLS.bind((String)ErrorMessages.NumberValidator_value_has_leading_zeroes, (Object)this.parameterName));
            }
            long inputValue = Long.parseLong(valueStr);
            if (inputValue < 0L) {
                return new Status(4, "com.nxp.s32ds.debug.ide.validation", NLS.bind((String)ErrorMessages.NumberValidator_value_less_than_zero, (Object)this.parameterName));
            }
            if (inputValue < (long)this.minimumValue) {
                return new Status(2, "com.nxp.s32ds.debug.ide.validation", NLS.bind((String)ErrorMessages.NumberValidator_value_less_than_recommended, (Object)this.parameterName, (Object)this.minimumValue));
            }
            if (inputValue > (long)this.maximumValue) {
                return new Status(4, "com.nxp.s32ds.debug.ide.validation", NLS.bind((String)ErrorMessages.NumberValidator_value_more_than_required, (Object)this.parameterName, (Object)this.maximumValue));
            }
        }
        catch (NumberFormatException numberFormatException) {
            return new Status(4, "com.nxp.s32ds.debug.ide.validation", NLS.bind((String)ErrorMessages.NumberValidator_value_invalid, (Object)this.parameterName));
        }
        return new Status(0, "com.nxp.s32ds.debug.ide.validation", null);
    }
}

