/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.migration.actions.launch;

import com.nxp.s32ds.cle.runtime.migration.action.MigrationAction;
import com.nxp.s32ds.cle.runtime.migration.annotation.MigrationPropertyAnnotation;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;

public abstract class UpdateLaunchConfigurationActionBase
implements MigrationAction {
    private static final String GDB_PATH_OUTDATED_MARKER = "com.nxp.s32ds.cle.debug.s32debugger.gdb.path.invalid.launch.marker";
    protected static final String DEBUGGER_DEBUG_NAME_DEFAULT = "gdb";
    @MigrationPropertyAnnotation(description="The toolchain ID to update.")
    private String toolchainId;

    public void perform(IProject project, IProgressMonitor monitor) throws CoreException {
        List<ILaunchConfiguration> launchConfigurations = this.getLaunchConfigurations(project.getName());
        if (launchConfigurations.isEmpty()) {
            return;
        }
        for (ILaunchConfiguration configuration : launchConfigurations) {
            ILaunchConfigurationWorkingCopy workingCopy = configuration.getWorkingCopy();
            this.migrateWorkingCopy(workingCopy, project, this.toolchainId);
            workingCopy.doSave();
        }
        UpdateLaunchConfigurationActionBase.removeMarker(project);
    }

    protected List<ILaunchConfiguration> getLaunchConfigurations(String projectName) throws CoreException {
        ILaunchConfiguration[] launchConfigurations;
        ArrayList<ILaunchConfiguration> configurations = new ArrayList<ILaunchConfiguration>();
        ILaunchConfiguration[] iLaunchConfigurationArray = launchConfigurations = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations();
        int n = launchConfigurations.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfiguration launchConfiguration = iLaunchConfigurationArray[n2];
            if (launchConfiguration.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", "").equals(projectName) && launchConfiguration.getType().getIdentifier().equals(this.getConfigurationName())) {
                configurations.add(launchConfiguration);
            }
            ++n2;
        }
        return configurations;
    }

    private static void removeMarker(IProject project) throws CoreException {
        IMarker[] markers;
        IMarker[] iMarkerArray = markers = project.findMarkers(GDB_PATH_OUTDATED_MARKER, false, 2);
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            marker.delete();
            ++n2;
        }
    }

    protected abstract void migrateWorkingCopy(ILaunchConfigurationWorkingCopy var1, IProject var2, String var3) throws CoreException;

    protected abstract String getDebuggerId();

    protected abstract String getConfigurationName();
}

