/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.migration.actions.launch;

import com.freescale.s32ds.cross.core.ProjectContextSettings;
import com.nxp.s32ds.cle.cdt.internal.migration.CdtMigrationActivator;
import com.nxp.s32ds.cle.cdt.internal.migration.Messages;
import com.nxp.s32ds.cle.cdt.migration.actions.launch.UpdateLaunchConfigurationActionBase;
import com.nxp.s32ds.cle.ide.launch.core.LaunchConfigurationUtil;
import com.nxp.s32ds.cle.runtime.migration.annotation.MigrationEntityAnnotation;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.osgi.util.NLS;

@MigrationEntityAnnotation(name="Update PNE debugger launch configuration.", description="Update PNE debugger launch configuration for specified toolchain ID.")
public class UpdatePneLaunchConfigurationAction
extends UpdateLaunchConfigurationActionBase {
    private static final String ATTR_PNE_DEB = "org.eclipse.cdt.dsf.gdb.DEBUG_NAME";

    @Override
    public String getConfigurationName() {
        return "com.pemicro.debug.gdbjtag.pne.launchConfigurationType";
    }

    @Override
    protected String getDebuggerId() {
        return "pne";
    }

    @Override
    protected void migrateWorkingCopy(ILaunchConfigurationWorkingCopy workingCopy, IProject project, String targetToolchain) throws CoreException {
        ProjectContextSettings projectContextSettings = new ProjectContextSettings(project);
        String deviceCoreId = projectContextSettings.getAttributeByKey("com.nxp.s32ds.cle.runtime.hardware.registry.deviceCore.id");
        if (deviceCoreId == null || deviceCoreId.isEmpty()) {
            throw new CoreException(CdtMigrationActivator.getInstance().createError(NLS.bind((String)Messages.UpdatePneLaunchConfigurationAction_cannot_fetch_devicecoreid_attribute_for_project_0, (Object)project.getName())));
        }
        String gdbClientValue = LaunchConfigurationUtil.getGDBClientValue((String)deviceCoreId, (String)this.getDebuggerId(), (String)targetToolchain);
        if (!"gdb".equals(gdbClientValue)) {
            workingCopy.setAttribute(ATTR_PNE_DEB, gdbClientValue);
        }
    }
}

