/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.migration.actions.project.configuration;

import com.nxp.s32ds.cle.cdt.migration.actions.project.configuration.ProjectSettingsOperation;
import com.nxp.s32ds.cle.cdt.project.configuration.core.ProjectConfigurationUtils;
import com.nxp.s32ds.cle.cdt.project.configuration.core.updaters.ProjectSettingsUpdater;
import com.nxp.s32ds.cle.cdt.project.configuration.core.updaters.ProjectSettingsUpdaters;
import com.nxp.s32ds.cle.runtime.migration.MigrationPostInitializationValidator;
import com.nxp.s32ds.cle.runtime.migration.action.MigrationAction;
import com.nxp.s32ds.cle.runtime.migration.annotation.MigrationEntityAnnotation;
import com.nxp.s32ds.cle.runtime.migration.annotation.MigrationPropertyAnnotation;
import com.nxp.s32ds.cle.runtime.migration.core.MigrationsAssert;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

@MigrationEntityAnnotation(name="Modify the value of the option for CDT toolchains and tools.", description="Modify (add, remove, replace, or clean) option's value for CDT toolchains and tools.")
public class ModifyToolchainOptionAction
implements MigrationAction,
MigrationPostInitializationValidator {
    @MigrationPropertyAnnotation(description="The 'add' operation adds target values.\nThe 'remove' operation removes target values.\nThe 'replace' operation clears the current values and sets new ones.\nThe 'clean' operation clears the current values.")
    private ProjectSettingsOperation operation;
    @MigrationPropertyAnnotation(description="The ID of option.")
    private String optionId;
    private static final String OPTION_VALUE = "optionValue";
    @MigrationPropertyAnnotation(name="optionValue", description="The value of option. Required for all operation except the clean.", minOccurs=0)
    private List<String> optionValues;

    public IStatus validate() {
        if (this.operation != ProjectSettingsOperation.CLEAN && MigrationsAssert.isEmpty(this.optionValues)) {
            return MigrationsAssert.propertyExpected((String)OPTION_VALUE);
        }
        return Status.OK_STATUS;
    }

    public void perform(IProject project, IProgressMonitor monitor) throws CoreException {
        ProjectSettingsUpdater optionUpdater = ProjectSettingsUpdaters.getOptionUpdater();
        MigrationsAssert.assertIsOk(ProjectConfigurationUtils.getProjectConfigurations((IProject)project).stream().map(c -> optionUpdater.update(c, this.optionId, this.optionValues, this.operation.getOperation())));
    }
}

