/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.migration.actions.toolchains;

import com.nxp.s32ds.cle.cdt.internal.migration.CdtMigrationActivator;
import com.nxp.s32ds.cle.runtime.migration.action.MigrationAction;
import com.nxp.s32ds.cle.runtime.migration.annotation.MigrationEntityAnnotation;
import com.nxp.s32ds.cle.runtime.migration.annotation.MigrationPropertyAnnotation;
import com.nxp.s32ds.cle.runtime.migration.property.MigrationProperty;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.WriteAccessException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;

@MigrationEntityAnnotation(name="Update C configurations.", description="Update C configurations id during migration for ARM 32 or ARM 64 toolchain.")
public class UpdateCConfigurationAction
implements MigrationAction {
    @MigrationPropertyAnnotation(description="Key / value map, defined as sub properties, used as templates for changing the configuration ID. The property name is a substring of the configuration ID that must be replaced with the property value.")
    private MigrationProperty configurationModificationPattern;

    public void perform(IProject project, IProgressMonitor monitor) throws CoreException {
        ICConfigurationDescription[] cconfigurations;
        ICProjectDescription description = CoreModel.getDefault().getProjectDescription(project, true);
        ICConfigurationDescription[] iCConfigurationDescriptionArray = cconfigurations = description.getConfigurations();
        int n = cconfigurations.length;
        int n2 = 0;
        while (n2 < n) {
            String newConfigId;
            ICConfigurationDescription config = iCConfigurationDescriptionArray[n2];
            String originalConfigId = config.getId();
            if (originalConfigId.equals(newConfigId = this.applyConfigIdModificationPattern(originalConfigId))) {
                return;
            }
            try {
                description.createConfiguration(newConfigId, config.getName(), config);
                description.removeConfiguration(config);
                CoreModel.getDefault().setProjectDescription(project, description);
            }
            catch (WriteAccessException e) {
                IStatus error = CdtMigrationActivator.getInstance().createError("Error during update C configuration", e);
                throw new CoreException(error);
            }
            ++n2;
        }
    }

    private String applyConfigIdModificationPattern(String originalValue) {
        for (MigrationProperty pattern : this.configurationModificationPattern.getProperties()) {
            String replaceFrom = pattern.getName();
            String replaceTo = pattern.getValue();
            if (!originalValue.contains(replaceFrom) || originalValue.contains(replaceTo)) continue;
            return originalValue.replace(replaceFrom, replaceTo);
        }
        return originalValue;
    }
}

