/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.project.info.internal.ui.wizards;

import com.nxp.s32ds.cle.cdt.project.info.core.exports.ProjectInfoExportSettings;
import com.nxp.s32ds.cle.cdt.project.info.core.exports.ProjectInfoExporter;
import com.nxp.s32ds.cle.cdt.project.info.internal.ui.Messages;
import com.nxp.s32ds.cle.cdt.project.info.internal.ui.ProjectImportUIActivator;
import com.nxp.s32ds.cle.cdt.sdk.core.attach.SdkAttachDataHolder;
import java.util.List;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.typed.PojoProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.databinding.wizard.WizardPageSupport;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ExportProjectInfoPage
extends WizardPage {
    private final ProjectInfoExportSettings settings;
    private final IProject project;
    private Button defaultPaths;
    private Button absolutePaths;
    private Text filePathText;

    public ExportProjectInfoPage(IProject project) {
        super(String.format(Messages.ExportProjectInfoPage_generate_pi_title, project.getName()));
        this.project = project;
        this.setTitle(this.getName());
        this.setDescription(NLS.bind((String)Messages.ExportProjectInfoPage_generate_pi_description, (Object)project.getName()));
        this.settings = new ProjectInfoExportSettings(project);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite panel = new Composite(parent, 0);
        DataBindingContext dbc = new DataBindingContext();
        GridDataFactory.fillDefaults().applyTo((Control)panel);
        panel.setLayout((Layout)new GridLayout(2, false));
        new Label(panel, 0).setText(Messages.ExportProjectInfoPage_select);
        ComboViewer configs = new ComboViewer(panel, 8);
        this.initConfigurationsCombo(configs);
        new Label(panel, 0).setText(Messages.ExportProjectInfoPage_use_default_paths);
        this.defaultPaths = new Button(panel, 16);
        new Label(panel, 0).setText(Messages.ExportProjectInfoPage_use_absolute_paths);
        this.absolutePaths = new Button(panel, 16);
        this.setControl((Control)panel);
        SelectPathStrategy strategy = new SelectPathStrategy(dbc);
        dbc.bindValue((IObservableValue)WidgetProperties.widgetSelection().observe((Widget)this.defaultPaths), PojoProperties.value((String)"defaultPaths").observe((Object)this.settings), (UpdateValueStrategy)strategy, null);
        dbc.bindValue((IObservableValue)WidgetProperties.widgetSelection().observe((Widget)this.absolutePaths), PojoProperties.value((String)"absolutePaths").observe((Object)this.settings), (UpdateValueStrategy)strategy, null);
        dbc.bindValue((IObservableValue)ViewerProperties.singleSelection().observe((Viewer)configs), PojoProperties.value((String)"configuration").observe((Object)this.settings));
        WizardPageSupport.create((WizardPage)this, (DataBindingContext)dbc);
    }

    public boolean isPageComplete() {
        if (!this.project.isAccessible() || !ProjectInfoExporter.canExportProject((IProject)this.project)) {
            this.setErrorMessage(Messages.ExportProjectInfoPage_not_c_project);
            return false;
        }
        if (CoreModel.getDefault().getProjectDescription(this.project) == null) {
            String errorText = NLS.bind((String)Messages.ExportProjectInfoPage_no_project_0_config, (Object)this.project.getName());
            this.setErrorMessage(errorText);
            ProjectImportUIActivator.getDefault().logWarning(errorText);
            return false;
        }
        if (this.settings.getDevice().isEmpty() && this.settings.getDeviceCore().isEmpty()) {
            String errorText = NLS.bind((String)Messages.ExportProjectInfoPage_no_hardware_in_project, (Object)this.project.getName());
            this.setErrorMessage(errorText);
            ProjectImportUIActivator.getDefault().logWarning(errorText);
            return false;
        }
        if (this.settings.getConfiguration() == null) {
            String errorText = NLS.bind((String)Messages.ExportProjectInfoPage_no_valid_config_in_project, (Object)this.project.getName());
            this.setErrorMessage(errorText);
            ProjectImportUIActivator.getDefault().logWarning(errorText);
            return false;
        }
        try {
            if (ExportProjectInfoPage.hasLinks((IContainer)this.project) || this.hasSDK()) {
                this.absolutePaths.setSelection(true);
                this.defaultPaths.setEnabled(false);
                this.setMessage(Messages.ExportProjectInfoPage_linker_resource_error, 2);
            }
        }
        catch (CoreException e) {
            ProjectImportUIActivator.getDefault().log(e.getStatus());
        }
        return super.isPageComplete();
    }

    private void initConfigurationsCombo(ComboViewer configs) {
        configs.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        configs.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof ICConfigurationDescription) {
                    return ((ICConfigurationDescription)element).getName();
                }
                return super.getText(element);
            }
        });
        List filteredDescriptions = this.settings.getApplicableConfigurations();
        if (!filteredDescriptions.isEmpty()) {
            this.settings.setConfiguration((ICConfigurationDescription)filteredDescriptions.get(0));
            configs.setInput((Object)filteredDescriptions);
        }
    }

    protected void createFileSelectionGroup(Composite parent) {
        Composite fileSelectionGroup = new Composite(parent, 0, parent){
            {
                this.setLayout((Layout)new GridLayout(2, false));
                this.setLayoutData(new GridData(768));
                this.setFont(composite.getFont());
            }
        };
        Label label = new Label(fileSelectionGroup, 0);
        label.setText(Messages.ExportProjectInfoPage_set_output);
        GridDataFactory.fillDefaults().span(2, -1).applyTo((Control)label);
        Text file = new Text(fileSelectionGroup, 2052);
        file.setLayoutData((Object)new GridData(768));
        Button browseButton = new Button(fileSelectionGroup, 8);
        browseButton.setText(Messages.ProjectInfoPage_browse);
        browseButton.setLayoutData((Object)new GridData());
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDialog = new FileDialog(ExportProjectInfoPage.this.getShell(), 8192);
                fileDialog.setFilterExtensions(new String[]{"*.xml"});
                String filePath = fileDialog.open();
                if (filePath != null) {
                    ExportProjectInfoPage.this.filePathText.setText(filePath);
                }
            }
        });
    }

    public ProjectInfoExportSettings getSettings() {
        return this.settings;
    }

    public static boolean hasLinks(IContainer container) throws CoreException {
        IResource[] iResourceArray = container.members();
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (resource.isLinked()) {
                return true;
            }
            if (resource instanceof IContainer && ExportProjectInfoPage.hasLinks((IContainer)resource)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean hasSDK() {
        return SdkAttachDataHolder.hasProjectAttachedSdks((String)this.project.getName());
    }

    private class SelectPathStrategy
    extends UpdateValueStrategy<Object, Object> {
        private final DataBindingContext dbc;

        public SelectPathStrategy(DataBindingContext dbc) {
            this.dbc = dbc;
        }

        public IStatus validateAfterConvert(Object value) {
            try {
                if (ExportProjectInfoPage.this.settings.getDefaultPaths().booleanValue()) {
                    if (ExportProjectInfoPage.this.hasSDK()) {
                        return ValidationStatus.error((String)Messages.ExportProjectInfoPage_cannot_export_sdk);
                    }
                    if (ExportProjectInfoPage.hasLinks((IContainer)ExportProjectInfoPage.this.project)) {
                        return ValidationStatus.error((String)Messages.ExportProjectInfoPage_cannot_export_link);
                    }
                }
                this.dbc.getValidationStatusProviders().stream().forEach(provider -> provider.getValidationStatus().setValue((Object)ValidationStatus.ok()));
                ExportProjectInfoPage.this.setPageComplete(true);
            }
            catch (CoreException e) {
                ProjectImportUIActivator.getDefault().log(e.getStatus());
                return ValidationStatus.error((String)e.getMessage());
            }
            return ValidationStatus.ok();
        }
    }
}

