/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.project.info.internal.ui.wizards;

import com.nxp.s32ds.cle.cdt.core.imports.ImportExportConfigurationUtil;
import com.nxp.s32ds.cle.cdt.project.info.core.imports.PIReader;
import com.nxp.s32ds.cle.cdt.project.info.core.imports.ProjectInfoImportSettings;
import com.nxp.s32ds.cle.cdt.project.info.core.imports.processors.IOptionProcessor;
import com.nxp.s32ds.cle.cdt.project.info.internal.ui.Messages;
import com.nxp.s32ds.cle.cdt.project.info.internal.ui.ProjectImportUIActivator;
import com.nxp.s32ds.cle.ide.debugger.registry.LaunchConfigurationCreator;
import com.nxp.s32ds.cle.runtime.hardware.reservation.registry.HardwareReservationDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.reservation.registry.core.HardwareReservationDescriptors;
import com.nxp.s32ds.ext.rcp.databinding.ValidationDescriptors;
import com.nxp.s32ds.ext.rcp.databinding.validation.CompositeValidator;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.bind.JAXBException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.beans.typed.PojoProperties;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.wizard.WizardPageSupport;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.WizardDataTransferPage;

public class ImportProjectInfoPage
extends WizardDataTransferPage {
    private static final String KEY_PATH = "keyPE_path";
    private static final String[] FILTER_NAMES = new String[]{"ProjectInfo.xml Files (ProjectInfo.xml)"};
    private static final String[] FILTER_EXTS = new String[]{"ProjectInfo.xml"};
    private static final String PI_RESERVATION_TYPE_PROJECT_TYPES = "s32ds.project.info.restricted.project.types";
    private Composite composite;
    private Label lblLProjectType;
    private Label lblConfiguration;
    private CCombo cmbProjectType;
    private CCombo cmbBuildCfg;
    private CCombo cmbLConfig;
    private Button btnLConfig;
    private final List<IProjectType> piProjectTypes;
    private final Map<LaunchConfigurationCreator, String> lcCreator2lcUIName;
    private final DataBindingContext dbc;
    private final ProjectInfoImportSettings settings;
    private CompositeValidator compositeNameValidator;
    private CompositeValidator compositePathValidator;
    private List<HardwareReservationDescriptor> reservationTypes;
    private PIReader currentReader;
    private IObservableValue<Long> dummyObserver = new AbstractObservableValue<Long>(){

        public Object getValueType() {
            return Object.class;
        }

        protected Long doGetValue() {
            return (Long)ImportProjectInfoPage.this.settings.getObservableUpdaterValue().doGetValue();
        }

        protected void doSetValue(Long value) {
        }
    };

    public ImportProjectInfoPage() {
        super(Messages.ImportProjectInfoPage_create_project_title);
        this.initValidators();
        this.setTitle(Messages.ImportProjectInfoPage_create_project_title);
        this.setDescription(Messages.ImportProjectInfoPage_create_project_description);
        this.dbc = new DataBindingContext();
        this.settings = new ProjectInfoImportSettings();
        this.piProjectTypes = new ArrayList<IProjectType>();
        this.lcCreator2lcUIName = new HashMap<LaunchConfigurationCreator, String>();
        this.currentReader = null;
        this.reservationTypes = HardwareReservationDescriptors.getHardwareReservationDescriptorByType((String)PI_RESERVATION_TYPE_PROJECT_TYPES);
    }

    private void initValidators() {
        List nameValidators = ValidationDescriptors.getValidatorDescriptorByGroupId((String)"project.name.validators");
        List pathValidators = ValidationDescriptors.getValidatorDescriptorByGroupId((String)"project.path.validators");
        this.compositeNameValidator = new CompositeValidator(nameValidators);
        this.compositePathValidator = new CompositeValidator(pathValidators);
    }

    public PIReader getPIReader() {
        return this.currentReader;
    }

    public void createControl(Composite parent) {
        this.composite = new Composite(parent, 0);
        this.composite.setLayout((Layout)new GridLayout(1, false));
        this.composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createProjectPanel(this.composite);
        Label lblSeparator = new Label(this.composite, 258);
        lblSeparator.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.createDebugConfigurationPanel(this.composite);
        this.setControl((Control)this.composite);
        UpdateValueStrategy<Long, Long> ptStrategy = this.createProjectTypeUpdateStrategy();
        this.dbc.bindValue(this.dummyObserver, (IObservableValue)this.settings.getObservableUpdaterValue(), null, ptStrategy);
        WizardPageSupport.create((WizardPage)this, (DataBindingContext)this.dbc);
        this.setPageComplete(false);
    }

    private void createDebugConfigurationPanel(Composite parent) {
        Composite base = new Composite(parent, 0);
        base.setLayout((Layout)new GridLayout(6, false));
        base.setLayoutData((Object)new GridData(4, 4, true, true));
        GridData cmbGridData = new GridData(4, 1024, true, false, 5, 1);
        this.lblLProjectType = new Label(base, 0);
        this.lblLProjectType.setText(Messages.ImportProjectInfoPage_select_pt);
        this.cmbProjectType = new CCombo(base, 2056);
        this.cmbProjectType.setLayoutData((Object)cmbGridData);
        this.cmbProjectType.setEnabled(false);
        this.cmbProjectType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = ImportProjectInfoPage.this.cmbProjectType.getSelectionIndex();
                ImportProjectInfoPage.this.updateUIOnNewPI(index);
                ImportProjectInfoPage.this.updateBuildConfiguration(index);
                ImportProjectInfoPage.this.settings.setPiReader(ImportProjectInfoPage.this.currentReader);
            }
        });
        this.lblConfiguration = new Label(base, 0);
        this.lblConfiguration.setText(Messages.ImportProjectInfoPage_select_bc);
        this.cmbBuildCfg = new CCombo(base, 2056);
        cmbGridData = new GridData(4, 1024, true, false, 5, 1);
        cmbGridData.verticalIndent = 3;
        this.cmbBuildCfg.setLayoutData((Object)cmbGridData);
        this.cmbBuildCfg.setEnabled(false);
        this.cmbBuildCfg.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportProjectInfoPage.this.setCBuildConfiguration();
            }
        });
        this.btnLConfig = new Button(base, 32);
        this.btnLConfig.setText(Messages.ImportProjectInfoPage_create_lc);
        this.btnLConfig.setSelection(false);
        this.btnLConfig.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean selected = ImportProjectInfoPage.this.btnLConfig.getSelection();
                ImportProjectInfoPage.this.cmbLConfig.setEnabled(selected);
                if (selected) {
                    ImportProjectInfoPage.this.setCreatorForSelectedLCId();
                } else {
                    ImportProjectInfoPage.this.settings.setLCCreator(null);
                }
            }
        });
        this.cmbLConfig = new CCombo(base, 2056);
        this.cmbLConfig.setLayoutData((Object)cmbGridData);
        this.cmbLConfig.setEnabled(false);
        this.cmbLConfig.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportProjectInfoPage.this.setCreatorForSelectedLCId();
            }
        });
    }

    private void setCreatorForSelectedLCId() {
        Map.Entry lcEntry = this.lcCreator2lcUIName.entrySet().stream().filter(entry -> ((String)entry.getValue()).equals(this.cmbLConfig.getText())).findFirst().get();
        if (lcEntry != null) {
            this.settings.setLCCreator((LaunchConfigurationCreator)lcEntry.getKey());
        }
    }

    private void setCBuildConfiguration() {
        IProjectType projectType = this.piProjectTypes.get(this.cmbProjectType.getSelectionIndex());
        String selectedConfigurationName = this.cmbBuildCfg.getItem(this.cmbBuildCfg.getSelectionIndex());
        IConfiguration selectedConfiguration = null;
        IConfiguration[] projectTypeConfigurations = this.getSupportedBuildConfigurationFrom(projectType.getConfigurations());
        if (projectTypeConfigurations.length > 0) {
            Optional<IConfiguration> optional = Arrays.stream(projectTypeConfigurations).filter(configuration -> selectedConfigurationName.equals(configuration.getName())).findFirst();
            selectedConfiguration = optional.isPresent() ? optional.get() : projectTypeConfigurations[0];
        }
        this.settings.setBuildConfiguration(selectedConfiguration);
    }

    private void updateBuildConfiguration(int index) {
        this.cmbBuildCfg.removeAll();
        this.cmbBuildCfg.setEnabled(true);
        IProjectType pt = this.piProjectTypes.get(index);
        IConfiguration[] configuration = this.getSupportedBuildConfigurationFrom(pt.getConfigurations());
        Stream.of(configuration).sorted((c1, c2) -> c1.getName().compareTo(c2.getName())).forEach(p -> this.cmbBuildCfg.add(p.getName()));
        this.cmbBuildCfg.select(0);
        this.cmbBuildCfg.notifyListeners(13, new Event());
    }

    private void createProjectPanel(Composite parent) {
        Composite projectPanel = new Composite(parent, 0);
        projectPanel.setLayout((Layout)new GridLayout(3, false));
        projectPanel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        new Label(projectPanel, 0).setText(Messages.ImportProjectInfoPage_xml_file);
        Text location = new Text(projectPanel, 2048);
        location.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        location.setEnabled(false);
        location.setText(" ");
        Button browse = new Button(projectPanel, 0);
        browse.setText(Messages.ProjectInfoPage_browse);
        browse.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        this.dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)location), PojoProperties.value((String)"piReader").observe((Object)this.settings), ImportProjectInfoPage.createFilePathValidationPolicy(), null);
        this.bindFileSelectorHook(location, browse);
        new Label(projectPanel, 0).setText(Messages.ImportProjectInfoPage_new_project_title);
        Text projectName = new Text(projectPanel, 2048);
        projectName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        ControlDecorationSupport.create((ValidationStatusProvider)this.dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)location), (IObservableValue)WidgetProperties.text().observe((Widget)projectName), this.createProjectNameFromPathStrategy(), null), (int)16512);
        ControlDecorationSupport.create((ValidationStatusProvider)this.dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)projectName), PojoProperties.value((String)"projectName").observe((Object)this.settings), this.createProjectNameStrategy(), null), (int)16512);
    }

    private void bindFileSelectorHook(final Text location, Button browse) {
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(ImportProjectInfoPage.this.composite.getShell(), 4096);
                dialog.setFilterNames(FILTER_NAMES);
                dialog.setFilterExtensions(FILTER_EXTS);
                dialog.setFileName(FILTER_EXTS[0]);
                dialog.setText(Messages.ImportProjectInfoPage_select_file);
                dialog.setFilterPath(ImportProjectInfoPage.loadSettings(ImportProjectInfoPage.KEY_PATH));
                String fileName = dialog.open();
                if (fileName != null) {
                    location.setText(fileName);
                    ImportProjectInfoPage.saveSettings(ImportProjectInfoPage.KEY_PATH, fileName);
                }
            }
        });
    }

    private void updateProjectTypes(Object value) {
        if (value != null) {
            this.clearPreviousPIData();
            HashSet pts = new HashSet();
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getShell());
            try {
                dialog.run(true, true, monitor -> {
                    monitor.beginTask(Messages.ImportProjectInfoPage_analyzing, 1);
                    String deviceCoreId = this.settings.getPiReader().getCoreId();
                    if (deviceCoreId != null && !deviceCoreId.isEmpty()) {
                        pts.addAll(ImportExportConfigurationUtil.getS32ProjectTypesByDeviceCoreId((String)deviceCoreId));
                    } else {
                        String deviceId = this.settings.getPiReader().getDeviceId();
                        if (deviceId != null && !deviceId.isEmpty()) {
                            pts.addAll(ImportExportConfigurationUtil.getS32ProjectTypesByDeviceId((String)deviceId));
                        }
                    }
                    monitor.worked(1);
                    monitor.done();
                });
            }
            catch (InterruptedException | InvocationTargetException e) {
                ProjectImportUIActivator.getDefault().logError(e.getMessage());
                Thread.currentThread().interrupt();
            }
            if (!pts.isEmpty()) {
                ArrayList<IProjectType> matchedList = new ArrayList<IProjectType>();
                for (IProjectType type : pts) {
                    for (HardwareReservationDescriptor descriptor : this.reservationTypes) {
                        if (!descriptor.getBuildObject().equals(type.getId())) continue;
                        matchedList.add(type);
                    }
                }
                pts.removeAll(matchedList);
                this.piProjectTypes.addAll(pts.stream().sorted((pt1, pt2) -> pt1.getName().compareTo(pt2.getName())).collect(Collectors.toList()));
            }
            this.piProjectTypes.stream().forEach(pt -> this.cmbProjectType.add(String.valueOf(pt.getName()) + " -> " + pt.getConfigurations()[0].getToolChain().getName()));
            this.updateUIOnNewPI(0);
            this.composite.getShell().pack(true);
        }
    }

    private void clearPreviousPIData() {
        this.piProjectTypes.clear();
        this.settings.setSelectedProjectType(null);
        this.settings.setLCCreator(null);
        this.cmbProjectType.removeAll();
        this.btnLConfig.setEnabled(false);
        this.cmbLConfig.removeAll();
    }

    private void updateUIOnNewPI(int index) {
        IProjectType pt = this.piProjectTypes.get(index);
        this.cmbProjectType.select(index);
        this.cmbProjectType.setEnabled(true);
        this.updateBuildConfiguration(index);
        this.settings.setSelectedProjectType(pt);
        this.settings.setLCCreator(null);
        this.lcCreator2lcUIName.clear();
        this.cmbLConfig.removeAll();
        boolean canCreateLC = !ImportExportConfigurationUtil.isLibrarySelected((IProjectType)pt);
        this.btnLConfig.setEnabled(canCreateLC);
        if (this.btnLConfig.getSelection() && !canCreateLC) {
            this.btnLConfig.setSelection(false);
        }
        this.cmbLConfig.setEnabled(canCreateLC && this.btnLConfig.getSelection());
        if (canCreateLC) {
            String deviceCoreId = this.settings.getPiReader().getCoreId();
            if (deviceCoreId != null) {
                this.lcCreator2lcUIName.putAll(ImportExportConfigurationUtil.getLaunchConfigurationTypesForDeviceCore((String)deviceCoreId, (String)pt.getConfigurations()[0].getToolChain().getSuperClass().getId()));
            } else {
                this.lcCreator2lcUIName.putAll(ImportExportConfigurationUtil.getLaunchConfigurationTypesForDevice((String)this.settings.getPiReader().getDeviceId(), (String)pt.getConfigurations()[0].getToolChain().getSuperClass().getId()));
            }
            if (!this.lcCreator2lcUIName.isEmpty()) {
                this.lcCreator2lcUIName.entrySet().stream().map(entry -> (String)entry.getValue()).sorted().forEach(id -> this.cmbLConfig.add(id));
                this.cmbLConfig.select(0);
                if (this.btnLConfig.getSelection()) {
                    this.setCreatorForSelectedLCId();
                }
            } else {
                this.btnLConfig.setSelection(false);
                this.btnLConfig.setEnabled(false);
            }
        }
    }

    public void handleEvent(Event event) {
    }

    protected boolean allowNewContainerName() {
        return true;
    }

    private UpdateValueStrategy<Long, Long> createProjectTypeUpdateStrategy() {
        UpdateValueStrategy ptStrategy = new UpdateValueStrategy();
        ptStrategy.setAfterGetValidator(value -> {
            IProjectType pt;
            if (this.settings.isInitialState()) {
                return ValidationStatus.ok();
            }
            this.setPageComplete(false);
            if (this.currentReader != this.settings.getPiReader()) {
                this.currentReader = this.settings.getPiReader();
                this.updateProjectTypes(this.currentReader);
            }
            if ((pt = this.settings.getSelectedProjectType()) == null) {
                return ValidationStatus.error((String)Messages.ImportProjectInfoPage_no_project_type_found);
            }
            IConfiguration[] icfgs = this.settings.getSelectedProjectType().getConfigurations();
            AtomicReference<IOptionProcessor> optionProcessor = new AtomicReference<IOptionProcessor>();
            IToolChain toolchain = icfgs[0].getToolChain();
            if (toolchain.getSuperClass() != null) {
                toolchain = toolchain.getSuperClass();
            }
            optionProcessor.set(this.settings.getSelectedToolChainOptionProcessor(toolchain));
            if (optionProcessor.get() == null) {
                return ValidationStatus.error((String)NLS.bind((String)Messages.ImportProjectInfoPage_no_processor_pt_0, (Object)toolchain.getId()));
            }
            this.setPageComplete(true);
            return ValidationStatus.ok();
        });
        return ptStrategy;
    }

    private IConfiguration[] getSupportedBuildConfigurationFrom(IConfiguration[] allConfiguration) {
        List supportedConfigurationIDs = this.settings.getPiReader().getSupportedBuildConfiguration();
        if (supportedConfigurationIDs == null || supportedConfigurationIDs.isEmpty()) {
            return allConfiguration;
        }
        return (IConfiguration[])Stream.of(allConfiguration).filter(c -> supportedConfigurationIDs.contains(c.getName())).toArray(IConfiguration[]::new);
    }

    private UpdateValueStrategy<String, String> createProjectNameStrategy() {
        UpdateValueStrategy strategy = new UpdateValueStrategy();
        strategy.setBeforeSetValidator(value -> {
            if (this.settings.isInitialState()) {
                return ValidationStatus.ok();
            }
            IStatus result = this.validateName((String)value);
            if (!result.isOK()) {
                return result;
            }
            result = this.validatePath(value);
            if (!result.isOK()) {
                return result;
            }
            return ValidationStatus.ok();
        });
        return strategy;
    }

    private IStatus validateName(String value) {
        return this.compositeNameValidator.validate(value);
    }

    private IStatus validatePath(Object value) {
        String path = ResourcesPlugin.getWorkspace().getRoot().getLocation().toString();
        String strPath = String.valueOf(path) + File.separator + value;
        return this.compositePathValidator.validate(strPath);
    }

    private UpdateValueStrategy<String, String> createProjectNameFromPathStrategy() {
        UpdateValueStrategy strategy = new UpdateValueStrategy();
        strategy.setConverter((IConverter)new IConverter<String, String>(){

            public Object getToType() {
                return String.class;
            }

            public Object getFromType() {
                return String.class;
            }

            public String convert(String fromObject) {
                try {
                    return ImportProjectInfoPage.this.generateProjectName(fromObject);
                }
                catch (Exception e) {
                    ProjectImportUIActivator.getDefault().logError(e.getMessage());
                    return "";
                }
            }
        });
        return strategy;
    }

    private static UpdateValueStrategy<String, PIReader> createFilePathValidationPolicy() {
        final AtomicReference<Object> piReader = new AtomicReference<Object>(null);
        UpdateValueStrategy updateStrategy = new UpdateValueStrategy();
        updateStrategy.setAfterGetValidator(valueStr -> {
            if (valueStr == null) {
                return ValidationStatus.error((String)Messages.ImportProjectInfoPage_wrong_value_type);
            }
            if (valueStr.isEmpty()) {
                piReader.set(null);
                return ValidationStatus.error((String)Messages.ImportProjectInfoPage_provide_file);
            }
            try {
                PIReader reader = new PIReader(valueStr);
                piReader.set(reader);
                return ValidationStatus.ok();
            }
            catch (IOException ioe) {
                piReader.set(null);
                String err = ioe.getMessage();
                ProjectImportUIActivator.getDefault().logError(err);
                return ValidationStatus.error((String)err);
            }
            catch (JAXBException jaxbe) {
                piReader.set(null);
                String err = jaxbe.getMessage();
                if (err == null) {
                    err = jaxbe.getLinkedException().getMessage();
                }
                if (err != null) {
                    ProjectImportUIActivator.getDefault().logError(err);
                    return ValidationStatus.error((String)NLS.bind((String)Messages.ImportProjectInfoPage_xml_format_broken, (Object)err));
                }
                return ValidationStatus.error((String)Messages.ImportProjectInfoPage_xml_format_error_unknown);
            }
        });
        updateStrategy.setConverter((IConverter)new IConverter<String, PIReader>(){

            public Object getToType() {
                return PIReader.class;
            }

            public Object getFromType() {
                return String.class;
            }

            public PIReader convert(String fromObject) {
                return (PIReader)piReader.get();
            }
        });
        return updateStrategy;
    }

    public ProjectInfoImportSettings getSettings() {
        return this.settings;
    }

    private String generateProjectName(Object fromObject) {
        String piPath;
        Path xml = Paths.get((String)fromObject, new String[0]);
        if (xml.getNameCount() > 1) {
            return xml.getParent().getFileName().toString();
        }
        if (this.settings.getPiReader() != null && (piPath = this.settings.getPiReader().getProjectInfoPath()) != null) {
            return Paths.get(piPath, new String[0]).getParent().getFileName().toString();
        }
        return String.valueOf(fromObject);
    }

    public static String loadSettings(String key) {
        return InstanceScope.INSTANCE.getNode(ProjectImportUIActivator.getDefault().getBundleId()).get(key, "");
    }

    public static void saveSettings(String key, String path) {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode(ProjectImportUIActivator.getDefault().getBundleId());
        prefs.put(key, path);
        try {
            prefs.flush();
        }
        catch (Exception e) {
            ProjectImportUIActivator.getDefault().logError(e.getMessage());
        }
    }
}

