/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.project.info.internal.ui.wizards;

import com.nxp.s32ds.cle.cdt.project.info.core.exports.ProjectInfoExporter;
import com.nxp.s32ds.cle.cdt.project.info.internal.ui.Messages;
import com.nxp.s32ds.cle.cdt.project.info.internal.ui.ProjectImportUIActivator;
import com.nxp.s32ds.cle.cdt.project.info.internal.ui.wizards.ExportProjectInfoPage;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.progress.UIJob;

public class ProjectInfoExportWizard
extends Wizard
implements IExportWizard {
    protected static final String WORKSPACE = ResourcesPlugin.getWorkspace().getRoot().getLocation().toString();
    private ExportProjectInfoPage mainPage;
    private IProject project;
    private String errorText;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        IProject result = (IProject)selection.getFirstElement();
        this.setWindowTitle(Messages.ProjectInfoExportWizard_export_error);
        if (result == null) {
            this.errorText = Messages.ProjectInfoExportWizard_no_project;
            return;
        }
        this.project = result;
        this.setWindowTitle(String.format(Messages.ProjectInfoExportWizard_wizard_title, this.project.getName()));
    }

    public boolean performFinish() {
        if (new ProjectInfoExporter(this.mainPage.getSettings()).writeProjectInfo()) {
            final IFile piFile = this.mainPage.getSettings().getOutputIFile();
            new UIJob("Open ProjectInfo.xml"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    try {
                        IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)piFile);
                        return Status.OK_STATUS;
                    }
                    catch (PartInitException e) {
                        ProjectImportUIActivator.getDefault().logError(e.getMessage());
                        return Status.CANCEL_STATUS;
                    }
                }
            }.schedule();
            return true;
        }
        return false;
    }

    public void addPages() {
        super.addPages();
        if (this.project != null) {
            this.mainPage = new ExportProjectInfoPage(this.project);
            this.addPage((IWizardPage)this.mainPage);
        }
    }

    public boolean canFinish() {
        return this.project != null && this.mainPage.isPageComplete();
    }

    public IWizardPage getStartingPage() {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        if (this.project == null) {
            shell.getDisplay().syncExec(() -> {
                boolean bl = MessageDialog.open((int)1, (Shell)shell, (String)Messages.ProjectInfoExportWizard_export_error, (String)this.errorText, (int)0);
            });
        }
        return super.getStartingPage();
    }
}

