/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.memory.spaces.internal.ui;

import com.nxp.s32ds.cle.cdt.memory.spaces.base.MemorySpace;
import com.nxp.s32ds.cle.cdt.memory.spaces.base.MemorySpaces;
import com.nxp.s32ds.cle.cdt.memory.spaces.internal.ui.Messages;
import com.nxp.s32ds.cle.runtime.memory.spaces.core.DeviceCoreMemorySpaceDescriptor;
import java.math.BigInteger;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class MemorySpacesDialog
extends Dialog {
    private Button butOK;
    private String titleText;
    private CCombo cmbMemSpaces;
    private static final BigInteger MAX_ADDRESS = BigInteger.ONE.shiftLeft(32).subtract(BigInteger.ONE);
    private MemorySpace selectedMemSpace;
    private BigInteger currentAddress;
    private final List<DeviceCoreMemorySpaceDescriptor> memorySpaces;

    public MemorySpacesDialog(Shell parentShell, String title, List<DeviceCoreMemorySpaceDescriptor> memorySpaces) {
        super(parentShell);
        this.titleText = title;
        this.memorySpaces = memorySpaces;
        this.currentAddress = null;
    }

    public Control createDialogArea(Composite parent) {
        Composite innerComposite = new Composite(parent, 2048);
        GridLayout gridLayout = new GridLayout(1, true);
        innerComposite.setLayout((Layout)gridLayout);
        GridData fill = new GridData(4, 4, true, true);
        fill.minimumWidth = 300;
        innerComposite.setLayoutData((Object)fill);
        Group groupGeneral = new Group(innerComposite, 0);
        groupGeneral.setText(Messages.MemorySpacesDialog_settings_text);
        groupGeneral.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        groupGeneral.setLayout((Layout)new GridLayout(2, false));
        Label lblAddress = new Label((Composite)groupGeneral, 0);
        lblAddress.setText(Messages.MemorySpacesDialog_address_hex_text);
        lblAddress.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        Text textAddress = new Text((Composite)groupGeneral, 2048);
        textAddress.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        textAddress.addVerifyListener(e -> {
            if (e.character != '\u0000') {
                e.doit = e.character == 'x' ? textAddress.getCaretPosition() == 1 && textAddress.getText().startsWith("0") : MemorySpacesDialog.isHex(e.character, textAddress.getText());
            } else if (e.text != null && !e.text.isEmpty()) {
                try {
                    String toParse = e.text;
                    if (toParse.startsWith("0x")) {
                        int selectionStart = text.getSelection().x;
                        if (selectionStart != 0) {
                            e.doit = false;
                            return;
                        }
                        if (textAddress.getText().startsWith("0x") && textAddress.getSelectionCount() < 2) {
                            e.doit = false;
                            return;
                        }
                        toParse = e.text.replaceFirst("0x", "");
                    }
                    if (!toParse.isEmpty()) {
                        Long.parseLong(toParse, 16);
                    }
                    e.doit = true;
                }
                catch (NumberFormatException numberFormatException) {
                    e.doit = false;
                }
            }
        });
        textAddress.addModifyListener(e -> {
            String value = textAddress.getText().replaceFirst("0x", "");
            if (!value.isEmpty()) {
                this.currentAddress = new BigInteger(value, 16);
                if (MAX_ADDRESS.compareTo(this.currentAddress) >= 0) {
                    this.butOK.setEnabled(true);
                } else {
                    this.butOK.setEnabled(false);
                }
            } else {
                this.currentAddress = null;
                this.butOK.setEnabled(false);
            }
        });
        Label lbl = new Label((Composite)groupGeneral, 0);
        lbl.setText(Messages.MemorySpacesDialog_memory_space_text);
        lbl.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.cmbMemSpaces = new CCombo((Composite)groupGeneral, 2048);
        this.cmbMemSpaces.setEditable(false);
        this.cmbMemSpaces.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.cmbMemSpaces.setItems(this.convertInput(this.memorySpaces));
        this.cmbMemSpaces.select(0);
        Composite buttons = new Composite(parent, 0);
        buttons.setLayout((Layout)new GridLayout(3, false));
        buttons.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.getShell().setText(this.titleText);
        parent.pack();
        return innerComposite;
    }

    private String[] convertInput(List<DeviceCoreMemorySpaceDescriptor> memorySpaces) {
        return memorySpaces.stream().map(DeviceCoreMemorySpaceDescriptor::getName).collect(Collectors.toList()).toArray(new String[0]);
    }

    public static boolean isHex(char input, String text) {
        return Character.isDigit(input) || Character.isISOControl(input) || "abcdef".contains(String.valueOf(input).toLowerCase());
    }

    public MemorySpace getMemorySpace() {
        return this.selectedMemSpace;
    }

    protected void okPressed() {
        this.selectedMemSpace = MemorySpaces.createMemorySpace((DeviceCoreMemorySpaceDescriptor)this.memorySpaces.get(this.cmbMemSpaces.getSelectionIndex()));
        this.selectedMemSpace.setBaseAddress(this.currentAddress);
        super.okPressed();
    }

    protected Control createButtonBar(Composite parent) {
        Control butBar = super.createButtonBar(parent);
        this.butOK = this.getButton(0);
        this.butOK.setText(Messages.MemorySpacesDialog_select_text);
        this.butOK.setEnabled(false);
        return butBar;
    }
}

